(ns jawsome-cli.test-pipeline
  "Code to make a CLI wrapper around jawsome-dsl"
  {:author "Matt Halverson"
   :date "2014/03/19"}
  (:require [roxxi.utils.print :refer [print-expr]])
  (:require [jawsome-cli.core :refer [def-cli-pipeline]])
  (:require [jawsome-dsl.xform :refer [defxform]]))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; USAGE

;;lein uberjar; cat /tmp/raw | java -jar /Users/mhalverson/Code/okl/danger-jawsome/jawsome-cli/target/jawsome-cli-0.1.0-SNAPSHOT-standalone.jar denorm | tee /tmp/denorm | java -jar /Users/mhalverson/Code/okl/danger-jawsome/jawsome-cli/target/jawsome-cli-0.1.0-SNAPSHOT-standalone.jar schema > /tmp/schema ; java -jar /Users/mhalverson/Code/okl/danger-jawsome/jawsome-cli/target/jawsome-cli-0.1.0-SNAPSHOT-standalone.jar project --input /tmp/denorm --schema-path /tmp/schema --output /tmp/blat

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ROADMAP

;;CLEANUP

;;Add to cli README that you probs want to include:
;; [com.onekingslane.danger/jawsome-cli "1.0.0"]
;; [com.onekingslane.danger/jawsome-dsl "1.0.0"]
;;Clean up cli README formatting.

;;DEPLOY

;;TODO make the schema step optionally output the ordered fields

;; figure out deploy strategy (see the color-api case)
 - setup logging
 - shell script to poll s3 buckets, pipe s3cmd into this, pipe into vsql, cleanup the denorm and schema files after the load
 - read from static schema file... (hopefully it doesn't change often!)

Ansible
 - install s3cmd
 - install vsql
 - git clone jawsome-pipeline-searchpro
 - lein uberjar
 - cron the shell script

ONE-OFF
 - create table
 - setup master schema file
 - quality checks

;; ~/Code/okl/danger-jawsome-pipelines/jawsome-pipeline-searchpro > ls -lh /Users/mhalverson/Data/search-2014-03-18/
;; total 292408
;; -rw-r--r--+ 1 mhalverson  staff   1.2M Mar 20 14:46 first1000.log
;; -rw-r--r--+ 1 mhalverson  staff   142M Mar 20 14:46 query.log
;; ~/Code/okl/danger-jawsome-pipelines/jawsome-pipeline-searchpro > time
;;
;; real	0m0.000s
;; user	0m0.000s
;; sys	0m0.000s
;; ~/Code/okl/danger-jawsome-pipelines/jawsome-pipeline-searchpro > date
;; Mon Mar 31 17:33:37 PDT 2014
;; ~/Code/okl/danger-jawsome-pipelines/jawsome-pipeline-searchpro > date; java -jar /Users/mhalverson/Code/okl/danger-jawsome-pipelines/jawsome-pipeline-searchpro/target/jawsome-pipeline-searchpro-0.1.0-SNAPSHOT-standalone.jar denorm --input /Users/mhalverson/Data/search-2014-03-18/query.log --output /tmp/denorm ; java -jar /Users/mhalverson/Code/okl/danger-jawsome-pipelines/jawsome-pipeline-searchpro/target/jawsome-pipeline-searchpro-0.1.0-SNAPSHOT-standalone.jar schema --input /tmp/denorm --output /tmp/schema ; java -jar /Users/mhalverson/Code/okl/danger-jawsome-pipelines/jawsome-pipeline-searchpro/target/jawsome-pipeline-searchpro-0.1.0-SNAPSHOT-standalone.jar project --input /tmp/denorm --schema-path /tmp/schema --header-path /tmp/header --output /tmp/project ; date
;; Mon Mar 31 17:33:42 PDT 2014
;; SLF4J: Failed to load class "org.slf4j.impl.StaticLoggerBinder".
;; SLF4J: Defaulting to no-operation (NOP) logger implementation
;; SLF4J: See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.
;; SLF4J: Failed to load class "org.slf4j.impl.StaticLoggerBinder".
;; SLF4J: Defaulting to no-operation (NOP) logger implementation
;; SLF4J: See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.
;; SLF4J: Failed to load class "org.slf4j.impl.StaticLoggerBinder".
;; SLF4J: Defaulting to no-operation (NOP) logger implementation
;; SLF4J: See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.
;; Mon Mar 31 17:58:17 PDT 2014

;;USE
