(ns com.omarpolo.robotto.effect)

(defn queue-http-request
  "Queue the HTTP request `req` onto the `ctx`."
  [ctx req]
  (update ctx ::reqs conj req))

(defn send-message
  "Send a message."
  [ctx {:keys [chat-id text parse-mode opts] :or {opts {}}}]
  (queue-http-request ctx {:name 'sendMessage
                           :params (merge opts {:text text
                                                :chat_id chat-id
                                                :parse-mode parse-mode})}))

(defn reply-message
  "Send a message in the same chat as the given message.  If `:reply-to`
  is true, the message sent will be a reply."
  [ctx {{{cid :id} :chat, mid :message_id} :message, :keys [text reply parse-mode opts]}]
  (send-message ctx {:chat-id cid, :text text, :parse-mode parse-mode
                     :opts (cond-> opts
                             reply (assoc :reply_to_message_id mid))}))

(defn delete-message
  "Delete the message with the given id in the given chat.`"
  [ctx {:keys [message-id chat-id]}]
  (queue-http-request ctx {:name 'deleteMessage
                           :params {:chat_id chat-id
                                    :message_id message-id}}))

(defn get-chat
  "Get info about the chat given its id."
  [ctx chat-id]
  (queue-http-request ctx {:name 'getChat
                           :chat_id chat-id}))
