/*
 * Decompiled with CFR 0.152.
 */
package com.omarnyte.logger;

import com.omarnyte.exception.LoggerException;
import com.omarnyte.logger.LogFormatter;
import com.omarnyte.middleware.Middleware;
import com.omarnyte.request.Request;
import com.omarnyte.response.Response;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger
extends Middleware {
    private String dateTimePattern;
    private String logDirectoryPath;
    private File logFile;
    private LogFormatter logFormatter = new LogFormatter();

    public Logger(String logDirectoryPath, String dateTimePattern) throws LoggerException {
        this.logDirectoryPath = logDirectoryPath;
        this.dateTimePattern = dateTimePattern;
    }

    @Override
    public Request applyMiddleware(Request request) {
        String requestFormattedForLogger = this.logFormatter.formatRequest(request);
        this.logEntry(requestFormattedForLogger);
        return this.checkNext(request);
    }

    @Override
    public Response applyMiddleware(Response response) {
        String responseFormattedForLogger = this.logFormatter.formatResponse(response);
        this.logEntry(responseFormattedForLogger);
        return this.checkNext(response);
    }

    public File createLogFile() throws LoggerException {
        try {
            String logFileName = this.getFormattedTime() + ".txt";
            this.logFile = new File(this.logDirectoryPath + "/" + logFileName);
            this.logFile.createNewFile();
            return this.logFile;
        }
        catch (IOException e) {
            throw new LoggerException("Could not create log file in path: " + this.logDirectoryPath);
        }
    }

    public void logEntry(String entry) {
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.logFile, true));){
            writer.println(entry);
        }
        catch (IOException e) {
            System.err.println("Could not log entry: " + entry);
        }
    }

    private String getFormattedTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateTimePattern);
        return dateFormat.format(new Date());
    }
}

