/*
 * Decompiled with CFR 0.152.
 */
package com.omarnyte.authentication;

import com.omarnyte.authentication.Credentials;
import com.omarnyte.middleware.Middleware;
import com.omarnyte.request.Request;
import java.util.Base64;
import java.util.List;

public class Authenticator
extends Middleware {
    private String authRoute;
    private Credentials credentials;
    private List<String> protectedUris;

    public Authenticator(Credentials credentials, List<String> protectedUris, String authRoute) {
        this.credentials = credentials;
        this.protectedUris = protectedUris;
        this.authRoute = authRoute;
    }

    @Override
    public Request applyMiddleware(Request request) {
        try {
            return this.isProtected(request.getURI()) ? this.validateCredentials(request) : request;
        }
        catch (NullPointerException e) {
            return this.buildRequestToAuthRoute(request.getMethod());
        }
    }

    private boolean isProtected(String uri) {
        return this.protectedUris.contains(uri) || this.isProtectedChild(uri);
    }

    private boolean isProtectedChild(String uri) {
        for (String protectedUri : this.protectedUris) {
            if (!uri.matches(protectedUri + "/.+")) continue;
            return true;
        }
        return false;
    }

    private Request validateCredentials(Request request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            return this.buildRequestToAuthRoute(request.getMethod());
        }
        String[] splitDecodedCredentials = this.getSplitDecodedCredentials(authHeader);
        return this.identicalCredentials(splitDecodedCredentials) ? request : this.buildRequestToAuthRoute(request.getMethod());
    }

    private String[] getSplitDecodedCredentials(String authHeader) throws NullPointerException {
        String[] splitAuthHeader = authHeader.split(" ");
        String encodedCredentials = splitAuthHeader[1];
        Base64.Decoder decoder = Base64.getDecoder();
        String decodedCredentials = new String(decoder.decode(encodedCredentials));
        return decodedCredentials.split(":");
    }

    private boolean identicalCredentials(String[] splitDecodedCredentials) {
        String username = splitDecodedCredentials[0];
        String password = splitDecodedCredentials[1];
        return this.credentials.areValidCredentials(username, password);
    }

    private Request buildRequestToAuthRoute(String method) {
        return new Request.Builder().method(method).uri(this.authRoute).build();
    }
}

