`accumulator`
=============

A Clojure library designed to provide a simple configurable core.async batch
accumulator process.

## Usage

```bash
lein repl
```

```clj
(load "olauzon/accumulator")

(require '[olauzon.accumulator :as acc]
         '[clojure.core.async :as async]
         '[clojure.core.async :refer [thread
                                      chan
                                      >!!
                                      <!!
                                      timeout
                                      close!
                                      take!
                                      put!]])

(def b-out (chan 5))

(acc/get! 5 10000 b-out :pool-key-00  "t-key-value" :open)

(defn populate
  []
  (thread
    (loop [i (int 0)]
      (println i)
      (>!! ((acc/get! 5 10000 b-out :pool-key-00  "t-key" :open) :e-in) i)
      (recur (inc i)))))

(populate)

(take! b-out println)

(take! b-out println)

(take! b-out println)
(take! b-out println)
```

## License

Copyright © 2014 Olivier Lauzon

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
