/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.model.event;

import com.olacabs.fabric.model.event.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class EventSet {
    private final int sourceId;
    private final int partitionId;
    private final boolean isSourceGenerated;
    private final List<Event> events;
    private long id;
    private long transactionId;
    private Map<String, Object> meta;
    private boolean isAggregate;

    private EventSet(long id, int sourceId, int partitionId, List<Event> events, long transactionId, Map<String, Object> meta) {
        this.id = id;
        this.sourceId = sourceId;
        this.partitionId = partitionId;
        this.events = events;
        this.meta = meta;
        this.isSourceGenerated = -1 != this.sourceId;
        this.transactionId = transactionId;
    }

    private EventSet(int partitionId, List<Event> events, boolean isAggregate) {
        this.id = Long.MAX_VALUE;
        this.partitionId = partitionId;
        this.isAggregate = isAggregate;
        this.events = events;
        this.sourceId = -1;
        this.isSourceGenerated = false;
        this.meta = Collections.emptyMap();
    }

    public static EventFromSourceBuilder eventFromSourceBuilder() {
        return new EventFromSourceBuilder();
    }

    public static EventFromEventBuilder eventFromEventBuilder() {
        return new EventFromEventBuilder();
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public boolean isSourceGenerated() {
        return this.isSourceGenerated;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public static class EventFromEventBuilder {
        private int partitionId;
        private ArrayList<Event> events;
        private boolean isAggregate;

        EventFromEventBuilder() {
        }

        public EventFromEventBuilder partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public EventFromEventBuilder event(Event event) {
            if (this.events == null) {
                this.events = new ArrayList();
            }
            this.events.add(event);
            return this;
        }

        public EventFromEventBuilder events(Collection<? extends Event> events) {
            if (this.events == null) {
                this.events = new ArrayList();
            }
            this.events.addAll(events);
            return this;
        }

        public EventFromEventBuilder clearEvents() {
            if (this.events != null) {
                this.events.clear();
            }
            return this;
        }

        public EventFromEventBuilder isAggregate(boolean isAggregate) {
            this.isAggregate = isAggregate;
            return this;
        }

        public EventSet build() {
            List<Object> events;
            switch (this.events == null ? 0 : this.events.size()) {
                case 0: {
                    events = Collections.emptyList();
                    break;
                }
                case 1: {
                    events = Collections.singletonList(this.events.get(0));
                    break;
                }
                default: {
                    events = Collections.unmodifiableList(new ArrayList<Event>(this.events));
                }
            }
            return new EventSet(this.partitionId, events, this.isAggregate);
        }

        public String toString() {
            return "EventSet.EventFromEventBuilder(partitionId=" + this.partitionId + ", events=" + this.events + ", isAggregate=" + this.isAggregate + ")";
        }
    }

    public static class EventFromSourceBuilder {
        private long id;
        private int sourceId;
        private int partitionId;
        private ArrayList<Event> events;
        private long transactionId;
        private ArrayList<String> meta$key;
        private ArrayList<Object> meta$value;

        EventFromSourceBuilder() {
        }

        public EventFromSourceBuilder id(long id) {
            this.id = id;
            return this;
        }

        public EventFromSourceBuilder sourceId(int sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public EventFromSourceBuilder partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public EventFromSourceBuilder event(Event event) {
            if (this.events == null) {
                this.events = new ArrayList();
            }
            this.events.add(event);
            return this;
        }

        public EventFromSourceBuilder events(Collection<? extends Event> events) {
            if (this.events == null) {
                this.events = new ArrayList();
            }
            this.events.addAll(events);
            return this;
        }

        public EventFromSourceBuilder clearEvents() {
            if (this.events != null) {
                this.events.clear();
            }
            return this;
        }

        public EventFromSourceBuilder transactionId(long transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public EventFromSourceBuilder meta(String metaKey, Object metaValue) {
            if (this.meta$key == null) {
                this.meta$key = new ArrayList();
                this.meta$value = new ArrayList();
            }
            this.meta$key.add(metaKey);
            this.meta$value.add(metaValue);
            return this;
        }

        public EventFromSourceBuilder meta(Map<? extends String, ? extends Object> meta) {
            if (this.meta$key == null) {
                this.meta$key = new ArrayList();
                this.meta$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : meta.entrySet()) {
                this.meta$key.add($lombokEntry.getKey());
                this.meta$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public EventFromSourceBuilder clearMeta() {
            if (this.meta$key != null) {
                this.meta$key.clear();
                this.meta$value.clear();
            }
            return this;
        }

        public EventSet build() {
            Map<Object, Object> meta;
            List<Object> events;
            switch (this.events == null ? 0 : this.events.size()) {
                case 0: {
                    events = Collections.emptyList();
                    break;
                }
                case 1: {
                    events = Collections.singletonList(this.events.get(0));
                    break;
                }
                default: {
                    events = Collections.unmodifiableList(new ArrayList<Event>(this.events));
                }
            }
            switch (this.meta$key == null ? 0 : this.meta$key.size()) {
                case 0: {
                    meta = Collections.emptyMap();
                    break;
                }
                case 1: {
                    meta = Collections.singletonMap(this.meta$key.get(0), this.meta$value.get(0));
                    break;
                }
                default: {
                    meta = new LinkedHashMap(this.meta$key.size() < 0x40000000 ? 1 + this.meta$key.size() + (this.meta$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.meta$key.size(); ++$i) {
                        meta.put(this.meta$key.get($i), this.meta$value.get($i));
                    }
                    meta = Collections.unmodifiableMap(meta);
                }
            }
            return new EventSet(this.id, this.sourceId, this.partitionId, events, this.transactionId, meta);
        }

        public String toString() {
            return "EventSet.EventFromSourceBuilder(id=" + this.id + ", sourceId=" + this.sourceId + ", partitionId=" + this.partitionId + ", events=" + this.events + ", transactionId=" + this.transactionId + ", meta$key=" + this.meta$key + ", meta$value=" + this.meta$value + ")";
        }
    }
}

