/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.model.common.sources;

import com.olacabs.fabric.model.common.ComponentSource;
import com.olacabs.fabric.model.common.ComponentSourceType;
import com.olacabs.fabric.model.common.ComponentSourceVisitor;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ArtifactoryComponentSource
extends ComponentSource {
    @NotNull
    @NotEmpty
    private String artifactoryUrl;
    @NotNull
    @NotEmpty
    private String groupId;
    @NotNull
    @NotEmpty
    private String artifactId;
    @NotNull
    @NotEmpty
    private String version;
    private String repositorySnapshotsPrefix;
    private String repositoryReleasesPrefix;

    public ArtifactoryComponentSource() {
        super(ComponentSourceType.artifactory);
    }

    public ArtifactoryComponentSource(String artifactoryUrl, String groupId, String artifactId, String version) {
        this();
        this.artifactoryUrl = artifactoryUrl;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactoryComponentSource that = (ArtifactoryComponentSource)o;
        if (!this.artifactoryUrl.equals(that.artifactoryUrl)) {
            return false;
        }
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.artifactoryUrl.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    @Override
    public void accept(ComponentSourceVisitor visitor) {
        visitor.visit(this);
    }

    public static ArtifactoryComponentSourceBuilder builder() {
        return new ArtifactoryComponentSourceBuilder();
    }

    public String getArtifactoryUrl() {
        return this.artifactoryUrl;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRepositorySnapshotsPrefix() {
        return this.repositorySnapshotsPrefix;
    }

    public String getRepositoryReleasesPrefix() {
        return this.repositoryReleasesPrefix;
    }

    public void setArtifactoryUrl(String artifactoryUrl) {
        this.artifactoryUrl = artifactoryUrl;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setRepositorySnapshotsPrefix(String repositorySnapshotsPrefix) {
        this.repositorySnapshotsPrefix = repositorySnapshotsPrefix;
    }

    public void setRepositoryReleasesPrefix(String repositoryReleasesPrefix) {
        this.repositoryReleasesPrefix = repositoryReleasesPrefix;
    }

    public static class ArtifactoryComponentSourceBuilder {
        private String artifactoryUrl;
        private String groupId;
        private String artifactId;
        private String version;

        ArtifactoryComponentSourceBuilder() {
        }

        public ArtifactoryComponentSourceBuilder artifactoryUrl(String artifactoryUrl) {
            this.artifactoryUrl = artifactoryUrl;
            return this;
        }

        public ArtifactoryComponentSourceBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public ArtifactoryComponentSourceBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public ArtifactoryComponentSourceBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ArtifactoryComponentSource build() {
            return new ArtifactoryComponentSource(this.artifactoryUrl, this.groupId, this.artifactId, this.version);
        }

        public String toString() {
            return "ArtifactoryComponentSource.ArtifactoryComponentSourceBuilder(artifactoryUrl=" + this.artifactoryUrl + ", groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ")";
        }
    }
}

