/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.model.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PropertyConstraint {
    private static final Logger log = LoggerFactory.getLogger(PropertyConstraint.class);
    private String property;
    private ValueConstraint valueConstraint;
    private List<DependencyConstraint> dependencyConstraints;

    PropertyConstraint(String property, ValueConstraint valueConstraint, List<DependencyConstraint> dependencyConstraints) {
        this.property = property;
        this.valueConstraint = valueConstraint;
        this.dependencyConstraints = dependencyConstraints;
    }

    public static PropertyConstraintBuilder builder() {
        return new PropertyConstraintBuilder();
    }

    public String getProperty() {
        return this.property;
    }

    public ValueConstraint getValueConstraint() {
        return this.valueConstraint;
    }

    public List<DependencyConstraint> getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setValueConstraint(ValueConstraint valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    public void setDependencyConstraints(List<DependencyConstraint> dependencyConstraints) {
        this.dependencyConstraints = dependencyConstraints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyConstraint)) {
            return false;
        }
        PropertyConstraint other = (PropertyConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        ValueConstraint this$valueConstraint = this.getValueConstraint();
        ValueConstraint other$valueConstraint = other.getValueConstraint();
        if (this$valueConstraint == null ? other$valueConstraint != null : !((Object)this$valueConstraint).equals(other$valueConstraint)) {
            return false;
        }
        List<DependencyConstraint> this$dependencyConstraints = this.getDependencyConstraints();
        List<DependencyConstraint> other$dependencyConstraints = other.getDependencyConstraints();
        return !(this$dependencyConstraints == null ? other$dependencyConstraints != null : !((Object)this$dependencyConstraints).equals(other$dependencyConstraints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyConstraint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        ValueConstraint $valueConstraint = this.getValueConstraint();
        result = result * 59 + ($valueConstraint == null ? 43 : ((Object)$valueConstraint).hashCode());
        List<DependencyConstraint> $dependencyConstraints = this.getDependencyConstraints();
        result = result * 59 + ($dependencyConstraints == null ? 43 : ((Object)$dependencyConstraints).hashCode());
        return result;
    }

    public String toString() {
        return "PropertyConstraint(property=" + this.getProperty() + ", valueConstraint=" + this.getValueConstraint() + ", dependencyConstraints=" + this.getDependencyConstraints() + ")";
    }

    public static class PropertyConstraintBuilder {
        private String property;
        private ValueConstraint valueConstraint;
        private List<DependencyConstraint> dependencyConstraints;

        PropertyConstraintBuilder() {
        }

        public PropertyConstraintBuilder property(String property) {
            this.property = property;
            return this;
        }

        public PropertyConstraintBuilder valueConstraint(ValueConstraint valueConstraint) {
            this.valueConstraint = valueConstraint;
            return this;
        }

        public PropertyConstraintBuilder dependencyConstraints(List<DependencyConstraint> dependencyConstraints) {
            this.dependencyConstraints = dependencyConstraints;
            return this;
        }

        public PropertyConstraint build() {
            return new PropertyConstraint(this.property, this.valueConstraint, this.dependencyConstraints);
        }

        public String toString() {
            return "PropertyConstraint.PropertyConstraintBuilder(property=" + this.property + ", valueConstraint=" + this.valueConstraint + ", dependencyConstraints=" + this.dependencyConstraints + ")";
        }
    }

    public static enum Operator {
        LIKE,
        IN,
        EXISTS,
        EQUALS,
        NOTEQUALS,
        GREATER,
        LESSER,
        GEQ,
        LEQ;

    }

    public static class DependencyConstraint {
        private String property;
        private Operator operator;
        private String value;

        DependencyConstraint(String property, Operator operator, String value) {
            this.property = property;
            this.operator = operator;
            this.value = value;
        }

        public static DependencyConstraintBuilder builder() {
            return new DependencyConstraintBuilder();
        }

        public String getProperty() {
            return this.property;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setOperator(Operator operator) {
            this.operator = operator;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyConstraint)) {
                return false;
            }
            DependencyConstraint other = (DependencyConstraint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            Operator this$operator = this.getOperator();
            Operator other$operator = other.getOperator();
            if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DependencyConstraint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            Operator $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "PropertyConstraint.DependencyConstraint(property=" + this.getProperty() + ", operator=" + (Object)((Object)this.getOperator()) + ", value=" + this.getValue() + ")";
        }

        public static class DependencyConstraintBuilder {
            private String property;
            private Operator operator;
            private String value;

            DependencyConstraintBuilder() {
            }

            public DependencyConstraintBuilder property(String property) {
                this.property = property;
                return this;
            }

            public DependencyConstraintBuilder operator(Operator operator) {
                this.operator = operator;
                return this;
            }

            public DependencyConstraintBuilder value(String value) {
                this.value = value;
                return this;
            }

            public DependencyConstraint build() {
                return new DependencyConstraint(this.property, this.operator, this.value);
            }

            public String toString() {
                return "PropertyConstraint.DependencyConstraint.DependencyConstraintBuilder(property=" + this.property + ", operator=" + (Object)((Object)this.operator) + ", value=" + this.value + ")";
            }
        }
    }

    public static class ValueConstraint {
        private String defaultValue;
        private List<String> valueDomain;

        ValueConstraint(String defaultValue, List<String> valueDomain) {
            this.defaultValue = defaultValue;
            this.valueDomain = valueDomain;
        }

        public static ValueConstraintBuilder builder() {
            return new ValueConstraintBuilder();
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public List<String> getValueDomain() {
            return this.valueDomain;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setValueDomain(List<String> valueDomain) {
            this.valueDomain = valueDomain;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueConstraint)) {
                return false;
            }
            ValueConstraint other = (ValueConstraint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            List<String> this$valueDomain = this.getValueDomain();
            List<String> other$valueDomain = other.getValueDomain();
            return !(this$valueDomain == null ? other$valueDomain != null : !((Object)this$valueDomain).equals(other$valueDomain));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValueConstraint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            List<String> $valueDomain = this.getValueDomain();
            result = result * 59 + ($valueDomain == null ? 43 : ((Object)$valueDomain).hashCode());
            return result;
        }

        public String toString() {
            return "PropertyConstraint.ValueConstraint(defaultValue=" + this.getDefaultValue() + ", valueDomain=" + this.getValueDomain() + ")";
        }

        public static class ValueConstraintBuilder {
            private String defaultValue;
            private List<String> valueDomain;

            ValueConstraintBuilder() {
            }

            public ValueConstraintBuilder defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public ValueConstraintBuilder valueDomain(List<String> valueDomain) {
                this.valueDomain = valueDomain;
                return this;
            }

            public ValueConstraint build() {
                return new ValueConstraint(this.defaultValue, this.valueDomain);
            }

            public String toString() {
                return "PropertyConstraint.ValueConstraint.ValueConstraintBuilder(defaultValue=" + this.defaultValue + ", valueDomain=" + this.valueDomain + ")";
            }
        }
    }
}

