/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.model.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.olacabs.fabric.model.common.ComponentSource;
import com.olacabs.fabric.model.common.ComponentType;
import com.olacabs.fabric.model.common.PropertyConstraint;
import com.olacabs.fabric.model.processor.ProcessorType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ComponentMetadata {
    @NotNull
    @NotEmpty
    private String id = UUID.randomUUID().toString();
    @NotNull
    private ComponentType type;
    @NotNull
    @NotEmpty
    private String namespace;
    @NotNull
    @NotEmpty
    private String name;
    @NotNull
    @NotEmpty
    private String version;
    private String description;
    private ProcessorType processorType;
    @Deprecated
    private List<String> requiredFields = new ArrayList<String>();
    private List<String> requiredProperties = new ArrayList<String>();
    private List<String> optionalProperties = new ArrayList<String>();
    private List<PropertyConstraint> propertyDescriptions = new ArrayList<PropertyConstraint>();
    private double cpu;
    private double memory;
    @NotNull
    @Valid
    private ComponentSource source;

    public ComponentMetadata(String id, ComponentType type, String namespace, String name, String version, String description, ProcessorType processorType, List<String> requiredFields, List<String> requiredProperties, List<String> optionalProperties, List<PropertyConstraint> propertyDescriptions, double cpu, double memory, ComponentSource source) {
        this.id = id;
        this.type = type;
        this.namespace = namespace;
        this.name = name;
        this.version = version;
        this.description = description;
        this.processorType = processorType;
        this.requiredFields = requiredFields;
        this.requiredProperties = requiredProperties;
        this.optionalProperties = optionalProperties;
        this.propertyDescriptions = propertyDescriptions;
        this.cpu = cpu;
        this.memory = memory;
        this.source = source;
    }

    public static ComponentMetadataBuilder builder() {
        return new ComponentMetadataBuilder();
    }

    public String getId() {
        return this.id;
    }

    public ComponentType getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public ProcessorType getProcessorType() {
        return this.processorType;
    }

    @Deprecated
    public List<String> getRequiredFields() {
        return this.requiredFields;
    }

    public List<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public List<String> getOptionalProperties() {
        return this.optionalProperties;
    }

    public List<PropertyConstraint> getPropertyDescriptions() {
        return this.propertyDescriptions;
    }

    public double getCpu() {
        return this.cpu;
    }

    public double getMemory() {
        return this.memory;
    }

    public ComponentSource getSource() {
        return this.source;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(ComponentType type) {
        this.type = type;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProcessorType(ProcessorType processorType) {
        this.processorType = processorType;
    }

    @Deprecated
    public void setRequiredFields(List<String> requiredFields) {
        this.requiredFields = requiredFields;
    }

    public void setRequiredProperties(List<String> requiredProperties) {
        this.requiredProperties = requiredProperties;
    }

    public void setOptionalProperties(List<String> optionalProperties) {
        this.optionalProperties = optionalProperties;
    }

    public void setPropertyDescriptions(List<PropertyConstraint> propertyDescriptions) {
        this.propertyDescriptions = propertyDescriptions;
    }

    public void setCpu(double cpu) {
        this.cpu = cpu;
    }

    public void setMemory(double memory) {
        this.memory = memory;
    }

    public void setSource(ComponentSource source) {
        this.source = source;
    }

    public String toString() {
        return "ComponentMetadata(id=" + this.getId() + ", type=" + (Object)((Object)this.getType()) + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", processorType=" + (Object)((Object)this.getProcessorType()) + ", requiredFields=" + this.getRequiredFields() + ", requiredProperties=" + this.getRequiredProperties() + ", optionalProperties=" + this.getOptionalProperties() + ", propertyDescriptions=" + this.getPropertyDescriptions() + ", cpu=" + this.getCpu() + ", memory=" + this.getMemory() + ", source=" + this.getSource() + ")";
    }

    public ComponentMetadata() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentMetadata)) {
            return false;
        }
        ComponentMetadata other = (ComponentMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComponentMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public static class ComponentMetadataBuilder {
        private String id;
        private ComponentType type;
        private String namespace;
        private String name;
        private String version;
        private String description;
        private ProcessorType processorType;
        private List<String> requiredFields;
        private List<String> requiredProperties;
        private List<String> optionalProperties;
        private List<PropertyConstraint> propertyDescriptions;
        private double cpu;
        private double memory;
        private ComponentSource source;

        ComponentMetadataBuilder() {
        }

        public ComponentMetadataBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ComponentMetadataBuilder type(ComponentType type) {
            this.type = type;
            return this;
        }

        public ComponentMetadataBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ComponentMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ComponentMetadataBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ComponentMetadataBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ComponentMetadataBuilder processorType(ProcessorType processorType) {
            this.processorType = processorType;
            return this;
        }

        public ComponentMetadataBuilder requiredFields(List<String> requiredFields) {
            this.requiredFields = requiredFields;
            return this;
        }

        public ComponentMetadataBuilder requiredProperties(List<String> requiredProperties) {
            this.requiredProperties = requiredProperties;
            return this;
        }

        public ComponentMetadataBuilder optionalProperties(List<String> optionalProperties) {
            this.optionalProperties = optionalProperties;
            return this;
        }

        public ComponentMetadataBuilder propertyDescriptions(List<PropertyConstraint> propertyDescriptions) {
            this.propertyDescriptions = propertyDescriptions;
            return this;
        }

        public ComponentMetadataBuilder cpu(double cpu) {
            this.cpu = cpu;
            return this;
        }

        public ComponentMetadataBuilder memory(double memory) {
            this.memory = memory;
            return this;
        }

        public ComponentMetadataBuilder source(ComponentSource source) {
            this.source = source;
            return this;
        }

        public ComponentMetadata build() {
            return new ComponentMetadata(this.id, this.type, this.namespace, this.name, this.version, this.description, this.processorType, this.requiredFields, this.requiredProperties, this.optionalProperties, this.propertyDescriptions, this.cpu, this.memory, this.source);
        }

        public String toString() {
            return "ComponentMetadata.ComponentMetadataBuilder(id=" + this.id + ", type=" + (Object)((Object)this.type) + ", namespace=" + this.namespace + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", processorType=" + (Object)((Object)this.processorType) + ", requiredFields=" + this.requiredFields + ", requiredProperties=" + this.requiredProperties + ", optionalProperties=" + this.optionalProperties + ", propertyDescriptions=" + this.propertyDescriptions + ", cpu=" + this.cpu + ", memory=" + this.memory + ", source=" + this.source + ")";
        }
    }
}

