/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.tracking;

import java.util.Arrays;

public class SimpleBitSet {
    private static final int NUM_BITS_IN_WORD = 64;
    private final int nBits;
    private int numWords;
    private long[] words;

    public SimpleBitSet(int nBits) {
        assert (nBits > 0);
        this.nBits = nBits;
        this.numWords = (nBits + 64 - 1) / 64;
        this.words = new long[this.numWords];
        Arrays.fill(this.words, 0L);
    }

    public void set(int index) {
        int pos = index / 64;
        long bits = index - pos * this.numWords;
        long mask = 1L << (int)bits;
        int n = pos;
        this.words[n] = this.words[n] | mask;
    }

    public void unset(int index) {
        int pos = index / 64;
        long bits = index - pos * this.numWords;
        long mask = 1L << (int)bits ^ 0xFFFFFFFFFFFFFFFFL;
        int n = pos;
        this.words[n] = this.words[n] & mask;
    }

    public int cardinality() {
        int count = 0;
        for (int i = 0; i < this.numWords; ++i) {
            count += Long.bitCount(this.words[i]);
        }
        return count;
    }

    public boolean hasSetBits() {
        boolean anyBitsSet = false;
        for (int i = 0; i < this.numWords; ++i) {
            boolean bl = anyBitsSet = anyBitsSet || this.words[i] != 0L;
            if (anyBitsSet) break;
        }
        return anyBitsSet;
    }
}

