/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.processor;

import com.codahale.metrics.MetricRegistry;
import com.olacabs.fabric.compute.EventCollector;
import com.olacabs.fabric.compute.ProcessingContext;
import com.olacabs.fabric.compute.processor.InitializationException;
import com.olacabs.fabric.compute.processor.ProcessingException;
import com.olacabs.fabric.model.common.ComponentMetadata;
import com.olacabs.fabric.model.common.PropertyConstraint;
import com.olacabs.fabric.model.event.Event;
import com.olacabs.fabric.model.event.EventSet;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public abstract class ProcessorBase {
    private final boolean isScheduled;
    private String id;
    private MetricRegistry metricRegistry;

    protected ProcessorBase(boolean isScheduled) {
        this.isScheduled = isScheduled;
    }

    public abstract void initialize(String var1, Properties var2, Properties var3, ComponentMetadata var4) throws InitializationException;

    public abstract void process(ProcessingContext var1, EventCollector var2, EventSet var3) throws ProcessingException;

    public abstract List<Event> timeTriggerHandler(ProcessingContext var1) throws ProcessingException;

    public abstract void destroy();

    public boolean healthcheck() {
        return true;
    }

    public List<PropertyConstraint> getPropertyConstraints() {
        return Collections.emptyList();
    }

    public boolean isScheduled() {
        return this.isScheduled;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }
}

