/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.pipeline;

import com.olacabs.fabric.model.event.EventSet;

public class PipelineMessage {
    private final Type messageType;
    private final EventSet messages;
    private final PipelineMessage parent;

    PipelineMessage(Type messageType) {
        this.messageType = messageType;
        this.messages = null;
        this.parent = null;
    }

    public PipelineMessage(EventSet messages, PipelineMessage parent) {
        this.messageType = Type.USERSPACE;
        this.messages = messages;
        this.parent = parent;
    }

    public static PipelineMessage timerMessageBuilder() {
        return new PipelineMessage(Type.TIMER);
    }

    public static PipelineMessageBuilder userspaceMessageBuilder() {
        return new PipelineMessageBuilder();
    }

    public Type getMessageType() {
        return this.messageType;
    }

    public EventSet getMessages() {
        return this.messages;
    }

    public PipelineMessage getParent() {
        return this.parent;
    }

    public static class PipelineMessageBuilder {
        private EventSet messages;
        private PipelineMessage parent;

        PipelineMessageBuilder() {
        }

        public PipelineMessageBuilder messages(EventSet messages) {
            this.messages = messages;
            return this;
        }

        public PipelineMessageBuilder parent(PipelineMessage parent) {
            this.parent = parent;
            return this;
        }

        public PipelineMessage build() {
            return new PipelineMessage(this.messages, this.parent);
        }

        public String toString() {
            return "PipelineMessage.PipelineMessageBuilder(messages=" + this.messages + ", parent=" + this.parent + ")";
        }
    }

    public static enum Type {
        TIMER,
        USERSPACE;

    }
}

