/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.pipeline;

import com.olacabs.fabric.compute.pipeline.NotificationBus;
import com.olacabs.fabric.compute.pipeline.PipelineMessage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ClockPulseGenerator {
    private final int id;
    private final long notificationPeriod;
    private final NotificationBus notificationBus;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture clockFuture = null;

    public ClockPulseGenerator(int id, long notificationPeriod, NotificationBus notificationBus) {
        this.id = id;
        this.notificationPeriod = notificationPeriod;
        this.notificationBus = notificationBus;
    }

    public void start() {
        this.clockFuture = this.executorService.scheduleAtFixedRate(() -> this.notificationBus.publish(PipelineMessage.timerMessageBuilder(), this.id), this.notificationPeriod, this.notificationPeriod, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (null != this.clockFuture) {
            this.clockFuture.cancel(true);
        }
        this.executorService.shutdownNow();
    }

    public static ClockPulseGeneratorBuilder builder() {
        return new ClockPulseGeneratorBuilder();
    }

    public static class ClockPulseGeneratorBuilder {
        private int id;
        private long notificationPeriod;
        private NotificationBus notificationBus;

        ClockPulseGeneratorBuilder() {
        }

        public ClockPulseGeneratorBuilder id(int id) {
            this.id = id;
            return this;
        }

        public ClockPulseGeneratorBuilder notificationPeriod(long notificationPeriod) {
            this.notificationPeriod = notificationPeriod;
            return this;
        }

        public ClockPulseGeneratorBuilder notificationBus(NotificationBus notificationBus) {
            this.notificationBus = notificationBus;
            return this;
        }

        public ClockPulseGenerator build() {
            return new ClockPulseGenerator(this.id, this.notificationPeriod, this.notificationBus);
        }

        public String toString() {
            return "ClockPulseGenerator.ClockPulseGeneratorBuilder(id=" + this.id + ", notificationPeriod=" + this.notificationPeriod + ", notificationBus=" + this.notificationBus + ")";
        }
    }
}

