/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.comms;

import com.olacabs.fabric.compute.comms.BlockingQueueCommsChannel;
import com.olacabs.fabric.compute.comms.ChannelType;
import com.olacabs.fabric.compute.comms.CommsChannel;
import com.olacabs.fabric.compute.comms.CommsMessageHandler;
import com.olacabs.fabric.compute.comms.DisruptorCommsChannel;
import com.olacabs.fabric.compute.comms.DisruptorWaitStrategy;
import com.olacabs.fabric.compute.util.MetaConstants;
import java.util.Properties;

public final class ChannelFactory {
    private ChannelFactory() {
    }

    public static <E> CommsChannel<E> create(Properties properties, String name, boolean isSingleProducer, CommsMessageHandler<E> handler) {
        String channelType = (String)properties.getOrDefault((Object)MetaConstants.getComputationKey("channel.channel_type"), ChannelType.BLOCKING_QUEUE.toString());
        if ((channelType = channelType.trim()).equalsIgnoreCase(ChannelType.BLOCKING_QUEUE.toString())) {
            return new BlockingQueueCommsChannel<E>(name, isSingleProducer, handler);
        }
        int bufferSize = Integer.valueOf((String)properties.getOrDefault((Object)MetaConstants.getComputationKey("disruptor.buffer_size"), "64"));
        String waitStrategy = (String)properties.getOrDefault((Object)MetaConstants.getComputationKey("disruptor.wait_strategy"), DisruptorWaitStrategy.BLOCK.toString());
        waitStrategy = waitStrategy.trim();
        waitStrategy = waitStrategy.toLowerCase();
        return new DisruptorCommsChannel<E>(name, isSingleProducer, waitStrategy, bufferSize, handler);
    }
}

