/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.builder.impl;

import com.google.common.collect.Maps;
import com.olacabs.fabric.compute.builder.Loader;
import com.olacabs.fabric.compute.builder.impl.JarScanner;
import com.olacabs.fabric.compute.processor.ProcessorBase;
import com.olacabs.fabric.compute.source.PipelineSource;
import com.olacabs.fabric.model.common.ComponentMetadata;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DownloadingLoader
implements Loader {
    private static final Comparator<ComponentMetadata> METADATA_COMPARATOR = (lhs, rhs) -> String.format("%s:%s:%s", lhs.getNamespace(), lhs.getName(), lhs.getVersion()).compareTo(String.format("%s:%s:%s", rhs.getNamespace(), rhs.getName(), rhs.getVersion()));
    private final Map<ComponentMetadata, PipelineSource> registeredSources = Maps.newTreeMap(METADATA_COMPARATOR);
    private final Map<ComponentMetadata, ProcessorBase> registeredProcessors = Maps.newTreeMap(METADATA_COMPARATOR);
    private JarScanner jarScanner = new JarScanner();

    @Override
    public PipelineSource loadSource(ComponentMetadata source) {
        return this.registeredSources.get(source);
    }

    @Override
    public ProcessorBase loadProcessor(ComponentMetadata processor) {
        return this.registeredProcessors.get(processor);
    }

    @Override
    public int getSourceCount() {
        return this.registeredSources.size();
    }

    @Override
    public int getProcessorCount() {
        return this.registeredProcessors.size();
    }

    public void loadJars(Collection<String> urls, ClassLoader classLoader) throws Exception {
        List<JarScanner.ScanResult> results = this.jarScanner.loadJars(urls, classLoader);
        results.forEach(this::handleScanResult);
    }

    private void handleScanResult(JarScanner.ScanResult scanResult) {
        switch (scanResult.getMetadata().getType()) {
            case PROCESSOR: {
                try {
                    ProcessorBase processorInstance = (ProcessorBase)scanResult.getComponentClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.registeredProcessors.put(scanResult.getMetadata(), processorInstance);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating processor: ", e);
                }
            }
            case SOURCE: {
                try {
                    PipelineSource sourceInstance = (PipelineSource)scanResult.getComponentClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.registeredSources.put(scanResult.getMetadata(), sourceInstance);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating processor: ", e);
                }
            }
        }
    }
}

