/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.pipelined;

import com.google.common.collect.ImmutableList;
import com.olacabs.fabric.compute.ProcessingContext;
import com.olacabs.fabric.compute.pipelined.TestEvent;
import com.olacabs.fabric.compute.source.PipelineSource;
import com.olacabs.fabric.model.common.ComponentMetadata;
import com.olacabs.fabric.model.event.Event;
import com.olacabs.fabric.model.event.RawEventBundle;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryBasedPipelineStreamPipelineSource
implements PipelineSource {
    private static final Logger log = LoggerFactory.getLogger(MemoryBasedPipelineStreamPipelineSource.class);
    private final Random random = new Random();
    private int i = 0;
    private int maxEmitCount = 10;
    private List<Event> events = ImmutableList.builder().add((Object)new TestEvent("A", 1)).add((Object)new TestEvent("B", 1)).add((Object)new TestEvent("C", 1)).add((Object)new TestEvent("D", 1)).add((Object)new TestEvent("E", 1)).add((Object)new TestEvent("F", 1)).build();

    public void initialize(String instanceId, Properties globalProperties, Properties properties, ProcessingContext processingContext, ComponentMetadata sourceMetadata) throws Exception {
    }

    public RawEventBundle getNewEvents() {
        int size;
        if (this.i++ == this.maxEmitCount) {
            try {
                Thread.sleep(50000L);
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
        }
        size = (size = this.random.nextInt(5)) == 0 ? 5 : size;
        return RawEventBundle.builder().events(this.events.subList(0, size)).meta(Collections.emptyMap()).build();
    }

    public static MemoryBasedPipelineStreamPipelineSourceBuilder builder() {
        return new MemoryBasedPipelineStreamPipelineSourceBuilder();
    }

    public MemoryBasedPipelineStreamPipelineSource() {
    }

    public MemoryBasedPipelineStreamPipelineSource(int i, int maxEmitCount, List<Event> events) {
        this.i = i;
        this.maxEmitCount = maxEmitCount;
        this.events = events;
    }

    public static class MemoryBasedPipelineStreamPipelineSourceBuilder {
        private int i;
        private int maxEmitCount;
        private List<Event> events;

        MemoryBasedPipelineStreamPipelineSourceBuilder() {
        }

        public MemoryBasedPipelineStreamPipelineSourceBuilder i(int i) {
            this.i = i;
            return this;
        }

        public MemoryBasedPipelineStreamPipelineSourceBuilder maxEmitCount(int maxEmitCount) {
            this.maxEmitCount = maxEmitCount;
            return this;
        }

        public MemoryBasedPipelineStreamPipelineSourceBuilder events(List<Event> events) {
            this.events = events;
            return this;
        }

        public MemoryBasedPipelineStreamPipelineSource build() {
            return new MemoryBasedPipelineStreamPipelineSource(this.i, this.maxEmitCount, this.events);
        }

        public String toString() {
            return "MemoryBasedPipelineStreamPipelineSource.MemoryBasedPipelineStreamPipelineSourceBuilder(i=" + this.i + ", maxEmitCount=" + this.maxEmitCount + ", events=" + this.events + ")";
        }
    }
}

