/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.pipelined;

import com.google.common.collect.Maps;
import com.olacabs.fabric.compute.ProcessingContext;
import com.olacabs.fabric.compute.pipelined.TestEvent;
import com.olacabs.fabric.compute.processor.InitializationException;
import com.olacabs.fabric.compute.processor.ProcessingException;
import com.olacabs.fabric.compute.processor.ScheduledProcessor;
import com.olacabs.fabric.model.common.ComponentMetadata;
import com.olacabs.fabric.model.common.PropertyConstraint;
import com.olacabs.fabric.model.event.Event;
import com.olacabs.fabric.model.event.EventSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class CountingProcessor
extends ScheduledProcessor {
    private Map<String, Long> counts = Maps.newHashMap();

    protected void consume(ProcessingContext context, EventSet eventSet) throws ProcessingException {
        eventSet.getEvents().forEach(event -> {
            TestEvent testEvent = (TestEvent)((Object)event);
            if (!this.counts.containsKey(testEvent.getMarker())) {
                this.counts.put(testEvent.getMarker(), 0L);
            }
            try {
                this.counts.put(testEvent.getMarker(), this.counts.get(testEvent.getMarker()) + 1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void initialize(String instanceId, Properties globalProperties, Properties initializationProperties, ComponentMetadata componentMetadata) throws InitializationException {
    }

    public List<Event> timeTriggerHandler(ProcessingContext context) throws ProcessingException {
        ArrayList flattenedEvent = this.counts.entrySet().stream().map(stringLongEntry -> Event.builder().data(stringLongEntry).build()).collect(Collectors.toCollection(ArrayList::new));
        this.counts = Maps.newHashMap();
        return flattenedEvent;
    }

    public void destroy() {
    }

    public List<PropertyConstraint> getPropertyConstraints() {
        return Collections.singletonList(PropertyConstraint.builder().property("to").dependencyConstraints(Collections.singletonList(PropertyConstraint.DependencyConstraint.builder().property("from").operator(PropertyConstraint.Operator.GEQ).value("0").build())).valueConstraint(PropertyConstraint.ValueConstraint.builder().defaultValue("100").build()).build());
    }
}

