/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute;

import com.google.common.collect.ImmutableList;
import com.olacabs.fabric.compute.ProcessingContext;
import com.olacabs.fabric.compute.ProcessorTestBench;
import com.olacabs.fabric.compute.processor.InitializationException;
import com.olacabs.fabric.compute.processor.ProcessingException;
import com.olacabs.fabric.compute.processor.ScheduledProcessor;
import com.olacabs.fabric.model.common.ComponentMetadata;
import com.olacabs.fabric.model.event.Event;
import com.olacabs.fabric.model.event.EventSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorTestBenchTest {
    private static final Logger log = LoggerFactory.getLogger(ProcessorTestBenchTest.class);

    @Test
    public void testRunScheduledProcessor() throws Exception {
        Counter counter = new Counter();
        List<EventSet> events = new ProcessorTestBench(true).runScheduledProcessor(counter, 1000L, 2L, Collections.singletonList(EventSet.eventFromEventBuilder().events((Collection)ImmutableList.of((Object)Event.builder().data(Collections.singletonMap("a", 1)).build())).build()));
        long totalCount = events.stream().mapToLong(eventSet -> eventSet.getEvents().stream().mapToLong(event -> (Long)((Map)event.getData()).get("counter")).sum()).sum();
        Assert.assertEquals((long)1L, (long)totalCount);
    }

    private static class Counter
    extends ScheduledProcessor {
        private long counter;

        private Counter() {
        }

        protected void consume(ProcessingContext context, EventSet eventSet) throws ProcessingException {
            ++this.counter;
        }

        public void initialize(String instanceId, Properties globalProperties, Properties initializationProperties, ComponentMetadata componentMetadata) throws InitializationException {
            this.counter = 0L;
        }

        public List<Event> timeTriggerHandler(ProcessingContext context) throws ProcessingException {
            long oldCounter = this.counter;
            this.counter = 0L;
            return Collections.singletonList(Event.builder().data(Collections.singletonMap("counter", oldCounter)).build());
        }

        public void destroy() {
        }
    }
}

