/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.olacabs.fabric.common.util.metrics.MetricFactory;
import com.olacabs.fabric.compute.builder.ComponentUrlResolver;
import com.olacabs.fabric.compute.builder.Linker;
import com.olacabs.fabric.compute.builder.Loader;
import com.olacabs.fabric.compute.builder.impl.DownloadingLoader;
import com.olacabs.fabric.compute.pipeline.ComputationPipeline;
import com.olacabs.fabric.model.computation.ComputationSpec;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineTestBench {
    private static final Logger log = LoggerFactory.getLogger(PipelineTestBench.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ScheduledReporter reporter;
    private final MetricRegistry metricRegistry;

    public PipelineTestBench() {
        this.metricRegistry = MetricFactory.getMetricRegistry();
        this.metricRegistry.timer("consume-timer");
        this.reporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).build();
    }

    public PipelineTestBench(String dirPath) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dirPath) ? 1 : 0) != 0, (Object)"Provide a non-null and non-empty filePath");
        File dir = new File(dirPath);
        Preconditions.checkArgument((dir.exists() || dir.mkdirs() ? 1 : 0) != 0, (Object)"Provide a directory path which either exists or can be created");
        this.metricRegistry = MetricFactory.getMetricRegistry();
        this.reporter = CsvReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(dir);
    }

    private void startReporter() {
        if (this.reporter != null) {
            this.reporter.start(1L, TimeUnit.SECONDS);
            log.info("Metrics reporter started");
        }
    }

    private void stopReporter() {
        if (this.reporter != null) {
            this.reporter.stop();
            log.info("Metrics reporter stopped");
        }
    }

    public PipelineWrapper run(ComputationSpec spec) throws Exception {
        DownloadingLoader loader = new DownloadingLoader();
        ImmutableSet.Builder componentSourceSetBuilder = ImmutableSet.builder();
        spec.getSources().forEach(sourceMeta -> componentSourceSetBuilder.add((Object)sourceMeta.getMeta().getSource()));
        spec.getProcessors().forEach(processorMeta -> componentSourceSetBuilder.add((Object)processorMeta.getMeta().getSource()));
        Collection resolvedUrls = ComponentUrlResolver.urls((Collection)componentSourceSetBuilder.build());
        loader.loadJars(resolvedUrls, Thread.currentThread().getContextClassLoader());
        log.info("Component Jar URLs: {}", (Object)resolvedUrls);
        Linker linker = new Linker((Loader)loader, this.metricRegistry);
        log.info(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)spec));
        ComputationPipeline pipeline = linker.build(spec);
        this.startReporter();
        return new PipelineWrapper(this.reporter, pipeline.initialize(spec.getProperties()).start());
    }

    public static class PipelineWrapper {
        private final ScheduledReporter reporter;
        private final ComputationPipeline pipeline;

        public void stop() {
            this.pipeline.stop();
            this.reporter.stop();
        }

        public PipelineWrapper(ScheduledReporter reporter, ComputationPipeline pipeline) {
            this.reporter = reporter;
            this.pipeline = pipeline;
        }
    }
}

