/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.common.util;

import com.google.common.base.Strings;
import java.util.Properties;

public final class PropertyReader {
    private PropertyReader() {
    }

    public static Boolean readBoolean(Properties properties, Properties globalProperties, String propertyName) {
        return PropertyReader.readBoolean(properties, globalProperties, propertyName, null);
    }

    public static Boolean readBoolean(Properties properties, Properties globalProperties, String propertyName, Boolean defaultValue) {
        String repr = null;
        if (null != properties) {
            repr = properties.getProperty(propertyName);
        }
        if (Strings.isNullOrEmpty(repr)) {
            if (null != globalProperties) {
                repr = globalProperties.getProperty(propertyName);
            }
            if (Strings.isNullOrEmpty((String)repr)) {
                return defaultValue;
            }
        }
        return Boolean.parseBoolean(repr);
    }

    public static Integer readInt(Properties properties, Properties globalProperties, String propertyName) {
        return PropertyReader.readInt(properties, globalProperties, propertyName, null);
    }

    public static Integer readInt(Properties properties, Properties globalProperties, String propertyName, Integer defaultValue) {
        String repr = null;
        if (null != properties) {
            repr = properties.getProperty(propertyName);
        }
        if (Strings.isNullOrEmpty(repr)) {
            if (null != globalProperties) {
                repr = globalProperties.getProperty(propertyName);
            }
            if (Strings.isNullOrEmpty((String)repr)) {
                return defaultValue;
            }
        }
        return Integer.parseInt(repr);
    }

    public static Long readLong(Properties properties, Properties globalProperties, String propertyName) {
        return PropertyReader.readLong(properties, globalProperties, propertyName, null);
    }

    public static Long readLong(Properties properties, Properties globalProperties, String propertyName, Long defaultValue) {
        String repr = null;
        if (null != properties) {
            repr = properties.getProperty(propertyName);
        }
        if (Strings.isNullOrEmpty(repr)) {
            if (null != globalProperties) {
                repr = globalProperties.getProperty(propertyName);
            }
            if (Strings.isNullOrEmpty((String)repr)) {
                return defaultValue;
            }
        }
        return Long.parseLong(repr);
    }

    public static String readString(Properties properties, Properties globalProperties, String propertyName) {
        return PropertyReader.readString(properties, globalProperties, propertyName, null);
    }

    public static String readString(Properties properties, Properties globalProperties, String propertyName, String defaultValue) {
        String repr = properties.getProperty(propertyName);
        if (Strings.isNullOrEmpty((String)repr) && Strings.isNullOrEmpty((String)(repr = globalProperties.getProperty(propertyName)))) {
            return defaultValue;
        }
        return repr;
    }
}

