package soac.java.bloom;

public class PersistentDigitTrie {
	public static final int RADIX = 7;

	// Array of objects. Can itself contain an array of objects.
	Object[] root;
	// The maximal size/length of a child node (1 if leaf node)
	int rDepth; // equivalent to RADIX ** (depth - 1), number of elements - 1

	public Object lookup(int key) {
		Object[] node = this.root;

		for (int size = this.rDepth; size > 1; size /= RADIX) {
			node = (Object[]) node[(key / size) % RADIX];
		}
		// Last element is the value we want to lookup, return it.
		return node[key % RADIX];
	}
}
