package soac.java.bloom;

// A persistent tree a la Clojure vectors, optionally with primitives at the
// leaves, and with fixed length.
public class PersistentBitTrie {
	public static final int BITS = 5,
			WIDTH = 1 << BITS, // 2^5 = 32
			MASK = WIDTH - 1; // 31, or 0x1f

	// Array of objects. Can itself contain an array of objects.
	Object[] root;
	// BITS times (the depth of this trie minus one).
	int shift;

	public Object lookup(int key) {
		Object[] node = this.root;

		// perform branching on internal nodes here
		for (int level = this.shift; level > 0; level -= BITS) {
			node = (Object[]) node[(key >>> level) & MASK];
		}
		// Last element is the value we want to lookup, return it.
		return node[key & MASK];
	}  
}
