package soac.java.bloom;

public class Hasher {
	private Hasher() {
	}

	//Murmurhash3, but only on a fixed-width int, and only returning positive values
	public static int murmur3(final int i, final int seed){
		final int c1 = 0xcc9e2d51;
		final int c2 = 0x1b873593;

		int h1 = seed;

		int k1 = i;
		k1 *= c1;
		k1 = (k1 << 15) | (k1 >>> 17);  // ROTL32(k1,15);
		k1 *= c2;

		h1 ^= k1;
		h1 = (h1 << 13) | (h1 >>> 19);  // ROTL32(h1,13);
		h1 = h1 * 5 + 0xe6546b64;

		// finalization
		h1 ^= 4;

		// fmix(h1);
		h1 ^= h1 >>> 16;
		h1 *= 0x85ebca6b;
		h1 ^= h1 >>> 13;
		h1 *= 0xc2b2ae35;
		h1 ^= h1 >>> 16;

		final int mask = h1 >> 31;
		return (h1 + mask) ^ mask;
	}
}
