/*
 * Decompiled with CFR 0.152.
 */
package nuroko.coders;

import java.util.ArrayList;
import java.util.List;
import mikera.vectorz.AVector;
import nuroko.coders.AbstractCoder;
import nuroko.core.ICoder;

public class MixedListCoder
extends AbstractCoder<List<?>> {
    private final int listLength;
    private final ICoder<?>[] itemCoders;
    private final int codeLength;

    public MixedListCoder(ICoder<?> ... itemCoders) {
        this.listLength = itemCoders.length;
        this.itemCoders = (ICoder[])itemCoders.clone();
        int cl = 0;
        for (ICoder<?> c : itemCoders) {
            cl += c.codeLength();
        }
        this.codeLength = cl;
    }

    @Override
    public List<?> decode(AVector v, int offset) {
        ArrayList al = new ArrayList();
        for (int i = 0; i < this.listLength; ++i) {
            ICoder<?> c = this.itemCoders[i];
            al.add(c.decode(v, offset));
            offset += c.codeLength();
        }
        return al;
    }

    @Override
    public void encode(List<?> list, AVector dest, int offset) {
        for (int i = 0; i < this.listLength; ++i) {
            ICoder<?> c = this.itemCoders[i];
            Object item = list.get(i);
            c.encode(item, dest, offset);
            offset += c.codeLength();
        }
    }

    @Override
    public int codeLength() {
        return this.codeLength;
    }
}

