/*
 * Decompiled with CFR 0.152.
 */
package nuroko.coders;

import mikera.vectorz.AVector;
import nuroko.coders.AbstractCoder;
import nuroko.coders.CharCoder;
import nuroko.core.NurokoException;

public class FixedStringCoder
extends AbstractCoder<String> {
    private final int stringLength;
    private static final CharCoder charCoder = new CharCoder();
    private static final int itemLength = charCoder.codeLength();

    public FixedStringCoder(int length) {
        this.stringLength = length;
    }

    @Override
    public String decode(AVector v, int offset) {
        char c;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.stringLength && (c = charCoder.decodeChar(v, offset + i * itemLength)) != '\u0000'; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void encode(String s, AVector dest, int offset) {
        if (s.length() > this.stringLength) {
            throw new NurokoException("String length [" + s.length() + "] exceeds fixed encoder size");
        }
        int len = Math.min(s.length(), this.stringLength);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            charCoder.encode(c, dest, offset + i * itemLength);
        }
        dest.fillRange(offset + len * itemLength, (this.stringLength - len) * itemLength, 0.0);
    }

    @Override
    public int codeLength() {
        return this.stringLength * itemLength;
    }
}

