/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module;

import mikera.vectorz.AVector;
import mikera.vectorz.ArrayVector;
import mikera.vectorz.Op;
import nuroko.module.AOperationComponent;

public class TrainingOp
extends AOperationComponent {
    private final Op op;

    public TrainingOp(int length, Op op) {
        super(length);
        this.op = op;
    }

    @Override
    public void thinkInternal() {
        this.output.set((AVector)this.input);
    }

    @Override
    public void thinkInternalTraining() {
        this.output.set((AVector)this.input);
        this.op.applyTo((ArrayVector)this.output);
    }

    @Override
    public void trainGradientInternal(double factor) {
        double[] ov = this.output.getArray();
        double[] og = this.outputGradient.getArray();
        double[] ig = this.inputGradient.getArray();
        for (int i = 0; i < this.length; ++i) {
            ig[i] = this.op.derivativeForOutput(ov[i]) * og[i];
        }
    }

    @Override
    public boolean hasDifferentTrainingThinking() {
        return true;
    }

    @Override
    public TrainingOp clone() {
        return new TrainingOp(this.length, this.op);
    }

    public String toString() {
        return this.length + ":" + this.length + " " + this.op.toString();
    }
}

