/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module;

import java.util.ArrayList;
import java.util.List;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.Vector0;
import nuroko.core.IComponent;
import nuroko.module.ACompoundComponent;

public class Join
extends ACompoundComponent {
    private final AVector input;
    private final AVector inputGradient;
    private final AVector output;
    private final AVector outputGradient;
    protected final int inputLength;
    protected final int outputLength;

    public Join(List<? extends IComponent> comps) {
        super(comps);
        int il = 0;
        int ol = 0;
        Vector0 input = Vector0.INSTANCE;
        Vector0 inputGradient = Vector0.INSTANCE;
        Vector0 output = Vector0.INSTANCE;
        Vector0 outputGradient = Vector0.INSTANCE;
        for (int i = 0; i < this.componentCount; ++i) {
            IComponent comp = this.getComponent(i);
            il += comp.getInputLength();
            ol += comp.getOutputLength();
            input = input.join(comp.getInput());
            inputGradient = inputGradient.join(comp.getInputGradient());
            output = output.join(comp.getOutput());
            outputGradient = outputGradient.join(comp.getOutputGradient());
        }
        this.inputLength = il;
        this.outputLength = ol;
        this.input = input;
        this.output = output;
        this.inputGradient = inputGradient;
        this.outputGradient = outputGradient;
    }

    @Override
    public void thinkInternal() {
        for (IComponent c : this.components) {
            c.thinkInternal();
        }
    }

    @Override
    public void trainGradient(AVector gradient, double factor) {
        this.outputGradient.set(gradient);
        this.trainGradientInternal(factor);
    }

    @Override
    public void trainGradientInternal(double factor) {
        for (IComponent c : this.components) {
            c.trainGradientInternal(factor);
        }
    }

    @Override
    public AVector getInput() {
        return this.input;
    }

    @Override
    public AVector getInputGradient() {
        return this.inputGradient;
    }

    @Override
    public AVector getOutput() {
        return this.output;
    }

    @Override
    public AVector getOutputGradient() {
        return this.outputGradient;
    }

    @Override
    public Join clone() {
        ArrayList<IComponent> al = new ArrayList<IComponent>();
        for (IComponent c : this.components) {
            al.add(c.clone());
        }
        return new Join(al);
    }
}

