/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module;

import java.util.ArrayList;
import java.util.List;
import mikera.vectorz.AVector;
import nuroko.core.IComponent;
import nuroko.module.AComponent;

public abstract class ACompoundComponent
extends AComponent {
    protected final ArrayList<IComponent> components;
    protected final AVector gradient;
    protected final AVector parameters;
    protected final int componentCount;

    public ACompoundComponent(List<? extends IComponent> comps) {
        this.componentCount = comps.size();
        this.components = new ArrayList<IComponent>(comps);
        AVector g = comps.get(0).getGradient();
        AVector p = comps.get(0).getParameters();
        for (int i = 1; i < this.componentCount; ++i) {
            g = g.join(comps.get(i).getGradient());
            p = p.join(comps.get(i).getParameters());
        }
        this.gradient = g;
        this.parameters = p;
    }

    @Override
    public AVector getGradient() {
        return this.gradient;
    }

    @Override
    public AVector getParameters() {
        return this.parameters;
    }

    @Override
    public int getParameterLength() {
        return this.parameters.length();
    }

    @Override
    public IComponent getComponent(int i) {
        return this.components.get(i);
    }

    @Override
    public List<IComponent> getComponents() {
        return this.components;
    }
}

