/*
 * Decompiled with CFR 0.152.
 */
package nuroko.core;

import java.util.Arrays;
import java.util.List;
import mikera.vectorz.Op;
import nuroko.core.IComponent;
import nuroko.module.ALayerStack;
import nuroko.module.AWeightLayer;
import nuroko.module.CompoundLayerStack;
import nuroko.module.Join;
import nuroko.module.NeuralNet;
import nuroko.module.Operator;
import nuroko.module.Stack;
import nuroko.module.layers.FullWeightLayer;
import nuroko.module.layers.SparseWeightLayer;

public final class Components {
    private static final int DEFAULT_SPARSE_LINKS = 50;

    public static Stack stack(List<? extends IComponent> components) {
        return new Stack(components);
    }

    public static Stack stack(IComponent ... components) {
        return new Stack(Arrays.asList(components));
    }

    public static Join join(List<? extends IComponent> components) {
        return new Join(components);
    }

    public static Join join(IComponent ... components) {
        return new Join(Arrays.asList(components));
    }

    public static Operator operator(Op op, int length) {
        return new Operator(op, length);
    }

    public static NeuralNet neuralLayer(int inputLength, int outputLength, Op op) {
        return Components.neuralLayer(inputLength, outputLength, op, false);
    }

    public static AWeightLayer weightLayer(int inputLength, int outputLength, int maxLinks) {
        if (maxLinks >= inputLength) {
            return new FullWeightLayer(inputLength, outputLength);
        }
        return new SparseWeightLayer(inputLength, outputLength, maxLinks);
    }

    public static NeuralNet neuralLayer(int inputLength, int outputLength, Op op, boolean fullyConnected) {
        AWeightLayer wl = fullyConnected ? new FullWeightLayer(inputLength, outputLength) : Components.weightLayer(inputLength, outputLength, 50);
        return new NeuralNet(new AWeightLayer[]{wl}, op);
    }

    public static ALayerStack asLayerStack(IComponent comp) {
        if (comp instanceof ALayerStack) {
            return (ALayerStack)comp;
        }
        List<IComponent> comps = comp.getComponents();
        ALayerStack st = Components.asLayerStack(comps.get(0));
        for (int i = 1; i < comps.size(); ++i) {
            ALayerStack st2 = Components.asLayerStack(comps.get(i));
            st = CompoundLayerStack.stack(st, st2);
        }
        return st;
    }
}

