/*
 * Decompiled with CFR 0.152.
 */
package nuroko.coders;

import java.util.ArrayList;
import java.util.List;
import mikera.vectorz.AVector;
import nuroko.coders.AbstractCoder;
import nuroko.core.ICoder;

public class FixedListCoder<T>
extends AbstractCoder<List<T>> {
    private final int listLength;
    private final ICoder<T> itemCoder;
    private final int itemLength;

    public FixedListCoder(int listLength, ICoder<T> itemCoder) {
        this.listLength = listLength;
        this.itemCoder = itemCoder;
        this.itemLength = itemCoder.codeLength();
    }

    @Override
    public List<T> decode(AVector v, int offset) {
        ArrayList al = new ArrayList();
        for (int i = 0; i < this.listLength; ++i) {
            al.add(this.itemCoder.decode(v, offset + i * this.itemLength));
        }
        return al;
    }

    @Override
    public void encode(List<T> list, AVector dest, int offset) {
        for (int i = 0; i < this.listLength; ++i) {
            T item = list.get(i);
            this.itemCoder.encode(item, dest, offset + i * this.itemLength);
        }
    }

    @Override
    public int codeLength() {
        return this.listLength * this.itemLength;
    }
}

