/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;
import nuroko.core.IParameterised;
import nuroko.module.ALayerStack;
import nuroko.module.AWeightLayer;

public abstract class CompoundStack<T extends IParameterised>
extends ALayerStack {
    protected final ArrayList<T> components = new ArrayList();
    protected final int componentCount;
    private final AVector parameters;
    private final AVector gradient;

    public List<T> getComponents() {
        return this.components;
    }

    public CompoundStack(Collection<T> comps) {
        Collection<T> tmp = comps;
        this.components.addAll(tmp);
        this.componentCount = this.components.size();
        AVector params = Vectorz.newVector((int)0);
        for (IParameterised comp : this.components) {
            params = params.join(comp.getParameters());
        }
        this.parameters = params;
        AVector grad = Vectorz.newVector((int)0);
        for (IParameterised comp : this.components) {
            grad = grad.join(comp.getGradient());
        }
        this.gradient = grad;
    }

    public T getComponent(int i) {
        return (T)((IParameterised)this.components.get(i));
    }

    @Override
    public abstract void think(AVector var1, AVector var2);

    @Override
    public AVector getParameters() {
        return this.parameters;
    }

    @Override
    public AVector getGradient() {
        return this.gradient;
    }

    @Override
    public abstract int getLayerCount();

    @Override
    public abstract AWeightLayer getLayer(int var1);

    @Override
    public abstract AVector getData(int var1);

    @Override
    public abstract CompoundStack<T> clone();
}

