# A MongoDB-based store for Quartz.

This is a MongoDB-backed job store for the [Quartz scheduler](http://quartz-scheduler.org/).

## Maven Artifacts

Artifacts are released to [clojars.org](http://clojars.org).
[![Clojars Project](http://clojars.org/com.novemberain/quartz-mongodb/latest-version.svg)](http://clojars.org/com.novemberain/quartz-mongodb)

If you are using Maven, add the following repository
definition to your `pom.xml`:

``` xml
<repository>
  <id>clojars.org</id>
  <url>http://clojars.org/repo</url>
</repository>
```

If you are using Gradle, add the following to your `build.gradle`:

``` groovy
repositories {
    maven {
        url "http://clojars.org/repo"
    }
}
```


### The Most Recent Release

With Leiningen:

    [com.novemberain/quartz-mongodb "2.0.0-rc1"]


With Maven:

    <dependency>
      <groupId>com.novemberain</groupId>
      <artifactId>quartz-mongodb</artifactId>
      <version>2.0.0-rc1</version>
    </dependency>


With Gradle:

    compile "com.novemberain:quartz-mongodb:2.0.0-rc1"


## Usage

Set your Quartz properties to something like this:

    # Use the MongoDB store
    org.quartz.jobStore.class=com.novemberain.quartz.mongodb.MongoDBJobStore
    # MongoDB URI (optional if 'org.quartz.jobStore.addresses' is set)
    org.quartz.jobStore.mongoUri=mongodb://localhost:27020
    # comma separated list of mongodb hosts/replica set seeds (optional if 'org.quartz.jobStore.mongoUri' is set)
    org.quartz.jobStore.addresses=host1,host2
    # database name
    org.quartz.jobStore.dbName=quartz
    # Will be used to create collections like mycol_jobs, mycol_triggers, mycol_calendars, mycol_locks
    org.quartz.jobStore.collectionPrefix=mycol
    # thread count setting is ignored by the MongoDB store but Quartz requries it
    org.quartz.threadPool.threadCount=1

If you use [Quartzite](http://clojurequartz.info) or want your job classes to be available
to Clojure code, use:

    org.quartz.jobStore.class=com.novemberain.quartz.mongodb.DynamicMongoDBJobStore

(this assumes Clojure jar is on classpath).

## Clustering

To enable clustering set the following property:

    # turn clustering on:
    org.quartz.jobStore.isClustered=true
    
    # Must be unique for each node or AUTO to use autogenerated:
    org.quartz.scheduler.instanceId=AUTO
    # org.quartz.scheduler.instanceId=node1
    
    # The same cluster name on each node:
    org.quartz.scheduler.instanceName=clusterName
    
Each node in a cluster must have the same properties, except *instanceId*.
To setup other clusters use different collection prefix:

    org.quartz.scheduler.collectionPrefix=yourCluster

Different time settings for cluster operations:

    # Frequency (in milliseconds) at which this instance checks-in to cluster.
    # Affects the rate of detecting failed instances.
    # Defaults to 7500 ms.
    org.quartz.scheduler.clusterCheckinInterval=10000
    
    # Time in millis after which a trigger can be considered as expired.
    # Defaults to 10 minutes:
    org.quartz.scheduler.triggerTimeoutMillis=1200000
    
    # Time in millis after which a job can be considered as expired.
    # Defaults to 10 minutes:
    org.quartz.scheduler.jobTimeoutMillis=1200000
    
    # Time limit in millis after which a trigger should be treated as misfired.
    # Defaults to 5000 ms.
    org.quartz.scheduler.misfireThreshold=10000
    
    # WriteConcern timeout in millis when writing in Replica Set.
    # Defaults to 5000 ms.
    org.quartz.scheduler.mongoOptionWriteConcernTimeoutMillis=10000

## Continuous Integration

[![Build Status](https://secure.travis-ci.org/michaelklishin/quartz-mongodb.png?branch=master)](http://travis-ci.org/michaelklishin/quartz-mongodb)

CI is hosted by [Travis CI](http://travis-ci.org/)


## Copyright & License

(c) Michael S. Klishin, Alex Petrov, 2011-2015.

[Apache Public License 2.0](http://www.apache.org/licenses/LICENSE-2.0.html)


## FAQ

### Project Origins

The project was originally started by MuleSoft. It supports all Quartz trigger types and
tries to be as feature complete as possible.

### Why the Fork?

MuleSoft developers did not respond to attempts to submit pull
requests for several months. As more and more functionality was added
and implementation code refactored, I decided to completely separate
this fork form GitHub forks network because the project is now too
different from the original one. All changes were made with respect to
the Apache Public License 2.0.
