/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.quartz.mongo;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mulesoft.quartz.mongo.TriggerPersistenceHelper;
import java.util.Map;
import org.quartz.SimpleTrigger;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class SimpleTriggerPersistenceHelper
implements TriggerPersistenceHelper {
    private static final String TRIGGER_REPEAT_COUNT = "repeatCount";
    private static final String TRIGGER_REPEAT_INTERVAL = "repeatInterval";
    private static final String TRIGGER_TIMES_TRIGGERED = "timesTriggered";

    public boolean canHandleTriggerType(OperableTrigger trigger) {
        return trigger instanceof SimpleTriggerImpl && !((SimpleTriggerImpl)trigger).hasAdditionalProperties();
    }

    public DBObject injectExtraPropertiesForInsert(OperableTrigger trigger, DBObject original) {
        SimpleTrigger t = (SimpleTrigger)trigger;
        return BasicDBObjectBuilder.start((Map)original.toMap()).append(TRIGGER_REPEAT_COUNT, (Object)t.getRepeatCount()).append(TRIGGER_REPEAT_INTERVAL, (Object)t.getRepeatInterval()).append(TRIGGER_TIMES_TRIGGERED, (Object)t.getTimesTriggered()).get();
    }

    public OperableTrigger setExtraPropertiesAfterInstantiation(OperableTrigger trigger, DBObject stored) {
        Object timesTriggered;
        Object repeatInterval;
        SimpleTriggerImpl t = (SimpleTriggerImpl)trigger;
        Object repeatCount = stored.get(TRIGGER_REPEAT_COUNT);
        if (repeatCount != null) {
            t.setRepeatCount(((Integer)repeatCount).intValue());
        }
        if ((repeatInterval = stored.get(TRIGGER_REPEAT_INTERVAL)) != null) {
            t.setRepeatInterval(((Long)repeatInterval).longValue());
        }
        if ((timesTriggered = stored.get(TRIGGER_TIMES_TRIGGERED)) != null) {
            t.setTimesTriggered(((Integer)timesTriggered).intValue());
        }
        return t;
    }
}

