/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.quartz.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mulesoft.quartz.mongo.CalendarIntervalTriggerPersistenceHelper;
import com.mulesoft.quartz.mongo.CronTriggerPersistenceHelper;
import com.mulesoft.quartz.mongo.DailyTimeIntervalTriggerPersistenceHelper;
import com.mulesoft.quartz.mongo.SimpleTriggerPersistenceHelper;
import com.mulesoft.quartz.mongo.TriggerPersistenceHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.quartz.Calendar;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBJobStore
implements JobStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String JOB_KEY_NAME = "keyName";
    private static final String JOB_KEY_GROUP = "keyGroup";
    private static final String JOB_DESCRIPTION = "jobDescription";
    private static final String JOB_CLASS = "jobClass";
    private static final String TRIGGER_CALENDAR_NAME = "calendarName";
    private static final String TRIGGER_DESCRIPTION = "description";
    private static final String TRIGGER_END_TIME = "endTime";
    private static final String TRIGGER_FINAL_FIRE_TIME = "finalFireTime";
    private static final String TRIGGER_FIRE_INSTANCE_ID = "fireInstanceId";
    private static final String TRIGGER_KEY_NAME = "keyName";
    private static final String TRIGGER_KEY_GROUP = "keyGroup";
    private static final String TRIGGER_MISFIRE_INSTRUCTION = "misfireInstruction";
    private static final String TRIGGER_NEXT_FIRE_TIME = "nextFireTime";
    private static final String TRIGGER_PREVIOUS_FIRE_TIME = "previousFireTime";
    private static final String TRIGGER_PRIORITY = "priority";
    private static final String TRIGGER_START_TIME = "startTime";
    private static final String TRIGGER_JOB_ID = "jobId";
    private static final String TRIGGER_CLASS = "class";
    private static final String SIMPLE_TRIGGER_REPEAT_COUNT = "repeatCount";
    private static final String SIMPLE_TRIGGER_REPEAT_INTERVAL = "repeatInterval";
    private static final String SIMPLE_TRIGGER_TIMES_TRIGGERED = "timesTriggered";
    private static final String CALENDAR_NAME = "name";
    private static final String CALENDAR_SERIALIZED_OBJECT = "serializedObject";
    private static final String LOCK_KEY_NAME = "keyName";
    private static final String LOCK_KEY_GROUP = "keyGroup";
    private static final String LOCK_INSTANCE_ID = "instanceId";
    private static final String LOCK_TIME = "time";
    private Mongo mongo;
    private String collectionPrefix = "quartz_";
    private String dbName;
    private DBCollection jobCollection;
    private DBCollection triggerCollection;
    private DBCollection calendarCollection;
    private ClassLoadHelper loadHelper;
    private DBCollection locksCollection;
    private String instanceId;
    private String[] addresses;
    private String username;
    private String password;
    private SchedulerSignaler signaler;
    protected long misfireThreshold = 5000L;
    private long triggerTimeoutMillis = 600000L;
    private List<TriggerPersistenceHelper> persistenceHelpers = new ArrayList<TriggerPersistenceHelper>();

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.loadHelper = loadHelper;
        this.signaler = signaler;
        this.persistenceHelpers.add(new SimpleTriggerPersistenceHelper());
        this.persistenceHelpers.add(new CalendarIntervalTriggerPersistenceHelper());
        this.persistenceHelpers.add(new CronTriggerPersistenceHelper());
        this.persistenceHelpers.add(new DailyTimeIntervalTriggerPersistenceHelper());
        if (this.addresses == null || this.addresses.length == 0) {
            throw new SchedulerConfigException("At least one MongoDB address must be specified.");
        }
        MongoOptions options = new MongoOptions();
        options.safe = true;
        try {
            ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
            for (String a : this.addresses) {
                serverAddresses.add(new ServerAddress(a));
            }
            this.mongo = new Mongo(serverAddresses, options);
        }
        catch (UnknownHostException e) {
            throw new SchedulerConfigException("Could not connect to MongoDB.", (Throwable)e);
        }
        catch (MongoException e) {
            throw new SchedulerConfigException("Could not connect to MongoDB.", (Throwable)e);
        }
        DB db = this.mongo.getDB(this.dbName);
        if (this.username != null) {
            db.authenticate(this.username, this.password.toCharArray());
        }
        this.jobCollection = db.getCollection(this.collectionPrefix + "jobs");
        this.triggerCollection = db.getCollection(this.collectionPrefix + "triggers");
        this.calendarCollection = db.getCollection(this.collectionPrefix + "calendars");
        this.locksCollection = db.getCollection(this.collectionPrefix + "locks");
        BasicDBObject keys = new BasicDBObject();
        keys.put("keyName", (Object)1);
        keys.put("keyGroup", (Object)1);
        this.jobCollection.ensureIndex((DBObject)keys, null, true);
        keys = new BasicDBObject();
        keys.put("keyName", (Object)1);
        keys.put("keyGroup", (Object)1);
        this.triggerCollection.ensureIndex((DBObject)keys, null, true);
        keys = new BasicDBObject();
        keys.put("keyName", (Object)1);
        keys.put("keyGroup", (Object)1);
        this.locksCollection.ensureIndex((DBObject)keys, null, true);
        this.locksCollection.remove((DBObject)new BasicDBObject(LOCK_INSTANCE_ID, (Object)this.instanceId));
        keys = new BasicDBObject();
        keys.put(CALENDAR_NAME, (Object)1);
        this.calendarCollection.ensureIndex((DBObject)keys, null, true);
    }

    public void schedulerStarted() throws SchedulerException {
    }

    public void schedulerPaused() {
    }

    public void schedulerResumed() {
    }

    public void shutdown() {
        this.mongo.close();
    }

    public boolean supportsPersistence() {
        return true;
    }

    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 200L;
    }

    public boolean isClustered() {
        return true;
    }

    public void storeJobAndTrigger(JobDetail newJob, OperableTrigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        ObjectId jobId = this.storeJobInMongo(newJob, false);
        this.log.debug("Storing job " + newJob.getKey() + " and trigger " + newTrigger.getKey());
        this.storeTrigger(newTrigger, jobId, false);
    }

    protected void storeTrigger(OperableTrigger newTrigger, ObjectId jobId, boolean replaceExisting) throws ObjectAlreadyExistsException {
        BasicDBObject triggerDB = new BasicDBObject();
        triggerDB.put(TRIGGER_CALENDAR_NAME, (Object)newTrigger.getCalendarName());
        triggerDB.put(TRIGGER_CLASS, (Object)newTrigger.getClass().getName());
        triggerDB.put(TRIGGER_DESCRIPTION, (Object)newTrigger.getDescription());
        triggerDB.put(TRIGGER_END_TIME, (Object)newTrigger.getEndTime());
        triggerDB.put(TRIGGER_FINAL_FIRE_TIME, (Object)newTrigger.getFinalFireTime());
        triggerDB.put(TRIGGER_FIRE_INSTANCE_ID, (Object)newTrigger.getFireInstanceId());
        triggerDB.put(TRIGGER_JOB_ID, (Object)jobId);
        triggerDB.put("keyName", (Object)newTrigger.getKey().getName());
        triggerDB.put("keyGroup", (Object)newTrigger.getKey().getGroup());
        triggerDB.put(TRIGGER_MISFIRE_INSTRUCTION, (Object)newTrigger.getMisfireInstruction());
        triggerDB.put(TRIGGER_NEXT_FIRE_TIME, (Object)newTrigger.getNextFireTime());
        triggerDB.put(TRIGGER_PREVIOUS_FIRE_TIME, (Object)newTrigger.getPreviousFireTime());
        triggerDB.put(TRIGGER_PRIORITY, (Object)newTrigger.getPriority());
        triggerDB.put(TRIGGER_START_TIME, (Object)newTrigger.getStartTime());
        TriggerPersistenceHelper tpd = this.triggerPersistenceDelegateFor(newTrigger);
        triggerDB = (BasicDBObject)tpd.injectExtraPropertiesForInsert(newTrigger, (DBObject)triggerDB);
        try {
            this.triggerCollection.insert(new DBObject[]{triggerDB});
        }
        catch (MongoException.DuplicateKey key) {
            if (replaceExisting) {
                triggerDB.remove((Object)"_id");
                this.triggerCollection.update((DBObject)this.keyAsDBObject((Key)newTrigger.getKey()), (DBObject)triggerDB);
            }
            throw new ObjectAlreadyExistsException((Trigger)newTrigger);
        }
    }

    public void storeJob(JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.storeJobInMongo(newJob, replaceExisting);
    }

    protected ObjectId storeJobInMongo(JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException {
        DBObject result;
        JobKey key = newJob.getKey();
        BasicDBObject job = this.keyAsDBObject((Key)key);
        if (replaceExisting && (result = this.jobCollection.findOne((DBObject)job)) != null) {
            result = job;
        }
        job.put("keyName", (Object)key.getName());
        job.put("keyGroup", (Object)key.getGroup());
        job.put(JOB_DESCRIPTION, (Object)newJob.getDescription());
        job.put(JOB_CLASS, (Object)newJob.getJobClass().getName());
        job.putAll((Map)newJob.getJobDataMap());
        try {
            this.jobCollection.insert(new DBObject[]{job});
            return (ObjectId)job.get("_id");
        }
        catch (MongoException.DuplicateKey e) {
            throw new ObjectAlreadyExistsException(e.getMessage());
        }
    }

    protected BasicDBObject keyAsDBObject(Key key) {
        BasicDBObject job = new BasicDBObject();
        job.put("keyName", (Object)key.getName());
        job.put("keyGroup", (Object)key.getGroup());
        return job;
    }

    public void storeJobsAndTriggers(Map<JobDetail, List<Trigger>> triggersAndJobs, boolean replace) throws ObjectAlreadyExistsException, JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public boolean removeJob(JobKey jobKey) throws JobPersistenceException {
        BasicDBObject keyObject = this.keyAsDBObject((Key)jobKey);
        DBCursor find = this.jobCollection.find((DBObject)keyObject);
        if (find.hasNext()) {
            DBObject jobObj = find.next();
            this.jobCollection.remove((DBObject)keyObject);
            this.triggerCollection.remove((DBObject)new BasicDBObject(TRIGGER_JOB_ID, jobObj.get("_id")));
            return true;
        }
        return false;
    }

    public boolean removeJobs(List<JobKey> jobKeys) throws JobPersistenceException {
        for (JobKey key : jobKeys) {
            this.removeJob(key);
        }
        return false;
    }

    private JobDetail retrieveJob(OperableTrigger trigger) throws JobPersistenceException {
        try {
            return this.retrieveJob(trigger.getJobKey());
        }
        catch (JobPersistenceException e) {
            this.removeTriggerLock(trigger);
            throw e;
        }
    }

    public JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        DBObject dbObject = this.retrieveJobDBObject(jobKey);
        try {
            Class<?> jobClass = this.loadHelper.getClassLoader().loadClass((String)dbObject.get(JOB_CLASS));
            JobBuilder builder = JobBuilder.newJob(jobClass).withIdentity((String)dbObject.get("keyName"), (String)dbObject.get("keyGroup")).withDescription((String)dbObject.get("keyName"));
            JobDataMap jobData = new JobDataMap();
            for (String key : dbObject.keySet()) {
                if (key.equals("keyName") || key.equals("keyGroup") || key.equals(JOB_CLASS) || key.equals(JOB_DESCRIPTION) || key.equals("_id")) continue;
                jobData.put(key, dbObject.get(key));
            }
            return builder.usingJobData(jobData).build();
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Could not load job class " + dbObject.get(JOB_CLASS), (Throwable)e);
        }
    }

    protected DBObject retrieveJobDBObject(JobKey jobKey) {
        DBObject dbObject = this.jobCollection.findOne((DBObject)this.keyAsDBObject((Key)jobKey));
        return dbObject;
    }

    public void storeTrigger(OperableTrigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        if (newTrigger.getJobKey() == null) {
            throw new JobPersistenceException("Trigger must be associated with a job. Please specify a JobKey.");
        }
        DBObject dbObject = this.jobCollection.findOne((DBObject)this.keyAsDBObject((Key)newTrigger.getJobKey()));
        if (dbObject == null) {
            throw new JobPersistenceException("Could not find job with key " + newTrigger.getJobKey());
        }
        this.storeTrigger(newTrigger, (ObjectId)dbObject.get("_id"), replaceExisting);
    }

    public boolean removeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        BasicDBObject dbObject = this.keyAsDBObject((Key)triggerKey);
        DBCursor find = this.triggerCollection.find((DBObject)dbObject);
        if (find.count() > 0) {
            this.triggerCollection.remove((DBObject)dbObject);
            return true;
        }
        return false;
    }

    public boolean removeTriggers(List<TriggerKey> triggerKeys) throws JobPersistenceException {
        for (TriggerKey key : triggerKeys) {
            this.removeTrigger(key);
        }
        return false;
    }

    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger newTrigger) throws JobPersistenceException {
        this.removeTrigger(triggerKey);
        this.storeTrigger(newTrigger, false);
        return true;
    }

    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        DBObject dbObject = this.triggerCollection.findOne((DBObject)this.keyAsDBObject((Key)triggerKey));
        if (dbObject == null) {
            return null;
        }
        return this.toTrigger(triggerKey, dbObject);
    }

    protected OperableTrigger toTrigger(TriggerKey triggerKey, DBObject dbObject) throws JobPersistenceException {
        OperableTrigger trigger;
        try {
            Class<?> triggerClass = this.loadHelper.getClassLoader().loadClass((String)dbObject.get(TRIGGER_CLASS));
            trigger = (OperableTrigger)triggerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Could not find trigger class " + (String)dbObject.get(TRIGGER_CLASS));
        }
        catch (Exception e) {
            throw new JobPersistenceException("Could not instantiate trigger class " + (String)dbObject.get(TRIGGER_CLASS));
        }
        TriggerPersistenceHelper tpd = this.triggerPersistenceDelegateFor(trigger);
        trigger.setKey(triggerKey);
        trigger.setCalendarName((String)dbObject.get(TRIGGER_CALENDAR_NAME));
        trigger.setDescription((String)dbObject.get(TRIGGER_DESCRIPTION));
        trigger.setEndTime((Date)dbObject.get(TRIGGER_END_TIME));
        trigger.setFireInstanceId((String)dbObject.get(TRIGGER_FIRE_INSTANCE_ID));
        trigger.setMisfireInstruction(((Integer)dbObject.get(TRIGGER_MISFIRE_INSTRUCTION)).intValue());
        trigger.setNextFireTime((Date)dbObject.get(TRIGGER_NEXT_FIRE_TIME));
        trigger.setPreviousFireTime((Date)dbObject.get(TRIGGER_PREVIOUS_FIRE_TIME));
        trigger.setPriority(((Integer)dbObject.get(TRIGGER_PRIORITY)).intValue());
        trigger.setStartTime((Date)dbObject.get(TRIGGER_START_TIME));
        trigger = tpd.setExtraPropertiesAfterInstantiation(trigger, dbObject);
        DBObject job = this.jobCollection.findOne((DBObject)new BasicDBObject("_id", dbObject.get(TRIGGER_JOB_ID)));
        if (job != null) {
            trigger.setJobKey(new JobKey((String)job.get("keyName"), (String)job.get("keyGroup")));
            return trigger;
        }
        return null;
    }

    private TriggerPersistenceHelper triggerPersistenceDelegateFor(OperableTrigger trigger) {
        TriggerPersistenceHelper result = null;
        for (TriggerPersistenceHelper d : this.persistenceHelpers) {
            if (!d.canHandleTriggerType(trigger)) continue;
            result = d;
            break;
        }
        assert (result != null);
        return result;
    }

    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        return this.jobCollection.find((DBObject)this.keyAsDBObject((Key)jobKey)).count() > 0;
    }

    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        return this.triggerCollection.find((DBObject)this.keyAsDBObject((Key)triggerKey)).count() > 0;
    }

    public void clearAllSchedulingData() throws JobPersistenceException {
        this.jobCollection.remove((DBObject)new BasicDBObject());
        this.triggerCollection.remove((DBObject)new BasicDBObject());
        this.calendarCollection.remove((DBObject)new BasicDBObject());
    }

    public void storeCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        if (updateTriggers) {
            throw new UnsupportedOperationException("Updating triggers is not supported.");
        }
        BasicDBObject dbObject = new BasicDBObject();
        dbObject.put(CALENDAR_NAME, (Object)name);
        dbObject.put(CALENDAR_SERIALIZED_OBJECT, this.serialize(calendar));
        this.calendarCollection.insert(new DBObject[]{dbObject});
    }

    private Object serialize(Calendar calendar) throws JobPersistenceException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(calendar);
            objectStream.close();
            return byteStream.toByteArray();
        }
        catch (IOException e) {
            throw new JobPersistenceException("Could not serialize Calendar.", (Throwable)e);
        }
    }

    public boolean removeCalendar(String calName) throws JobPersistenceException {
        BasicDBObject searchObj = new BasicDBObject(CALENDAR_NAME, (Object)calName);
        if (this.calendarCollection.find((DBObject)searchObj).count() > 0) {
            this.calendarCollection.remove((DBObject)searchObj);
            return true;
        }
        return false;
    }

    public Calendar retrieveCalendar(String calName) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfJobs() throws JobPersistenceException {
        return (int)this.jobCollection.count();
    }

    public int getNumberOfTriggers() throws JobPersistenceException {
        return (int)this.triggerCollection.count();
    }

    public int getNumberOfCalendars() throws JobPersistenceException {
        return this.calendarCollection.find().count();
    }

    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public List<String> getJobGroupNames() throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public List<String> getCalendarNames() throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) throws JobPersistenceException {
        DBObject dbObject = this.retrieveJobDBObject(jobKey);
        ArrayList<OperableTrigger> triggers = new ArrayList<OperableTrigger>();
        DBCursor cursor = this.triggerCollection.find((DBObject)new BasicDBObject(TRIGGER_JOB_ID, dbObject.get("_id")));
        while (cursor.hasNext()) {
            triggers.add(this.toTrigger(cursor.next()));
        }
        return triggers;
    }

    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void pauseTrigger(TriggerKey triggerKey) throws JobPersistenceException {
    }

    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void pauseJob(JobKey jobKey) throws JobPersistenceException {
    }

    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void resumeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.log.debug("Resume trigger" + triggerKey);
        throw new UnsupportedOperationException();
    }

    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void resumeJob(JobKey jobKey) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public Collection<String> resumeJobs(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public void pauseAll() throws JobPersistenceException {
    }

    public void resumeAll() throws JobPersistenceException {
    }

    public List<OperableTrigger> acquireNextTriggers(long noLaterThan, int maxCount, long timeWindow) throws JobPersistenceException {
        BasicDBObject query = new BasicDBObject();
        query.put(TRIGGER_NEXT_FIRE_TIME, (Object)new BasicDBObject("$lte", (Object)new Date(noLaterThan)));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finding up to " + maxCount + " triggers which have time less than " + new Date(noLaterThan));
        }
        ArrayList<OperableTrigger> triggers = new ArrayList<OperableTrigger>();
        DBCursor cursor = this.triggerCollection.find((DBObject)query);
        BasicDBObject sort = new BasicDBObject();
        sort.put(TRIGGER_NEXT_FIRE_TIME, (Object)1);
        cursor.sort((DBObject)sort);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found " + cursor.count() + " triggers which are eligible to be run.");
        }
        while (cursor.hasNext() && maxCount > triggers.size()) {
            DBObject dbObj = cursor.next();
            BasicDBObject lock = new BasicDBObject();
            lock.put("keyName", dbObj.get("keyName"));
            lock.put("keyGroup", dbObj.get("keyGroup"));
            lock.put(LOCK_INSTANCE_ID, (Object)this.instanceId);
            lock.put(LOCK_TIME, (Object)new Date());
            try {
                OperableTrigger trigger = this.toTrigger(dbObj);
                if (trigger.getNextFireTime() == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Skipping trigger " + trigger.getKey() + " as it has no next fire time.");
                    continue;
                }
                if (this.applyMisfire(trigger) && trigger.getNextFireTime() == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Skipping trigger " + trigger.getKey() + " as it has no next fire time after the misfire was applied.");
                    continue;
                }
                this.log.debug("Inserting lock for trigger " + trigger.getKey());
                this.locksCollection.insert(new DBObject[]{lock});
                this.log.debug("Aquired trigger " + trigger.getKey());
                triggers.add(trigger);
            }
            catch (MongoException.DuplicateKey e) {
                OperableTrigger trigger = this.toTrigger(dbObj);
                this.log.debug("Failed to acquire trigger " + trigger.getKey() + " due to a lock");
                lock = new BasicDBObject();
                lock.put("keyName", dbObj.get("keyName"));
                lock.put("keyGroup", dbObj.get("keyGroup"));
                DBCursor lockCursor = this.locksCollection.find((DBObject)lock);
                if (!lockCursor.hasNext()) {
                    this.log.error("Error retrieving expired lock from the database. Maybe it was deleted");
                    return this.acquireNextTriggers(noLaterThan, maxCount, timeWindow);
                }
                DBObject existingLock = lockCursor.next();
                if (!this.isTriggerLockExpired(existingLock)) continue;
                this.log.error("Lock for trigger " + trigger.getKey() + " is expired - removing lock and retrying trigger acquisition");
                this.removeTriggerLock(trigger);
                return this.acquireNextTriggers(noLaterThan, maxCount, timeWindow);
            }
        }
        return triggers;
    }

    protected boolean isTriggerLockExpired(DBObject lock) {
        Date lockTime = (Date)lock.get(LOCK_TIME);
        long elaspedTime = System.currentTimeMillis() - lockTime.getTime();
        return elaspedTime > this.triggerTimeoutMillis;
    }

    protected boolean applyMisfire(OperableTrigger trigger) throws JobPersistenceException {
        Date tnft;
        long misfireTime = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            misfireTime -= this.getMisfireThreshold();
        }
        if ((tnft = trigger.getNextFireTime()) == null || tnft.getTime() > misfireTime || trigger.getMisfireInstruction() == -1) {
            return false;
        }
        Calendar cal = null;
        if (trigger.getCalendarName() != null) {
            cal = this.retrieveCalendar(trigger.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired((Trigger)((OperableTrigger)trigger.clone()));
        trigger.updateAfterMisfire(cal);
        if (trigger.getNextFireTime() == null) {
            this.signaler.notifySchedulerListenersFinalized((Trigger)trigger);
        } else if (tnft.equals(trigger.getNextFireTime())) {
            return false;
        }
        this.storeTrigger(trigger, true);
        return true;
    }

    protected OperableTrigger toTrigger(DBObject dbObj) throws JobPersistenceException {
        TriggerKey key = new TriggerKey((String)dbObj.get("keyName"), (String)dbObj.get("keyGroup"));
        return this.toTrigger(key, dbObj);
    }

    public void releaseAcquiredTrigger(OperableTrigger trigger) throws JobPersistenceException {
        try {
            this.removeTriggerLock(trigger);
        }
        catch (Exception e) {
            throw new JobPersistenceException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> triggers) throws JobPersistenceException {
        ArrayList<TriggerFiredResult> results = new ArrayList<TriggerFiredResult>();
        for (OperableTrigger trigger : triggers) {
            this.log.debug("Fired trigger " + trigger.getKey());
            Calendar cal = null;
            if (trigger.getCalendarName() != null && (cal = this.retrieveCalendar(trigger.getCalendarName())) == null) continue;
            trigger.triggered(cal);
            this.storeTrigger(trigger, true);
            Date prevFireTime = trigger.getPreviousFireTime();
            TriggerFiredBundle bndle = new TriggerFiredBundle(this.retrieveJob(trigger), trigger, cal, false, new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
            JobDetail job = bndle.getJobDetail();
            if (job.isConcurrentExectionDisallowed()) {
                throw new UnsupportedOperationException("ConcurrentExecutionDisallowed is not supported currently.");
            }
            results.add(new TriggerFiredResult(bndle));
        }
        return results;
    }

    public void triggeredJobComplete(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction triggerInstCode) throws JobPersistenceException {
        this.log.debug("Trigger completed " + trigger.getKey());
        OperableTrigger trigger2 = this.retrieveTrigger(trigger.getKey());
        if (trigger2 != null) {
            if (triggerInstCode == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER) {
                if (trigger.getNextFireTime() == null) {
                    if (trigger2.getNextFireTime() == null) {
                        this.removeTrigger(trigger.getKey());
                    }
                } else {
                    this.removeTrigger(trigger.getKey());
                    this.signaler.signalSchedulingChange(0L);
                }
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                this.signaler.signalSchedulingChange(0L);
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                this.signaler.signalSchedulingChange(0L);
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                this.signaler.signalSchedulingChange(0L);
            } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                this.signaler.signalSchedulingChange(0L);
            }
        }
        this.removeTriggerLock(trigger);
    }

    protected void removeTriggerLock(OperableTrigger trigger) {
        this.log.debug("Removing trigger lock " + trigger.getKey() + "." + this.instanceId);
        BasicDBObject lock = new BasicDBObject();
        lock.put("keyName", (Object)trigger.getKey().getName());
        lock.put("keyGroup", (Object)trigger.getKey().getGroup());
        lock.put(LOCK_INSTANCE_ID, (Object)this.instanceId);
        this.locksCollection.remove((DBObject)lock);
        this.log.debug("Trigger lock " + trigger.getKey() + "." + this.instanceId + " removed.");
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setInstanceName(String schedName) {
    }

    public void setThreadPoolSize(int poolSize) {
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses.split(",");
    }

    public DBCollection getJobCollection() {
        return this.jobCollection;
    }

    public DBCollection getTriggerCollection() {
        return this.triggerCollection;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setCollectionPrefix(String prefix) {
        this.collectionPrefix = prefix + "_";
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long misfireThreshold) {
        this.misfireThreshold = misfireThreshold;
    }

    public void setTriggerTimeoutMillis(long triggerTimeoutMillis) {
        this.triggerTimeoutMillis = triggerTimeoutMillis;
    }
}

