/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.quartz.mongo;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mulesoft.quartz.mongo.TriggerPersistenceHelper;
import java.util.Map;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.TimeOfDay;
import org.quartz.impl.triggers.DailyTimeIntervalTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class DailyTimeIntervalTriggerPersistenceHelper
implements TriggerPersistenceHelper {
    private static final String TRIGGER_REPEAT_INTERVAL_UNIT = "repeatIntervalUnit";
    private static final String TRIGGER_REPEAT_INTERVAL = "repeatInterval";
    private static final String TRIGGER_TIMES_TRIGGERED = "timesTriggered";
    private static final String TRIGGER_START_TIME_OF_DAY = "startTimeOfDay";
    private static final String TRIGGER_END_TIME_OF_DAY = "endTimeOfDay";

    public boolean canHandleTriggerType(OperableTrigger trigger) {
        return trigger instanceof DailyTimeIntervalTrigger && !((DailyTimeIntervalTriggerImpl)trigger).hasAdditionalProperties();
    }

    public DBObject injectExtraPropertiesForInsert(OperableTrigger trigger, DBObject original) {
        DailyTimeIntervalTriggerImpl t = (DailyTimeIntervalTriggerImpl)trigger;
        return BasicDBObjectBuilder.start((Map)original.toMap()).append(TRIGGER_REPEAT_INTERVAL_UNIT, (Object)t.getRepeatIntervalUnit().name()).append(TRIGGER_REPEAT_INTERVAL, (Object)t.getRepeatInterval()).append(TRIGGER_TIMES_TRIGGERED, (Object)t.getTimesTriggered()).append(TRIGGER_START_TIME_OF_DAY, (Object)this.toDBObject(t.getStartTimeOfDay())).append(TRIGGER_END_TIME_OF_DAY, (Object)this.toDBObject(t.getEndTimeOfDay())).get();
    }

    private DBObject toDBObject(TimeOfDay tod) {
        return BasicDBObjectBuilder.start().append("hour", (Object)tod.getHour()).append("minute", (Object)tod.getMinute()).append("second", (Object)tod.getSecond()).get();
    }

    public OperableTrigger setExtraPropertiesAfterInstantiation(OperableTrigger trigger, DBObject stored) {
        DBObject endTOD;
        DBObject startTOD;
        Object timesTriggered;
        Object repeatInterval;
        DailyTimeIntervalTriggerImpl t = (DailyTimeIntervalTriggerImpl)trigger;
        Object interval_unit = stored.get(TRIGGER_REPEAT_INTERVAL_UNIT);
        if (interval_unit != null) {
            t.setRepeatCount(((Integer)interval_unit).intValue());
        }
        if ((repeatInterval = stored.get(TRIGGER_REPEAT_INTERVAL)) != null) {
            t.setRepeatInterval(((Integer)repeatInterval).intValue());
        }
        if ((timesTriggered = stored.get(TRIGGER_TIMES_TRIGGERED)) != null) {
            t.setTimesTriggered(((Integer)timesTriggered).intValue());
        }
        if ((startTOD = (DBObject)stored.get(TRIGGER_START_TIME_OF_DAY)) != null) {
            t.setStartTimeOfDay(this.fromDBObject(startTOD));
        }
        if ((endTOD = (DBObject)stored.get(TRIGGER_END_TIME_OF_DAY)) != null) {
            t.setEndTimeOfDay(this.fromDBObject(endTOD));
        }
        return t;
    }

    private TimeOfDay fromDBObject(DBObject endTOD) {
        return new TimeOfDay(((Integer)endTOD.get("hour")).intValue(), ((Integer)endTOD.get("minute")).intValue(), ((Integer)endTOD.get("second")).intValue());
    }
}

