/*
 * Decompiled with CFR 0.152.
 */
package com.noticeboard.shesha.examples.random;

import com.google.common.collect.Maps;
import com.noticeboard.shesha.examples.random.databuilder.DBuilder;
import com.noticeboard.shesha.examples.random.databuilder.EBuilder;
import com.noticeboard.shesha.examples.random.databuilder.FBuilder;
import com.noticeboard.shesha.examples.random.databuilder.GBuilder;
import com.noticeboard.shesha.examples.random.databuilder.HBuilder;
import com.noticeboard.shesha.examples.random.databuilder.IBuilder;
import com.noticeboard.shesha.examples.random.databuilder.JBuilder;
import com.noticeboard.shesha.examples.random.databuilder.KBuilder;
import com.noticeboard.shesha.executor.DataBuilderExecutor;
import com.noticeboard.shesha.executor.exception.DataBuilderExecutorFailedException;
import com.noticeboard.shesha.job.Job;
import com.noticeboard.shesha.job.exception.JobInitException;
import com.noticeboard.shesha.job.impl.DefaultJob;
import java.util.HashMap;
import java.util.Map;

public class RandomExample {
    public static void main(String[] args) throws DataBuilderExecutorFailedException, JobInitException {
        Map<String, Object> initialParams = RandomExample.getInitialParams();
        Map<String, Job> jobs = RandomExample.getJobs();
        DataBuilderExecutor executor = new DataBuilderExecutor();
        Object result = executor.execute(initialParams, jobs);
        System.out.println(result);
    }

    private static Map<String, Object> getInitialParams() {
        HashMap initialParams = Maps.newHashMap();
        initialParams.put("aData", "A");
        initialParams.put("bData", "B");
        initialParams.put("cData", "C");
        return initialParams;
    }

    private static Map<String, Job> getJobs() throws JobInitException {
        HashMap jobs = Maps.newHashMap();
        DefaultJob dJob = new DefaultJob(DBuilder.class, new String[]{"{aData}", "{bData}"});
        jobs.put("dData", dJob);
        DefaultJob eJob = new DefaultJob(EBuilder.class, new String[]{"{cData}"});
        jobs.put("eData", eJob);
        DefaultJob fJob = new DefaultJob(FBuilder.class, new String[]{"{cData}"});
        jobs.put("fData", fJob);
        DefaultJob gJob = new DefaultJob(GBuilder.class, new String[]{"{dData}", "{eData}"});
        jobs.put("gData", gJob);
        DefaultJob hJob = new DefaultJob(HBuilder.class, new String[]{"{gData}"});
        jobs.put("hData", hJob);
        DefaultJob iJob = new DefaultJob(IBuilder.class, new String[]{"{gData}", "{fData}"});
        jobs.put("iData", iJob);
        DefaultJob jJob = new DefaultJob(JBuilder.class, new String[]{"{iData}"});
        jobs.put("jData", jJob);
        DefaultJob kJob = new DefaultJob(KBuilder.class, new String[]{"{hData}", "{jData}"});
        jobs.put("kData", kJob);
        return jobs;
    }
}

