/*
 * Decompiled with CFR 0.152.
 */
package com.noticeboard.shesha.data.utils;

import com.google.common.collect.Lists;
import com.noticeboard.shesha.data.builder.DataBuilder;
import com.noticeboard.shesha.data.exception.DataSetParseException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class DataBuilderUtils {
    public static List<Field> getDeclaredFields(Class<? extends DataBuilder> aClass, Class<? extends Annotation> annotation) {
        Field[] fields;
        ArrayList declaredFields = Lists.newArrayList();
        for (Field field : fields = aClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            declaredFields.add(field);
        }
        return declaredFields;
    }

    public static List<String> parse(List<String> args) throws DataSetParseException {
        if (args == null || args.size() == 0) {
            throw new DataSetParseException("Empty argument set");
        }
        ArrayList dependencies = Lists.newArrayList();
        for (String arg : args) {
            if (arg.startsWith("{") && arg.endsWith("}")) {
                dependencies.add(arg.substring(1, arg.length() - 1));
                continue;
            }
            throw new DataSetParseException("Invalid Argument : " + arg);
        }
        return dependencies;
    }
}

