/*
 * Decompiled with CFR 0.152.
 */
package com.noticeboard.shesha.data.builder;

import com.noticeboard.shesha.data.entity.DataBuilderProperty;
import com.noticeboard.shesha.data.entity.DataSet;
import com.noticeboard.shesha.data.exception.DataBuilderInitException;
import com.noticeboard.shesha.data.utils.DataBuilderUtils;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataBuilder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataBuilder.class);
    private final DataSet dataSet;

    public DataBuilder(DataSet dataSet) throws DataBuilderInitException {
        this.dataSet = dataSet;
        this.injectDataBuilderProperties(this);
    }

    private void injectDataBuilderProperties(DataBuilder dataBuilder) throws DataBuilderInitException {
        try {
            List<Field> injectableFields = DataBuilderUtils.getDeclaredFields(this.getClass(), DataBuilderProperty.class);
            if (injectableFields == null) {
                throw new DataBuilderInitException("Unable to initialise DataBuilder " + this.getClass().getName() + ", No DataBuilderProperty");
            }
            for (Field field : injectableFields) {
                Class<?> valueClass;
                field.setAccessible(true);
                DataBuilderProperty property = field.getAnnotation(DataBuilderProperty.class);
                String propertyName = property.value().isEmpty() ? field.getName() : property.value();
                Boolean isOptional = propertyName.startsWith("#");
                Object result = this.dataSet.getAttribute(isOptional != false ? propertyName.substring(1) : propertyName);
                this.validateRequired(field, result, isOptional);
                if (result == null) continue;
                Class<?> propertyClass = field.getType();
                if (propertyClass.isAssignableFrom(valueClass = result.getClass())) {
                    field.set(dataBuilder, result);
                    continue;
                }
                LOGGER.error("Type mismatch while injecting DataBuilderProperty: {}, Value: {}, DataBuilder: {}", new Object[]{field.getType().getName(), valueClass.getName(), this.getClass().getName()});
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while injecting properties for DataBuilder: {}, exception: {}", (Object)this.getClass().getName(), (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new DataBuilderInitException("Unable to initialise DataBuilder " + this.getClass().getName(), e);
        }
    }

    private void validateRequired(Field field, Object value, Boolean isOptional) {
        if (!isOptional.booleanValue() && value == null) {
            throw new RuntimeException("Null value found for non-optional parameter: " + field.getName());
        }
    }

    public abstract T execute() throws Exception;
}

