/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "../build/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ({

/***/ 0:
/***/ function(module, exports, __webpack_require__) {

	window.ReactGoogleMaps = __webpack_require__(1);


/***/ },

/***/ 1:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var assign = __webpack_require__(4);
	var ReactDefaultInjection = __webpack_require__(5);
	var ReactMapComponents = __webpack_require__(6);
	var MapPropTypes = __webpack_require__(7);
	
	ReactDefaultInjection.inject();
	
	module.exports = assign(
	  {},
	  ReactMapComponents,
	  {
	    PropTypes: MapPropTypes
	  }
	);


/***/ },

/***/ 4:
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copyright 2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule Object.assign
	 */
	
	// https://people.mozilla.org/~jorendorff/es6-draft.html#sec-object.assign
	
	function assign(target, sources) {
	  if (target == null) {
	    throw new TypeError('Object.assign target cannot be null or undefined');
	  }
	
	  var to = Object(target);
	  var hasOwnProperty = Object.prototype.hasOwnProperty;
	
	  for (var nextIndex = 1; nextIndex < arguments.length; nextIndex++) {
	    var nextSource = arguments[nextIndex];
	    if (nextSource == null) {
	      continue;
	    }
	
	    var from = Object(nextSource);
	
	    // We don't currently support accessors nor proxies. Therefore this
	    // copy cannot throw. If we ever supported this then we must handle
	    // exceptions and side-effects. We don't support symbols so they won't
	    // be transferred.
	
	    for (var key in from) {
	      if (hasOwnProperty.call(from, key)) {
	        to[key] = from[key];
	      }
	    }
	  }
	
	  return to;
	};
	
	module.exports = assign;


/***/ },

/***/ 5:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var ReactMapComponents = __webpack_require__(6);
	var MapOption = __webpack_require__(10);
	var MapEvent = __webpack_require__(11);
	var MapOptionConfig = __webpack_require__(12);
	var ReactMap = __webpack_require__(13);
	var ReactOverlayView = __webpack_require__(14);
	var ReactFrag = __webpack_require__(15);
	var SimpleEventPlugin = __webpack_require__(16);
	var MouseEventPlugin = __webpack_require__(17);
	var SideEffectEventPlugin = __webpack_require__(18);
	
	var ReactInjection = {
	  EventEmitter: null,
	  MapEvent: MapEvent.injection,
	  MapOption: MapOption.injection,
	  MapComponents: ReactMapComponents.injection
	};
	
	function inject() {
	  ReactInjection.MapEvent.injectEventPluginsByName({
	    SimpleEventPlugin: SimpleEventPlugin,
	    MouseEventPlugin: MouseEventPlugin,
	    SideEffectEventPlugin: SideEffectEventPlugin
	  });
	
	  ReactInjection.MapComponents.injectComponentClasses({
	    Map: ReactMap,
	    OverlayView: ReactOverlayView,
	    Frag: ReactFrag
	  });
	
	  ReactInjection.MapOption.injectMapOptionConfig(MapOptionConfig);
	}
	
	module.exports = {
	  inject: inject
	};


/***/ },

/***/ 6:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var assign = __webpack_require__(4);
	var mapObject = __webpack_require__(20);
	var GoogleMapsAPI = __webpack_require__(19);
	var ReactMapComponent = __webpack_require__(21);
	
	function createMapComponentClass(constructorFn, constructorName) {
	  return ReactMapComponent.create(constructorName, constructorFn);
	}
	
	function constructGoogleMapsMapClass() {
	  return new GoogleMapsAPI.Map(this.props.mapDiv);
	}
	
	/**
	 * Creates a mapping from supported GoogleMap classes to `ReactMapComponent` classes.
	 *
	 * @public
	 */
	var ReactMapComponents = mapObject({
	  Map: constructGoogleMapsMapClass, // NOTE: Injected, see `ReactMap`.
	  Marker: null,
	  Polyline: null,
	  Circle: null,
	  Rectangle: null,
	  Polygon: null
	  // OverlayView: Note: Injected, see `ReactOverlayView`.
	  // Frag: Note: Injected, see `ReactFrag`.
	}, createMapComponentClass);
	
	var injection = {
	  injectComponentClasses: function(componentClasses) {
	    assign(ReactMapComponents, componentClasses);
	  }
	};
	
	ReactMapComponents.injection = injection;
	
	module.exports = ReactMapComponents;


/***/ },

/***/ 7:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var GoogleMaps = __webpack_require__(19);
	
	/**
	 * Checks whether a prop provides a `GoogleMaps.LatLng`
	 */
	exports.LatLng = React.PropTypes.instanceOf(GoogleMaps.LatLng);
	
	/**
	 * Checks whether a prop provides a `GoogleMaps.LatLngBounds`
	 */
	exports.LatLngBounds = React.PropTypes.instanceOf(GoogleMaps.LatLngBounds);
	
	/**
	 * Checks whether a prop provides a `GoogleMaps.Map`
	 */
	exports.Map = React.PropTypes.instanceOf(GoogleMaps.Map);
	
	/**
	 * Checks whether a prop provides a `GoogleMaps.Point`
	 */
	exports.Point = React.PropTypes.instanceOf(GoogleMaps.Point);
	
	/**
	 * Checks whether a prop provides a `GoogleMaps.Animation`
	 */
	exports.Animation = React.PropTypes.oneOf(
	  Object.keys(GoogleMaps.Animation)
	    .map(function(key) {return GoogleMaps.Animation[key];})
	);
	
	/**
	 * Checks whether a prop provides a `GoogleMaps.Icon`
	 */
	exports.Icon = React.PropTypes.object;
	
	/**
	 * Checks whether a prop provides a `GoogleMaps.Symbol`
	 */
	exports.Symbol = React.PropTypes.object;
	
	/**
	 * Checks whether a prop provides a `GoogleMaps.MarkerShape`
	 */
	exports.MarkerShape = React.PropTypes.object;
	
	/**
	 * Checks whether a prop provides a `GoogleMaps.MapPanes`
	 */
	exports.MapPanes = React.PropTypes.oneOf(['floatPane', 'mapPane', 'markerLayer', 'overlayLayer', 'overlayMouseTarget']);

/***/ },

/***/ 10:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var invariant = __webpack_require__(22);
	
	function createInitialOptionName(name) {
	  return 'initial' + name.charAt(0).toUpperCase() + name.slice(1)
	}
	
	var MapOptionInjection = {
	
	  /**
	   * Inject some specialized knowledge about the GoogleMaps. This takes a config object
	   * with the following properties:
	   *
	   * Options: object mapping Map option name to a React.PropType validator. If your option
	   * isn't in here, it won't get passed to your Map class.
	   *
	   * MapOptionNames: object mapping React attribute name to the Map
	   * option name.
	   *
	   * @param {object} mapOptionConfig the config as described above.
	   */
	  injectMapOptionConfig: function(mapOptionConfig) {
	    var Options = mapOptionConfig.Options || {};
	    var MapOptionNames = mapOptionConfig.MapOptionNames || {};
	
	    for (var propName in Options) {
	      invariant(
	        !MapOption.isStandardName.hasOwnProperty(propName),
	        'injectMapOptionConfig(...): You\'re trying to inject DOM property ' +
	        '\'%s\' which has already been injected. You may be accidentally ' +
	        'injecting the same DOM property config twice, or you may be ' +
	        'injecting two configs that have conflicting property names.',
	        propName
	      );
	
	      MapOption.isStandardName[propName] = true;
	
	      MapOption.getOptionName[propName] =
	        MapOptionNames.hasOwnProperty(propName) ?
	          MapOptionNames[propName] :
	          propName;
	
	      MapOption.getInitialOptionName[createInitialOptionName(propName)] =
	        MapOption.getOptionName[propName];
	    }
	  }
	};
	
	/**
	 * MapOption exports lookup objects that can be used like functions:
	 *
	 *   > MapOption.isValid['id']
	 *   true
	 *   > MapOption.isValid['foobar']
	 *   undefined
	 *
	 * Although this may be confusing, it performs better in general.
	 *
	 * @see http://jsperf.com/key-exists
	 * @see http://jsperf.com/key-missing
	 */
	var MapOption = {
	
	  /**
	   * Checks whether a option name is a standard option.
	   * @type {Object}
	   */
	  isStandardName: {},
	
	  /**
	   * Mapping from normalized names to option on Map class instances.
	   * @type {Object}
	   */
	  getOptionName: {},
	
	  /**
	   * Mapping from normalized initial names to option on Map class instances.
	   * @type {Object}
	   */
	  getInitialOptionName: {},
	
	  injection: MapOptionInjection
	};
	
	module.exports = MapOption;


/***/ },

/***/ 11:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var invariant = __webpack_require__(22);
	
	var MapEventInjection = {
	
	  /**
	   * Inject some specialized knowledge about the GoogleMaps Events. This takes a object
	   * of config objects with the following properties:
	   *
	   * eventTypes: event config, requires a `name` property is set, this is the name of
	   * the googlemaps event name. Also can have and `effects` property.
	   *
	   * executeDispatch: A function for handling the event dispatch logic.
	   *
	   * @param {object} injectedNamesToPlugins the config as described above.
	   */
	  injectEventPluginsByName: function(injectedNamesToPlugins) {
	    for (var pluginName in injectedNamesToPlugins) {
	      if (!injectedNamesToPlugins.hasOwnProperty(pluginName)) {
	        continue;
	      }
	
	      var PluginModule = injectedNamesToPlugins[pluginName];
	      for (var eventName in PluginModule.eventTypes) {
	        if (!PluginModule.eventTypes.hasOwnProperty(eventName)) {
	          continue;
	        }
	
	        invariant(
	          !MapEvent.isStandardName[eventName],
	          'injectEventPluginsByName(...): Event `%s` has already been defined, ' +
	            'an event can only be handled once',
	          eventName
	        );
	
	        var EventConfig = PluginModule.eventTypes[eventName];
	
	        MapEvent.isStandardName[eventName] = true;
	        MapEvent.getEventName[eventName] = EventConfig.name || eventName;
	        MapEvent.getDispatcher[eventName] = PluginModule.executeDispatch;
	        if (EventConfig.effects) {
	          MapEvent.getOptionSideEffectEvent[EventConfig.effects] = eventName;
	        }
	      }
	    }
	  }
	};
	
	/**
	 * MapEvent exports lookup objects that can be used like functions:
	 *
	 *   > MapEvent.isValid['id']
	 *   true
	 *   > MapEvent.isValid['foobar']
	 *   undefined
	 *
	 * Although this may be confusing, it performs better in general.
	 *
	 * @see http://jsperf.com/key-exists
	 * @see http://jsperf.com/key-missing
	 */
	var MapEvent = {
	
	  /**
	   * Checks whether an event name is a standard event.
	   * @type {Object}
	   */
	  isStandardName: {},
	
	  /**
	   * Mapping from side effect options to normalized event names.
	   * @type {Object}
	   */
	  getOptionSideEffectEvent: {},
	
	  /**
	   * Mapping from normalized event names to GoogleMaps event name.
	   * @type {Object}
	   */
	  getEventName: {},
	
	  /**
	   * Mapping over normalized event names to event dispatchers
	   * @type {Object}
	   */
	  getDispatcher: {},
	
	  createEventDispatcher: function(eventName, instance) {
	    var executeDispatch = MapEvent.getDispatcher[eventName];
	    return function listener(event) {
	      if (!MapEvent.isEnabled) {
	        return;
	      }
	
	      return executeDispatch(event, eventName, instance);
	    }
	  },
	
	  isEnabled: true,
	
	  setEnabled: function(enabled) {
	    MapEvent.isEnabled = enabled;
	  },
	
	  injection: MapEventInjection
	};
	
	module.exports = MapEvent;


/***/ },

/***/ 12:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var CustomPropTypes = __webpack_require__(7);
	
	var MapOptionConfig = {
	  Options: {
	    backgroundColor: React.PropTypes.string,
	    center: CustomPropTypes.LatLng,
	    disableDefaultUI: React.PropTypes.bool,
	    disableDoubleClickZoom: React.PropTypes.bool,
	    draggable: React.PropTypes.bool,
	    draggableCursor: React.PropTypes.string,
	    draggingCursor: React.PropTypes.string,
	    heading: React.PropTypes.number,
	    keyboardShortcuts: React.PropTypes.bool,
	    mapMaker: React.PropTypes.bool,
	    mapTypeControl: React.PropTypes.bool,
	    mapTypeControlOptions: React.PropTypes.object,
	    mapTypeId: React.PropTypes.string,
	    maxZoom: React.PropTypes.number,
	    minZoom: React.PropTypes.number,
	    noClear: React.PropTypes.bool,
	    overviewMapControl: React.PropTypes.bool,
	    overviewMapControlOptions: React.PropTypes.object,
	    panControl: React.PropTypes.bool,
	    panControlOptions: React.PropTypes.object,
	    rotateControl: React.PropTypes.bool,
	    rotateControlOptions: React.PropTypes.object,
	    scaleControl: React.PropTypes.bool,
	    scaleControlOptions: React.PropTypes.object,
	    scrollwheel: React.PropTypes.bool,
	    streetView: React.PropTypes.object,
	    streetViewControl: React.PropTypes.bool,
	    streetViewControlOptions: React.PropTypes.object,
	    styles: React.PropTypes.array,
	    tilt: React.PropTypes.number,
	    zoom: React.PropTypes.number,
	    zoomControl: React.PropTypes.bool,
	    zoomControlOptions: React.PropTypes.object,
	    anchorPoint: CustomPropTypes.Point,
	    animation: CustomPropTypes.Animation,
	    clickable: React.PropTypes.bool,
	    crossOnDrag: React.PropTypes.bool,
	    cursor: React.PropTypes.string,
	    icon: React.PropTypes.oneOfType([
	      React.PropTypes.string,
	      CustomPropTypes.Icon,
	      CustomPropTypes.Symbol
	    ]),
	    map: CustomPropTypes.Map,
	    opacity: React.PropTypes.number,
	    optimized: React.PropTypes.bool,
	    position: CustomPropTypes.LatLng,
	    shape: CustomPropTypes.MarkerShape,
	    title: React.PropTypes.string,
	    visible: React.PropTypes.bool,
	    zIndex: React.PropTypes.number,
	    editable: React.PropTypes.bool,
	    geodesic: React.PropTypes.bool,
	    icons: React.PropTypes.array,
	    path: React.PropTypes.array,
	    strokeColor: React.PropTypes.string,
	    strokeOpacity: React.PropTypes.number,
	    strokeWeight: React.PropTypes.number,
	    fillColor: React.PropTypes.string,
	    fillOpacity: React.PropTypes.number,
	    paths: React.PropTypes.array,
	    strokePosition: React.PropTypes.any,
	    bounds: CustomPropTypes.LatLngBounds,
	    radius: React.PropTypes.number
	  },
	
	  MapOptionNames: {
	    // Format:
	    // autoCapitalize: 'autocapitalize'
	  }
	};
	
	module.exports = MapOptionConfig;


/***/ },

/***/ 13:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var cloneWithProps = __webpack_require__(23);
	var keyMirror = __webpack_require__(24);
	var ReactMapComponents = __webpack_require__(6);
	var MapPropTypes = __webpack_require__(7);
	var PropTypeUtils = __webpack_require__(25);
	var ReactFrag = __webpack_require__(15);
	
	var GoogleMapsMap = ReactMapComponents.Map;
	
	// TODO: Remove the need for this, we shouldn't need to render 3 times to initialise
	var MapLifeCycle = keyMirror({
	  CREATING_HOLDER: null,
	  CREATING_MAP: null
	});
	
	var ReactMap = React.createClass({displayName: "ReactMap",
	  propTypes: {
	    zoom: PropTypeUtils.or('initialZoom', React.PropTypes.number).isRequired,
	    center: PropTypeUtils.or('initialCenter', MapPropTypes.LatLng).isRequired,
	    width: React.PropTypes.oneOfType([React.PropTypes.number, React.PropTypes.string]),
	    height: React.PropTypes.oneOfType([React.PropTypes.number, React.PropTypes.string])
	  },
	
	  getInitialState: function() {
	    return {
	      mapLifeCycleState: MapLifeCycle.CREATING_HOLDER
	    };
	  },
	
	  componentDidMount: function() {
	    // Now we have the map created, we need to run the render
	    // cycle again to pass down the `map` holder for the
	    // components to render into.
	    this.setState({mapLifeCycleState: MapLifeCycle.CREATING_MAP});
	  },
	
	  componentDidUpdate: function() {
	    if (this.state.mapLifeCycleState === MapLifeCycle.CREATING_MAP) {
	      this.setState({mapLifeCycleState: null});
	    }
	  },
	
	  render: function() {
	    var holderStyle = {
	      width: this.props.width,
	      height: this.props.height
	    };
	
	    var map;
	    if (this.state.mapLifeCycleState !== MapLifeCycle.CREATING_HOLDER) {
	      map = (
	        React.createElement(GoogleMapsMap, React.__spread({}, 
	          this.props, 
	          {ref: "map", 
	          mapDiv: this.refs.mapHolder.getDOMNode(), 
	          width: null, 
	          height: null}))
	      );
	    }
	
	    var children;
	    if (!this.state.mapLifeCycleState) {
	      children = (
	        React.createElement(ReactFrag, {map: this.refs.map.__node}, 
	          this.props.children
	        )
	      );
	    }
	
	    return (
	      React.createElement("div", null, 
	        React.createElement("div", {
	          ref: "mapHolder", 
	          className: this.props.className, 
	          style: holderStyle}), 
	
	        map, 
	        children
	      )
	      );
	  }
	});
	
	module.exports = ReactMap;


/***/ },

/***/ 14:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var assign = __webpack_require__(4);
	var cloneWithProps = __webpack_require__(23);
	var GoogleMapsAPI = __webpack_require__(19);
	var MapPropTypes = __webpack_require__(7);
	
	function MapOverlayView(props) {
	  this.props = props;
	  this.setMap(props.map);
	}
	
	MapOverlayView.prototype = new GoogleMapsAPI.OverlayView();
	
	MapOverlayView.prototype.onAdd = function() {
	  this._containerElement = document.createElement('div');
	  this.getPanes()[this.props.mapPane]
	    .appendChild(this._containerElement);
	};
	
	MapOverlayView.prototype.draw = function() {
	  var props = assign({}, this.props, {position: null, mapPane: null});
	  if (this.props.position) {
	    var point = this.getProjection()
	      .fromLatLngToDivPixel(this.props.position);
	
	    props.style = assign({}, {
	      position: 'absolute',
	      left: point.x,
	      top: point.y
	    }, this.props.style);
	  }
	
	  React.render(
	    cloneWithProps(React.createElement("div", null), props),
	    this._containerElement
	  )
	};
	
	MapOverlayView.prototype.onRemove = function() {
	  React.unmountComponentAtNode(this._containerElement);
	  this._containerElement.parentNode
	    .removeChild(this._containerElement);
	  this._containerElement = null;
	};
	
	var ReactOverlayView = React.createClass({
	  displayName: 'OverlayView',
	
	  propTypes: {
	    mapPane: MapPropTypes.MapPanes.isRequired
	  },
	
	  getDefaultProps: function() {
	    return {
	      mapPane: 'overlayLayer'
	    };
	  },
	
	  render: function() {
	    // Nothing to render
	    return null;
	  },
	
	  componentDidMount: function() {
	    this.__node = new MapOverlayView(this.props);
	  },
	
	  componentDidUpdate: function(prevProps) {
	    this.__node.props = this.props;
	    this.__node.draw();
	
	    if (this.props.mapPane != prevProps.mapPane) {
	      // Unmount then, mount again onto the correct map pane
	      this.__node.setMap(null);
	      this.__node.setMap(this.props.map);
	    }
	  },
	
	  componentWillUnmount: function() {
	    this.__node.setMap(null);
	    this.__node = null;
	  }
	});
	
	module.exports = ReactOverlayView;


/***/ },

/***/ 15:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var cloneWithProps = __webpack_require__(23);
	var MapPropTypes = __webpack_require__(7);
	
	function injectMapInto(child) {
	  return React.isValidElement(child) ?
	    cloneWithProps(child, {map: this.props.map}) : child;
	}
	
	var ReactFrag = React.createClass({displayName: "ReactFrag",
	  propTypes: {
	    map: MapPropTypes.Map.isRequired,
	  },
	
	  render: function() {
	    // Inject the `mapProps` into all children that are
	    // valid components.
	    var children = React.Children
	      .map(this.props.children, injectMapInto, this);
	
	    return (
	      React.createElement("span", null, children)
	      );
	  }
	});
	
	module.exports = ReactFrag;


/***/ },

/***/ 16:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var eventTypes = {
	  onIdle: {
	    name: 'idle'
	  },
	  onResize: {
	    name: 'resize'
	  },
	  onTilesLoaded: {
	    name: 'tilesloaded'
	  },
	  onProjectionChange: {
	    name: 'projection_changed'
	  },
	  onFlatChange: {
	    name: 'flat_changed'
	  }
	};
	
	var SimpleEventPlugin = {
	
	  eventTypes: eventTypes,
	
	  executeDispatch: function(event, eventName, instance) {
	    var listener = instance.props[eventName];
	
	    return listener(instance.getMapNode());
	  }
	};
	
	module.exports = SimpleEventPlugin;


/***/ },

/***/ 17:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var eventTypes = {
	  onClick: {
	    name: 'click'
	  },
	  onDoubleClick: {
	    name: 'dblclick'
	  },
	  onDrag: {
	    name: 'drag'
	  },
	  onDragEnd: {
	    name: 'dragend'
	  },
	  onDragStart: {
	    name: 'dragstart'
	  },
	  onMouseDown: {
	    name: 'mousedown'
	  },
	  onMouseMove: {
	    name: 'mousemove'
	  },
	  onMouseOut: {
	    name: 'mouseout'
	  },
	  onMouseOver: {
	    name: 'mouseover'
	  },
	  onMouseUp: {
	    name: 'mouseup'
	  },
	  onRightClick: {
	    name: 'rightclick'
	  }
	};
	
	var MouseEventPlugin = {
	
	  eventTypes: eventTypes,
	
	  executeDispatch: function(event, eventName, instance) {
	    var listener = instance.props[eventName];
	
	    return listener(event, instance.getMapNode());
	  }
	};
	
	module.exports = MouseEventPlugin;


/***/ },

/***/ 18:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var SimpleEventPlugin = __webpack_require__(16);
	
	var eventTypes = {
	  onCenterChange: {
	    name: 'center_changed',
	    effects: 'center'
	  },
	  onZoomChange: {
	    name: 'zoom_changed',
	    effects: 'zoom'
	  },
	  onBoundsChange: {
	    name: 'bounds_changed',
	    effects: 'bounds'
	  },
	  onHeadingChange: {
	    name: 'heading_changed',
	    effects: 'heading'
	  },
	  onMapTypeIdChange: {
	    name: 'maptypeid_changed',
	    effects: 'mapTypeId'
	  },
	  onTiltChange: {
	    name: 'tilt_changed',
	    effects: 'tilt'
	  },
	  onAnimationChange: {
	    name: 'animation_changed',
	    effects: 'animation'
	  },
	  onClickableChange: {
	    name: 'clickable_changed',
	    effects: 'clickable'
	  },
	  onCursorChange: {
	    name: 'cursor_changed',
	    effects: 'cursor'
	  },
	  onDraggableChange: {
	    name: 'draggable_changed',
	    effects: 'draggable'
	  },
	  onIconChange: {
	    name: 'icon_changed',
	    effects: 'icon'
	  },
	  onPositionChange: {
	    name: 'position_changed',
	    effects: 'position'
	  },
	  onShapeChange: {
	    name: 'shape_changed',
	    effects: 'shape'
	  },
	  onTitleChange: {
	    name: 'title_changed',
	    effects: 'title'
	  },
	  onVisibleChange: {
	    name: 'visible_changed',
	    effects: 'visible'
	  },
	  onZIndexChange: {
	    name: 'zindex_changed',
	    effects: 'zindex'
	  },
	  onRadiusChange: {
	    name: 'radius_changed',
	    effects: 'radius'
	  }
	};
	
	var SideEffectEventPlugin = {
	
	  eventTypes: eventTypes,
	
	  executeDispatch: function(event, eventName, instance) {
	    var effects = eventTypes[eventName].effects;
	
	    if (instance.props[effects] == null) {
	      // The effected property is not set so this event listener
	      // only needs to be passive.
	      return SimpleEventPlugin.executeDispatch(event, eventName, instance)
	    }
	
	    var listener = instance.props[eventName];
	    var returnVal;
	    if (listener) {
	      instance.queueDirtyCheck();
	      returnVal = listener(instance.getMapNode());
	    }
	    instance.flushDirtyChangesTo(effects);
	
	    return returnVal;
	  }
	};
	
	module.exports = SideEffectEventPlugin;


/***/ },

/***/ 19:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var invariant = __webpack_require__(22);
	
	invariant(
	  window.google && window.google.maps,
	  '`google.maps` global object not found, make sure ' +
	    'Google maps in included before react-googlemaps is defined'
	);
	
	module.exports = window.google.maps;

/***/ },

/***/ 20:
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copyright 2013-2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule mapObject
	 */
	
	'use strict';
	
	var hasOwnProperty = Object.prototype.hasOwnProperty;
	
	/**
	 * Executes the provided `callback` once for each enumerable own property in the
	 * object and constructs a new object from the results. The `callback` is
	 * invoked with three arguments:
	 *
	 *  - the property value
	 *  - the property name
	 *  - the object being traversed
	 *
	 * Properties that are added after the call to `mapObject` will not be visited
	 * by `callback`. If the values of existing properties are changed, the value
	 * passed to `callback` will be the value at the time `mapObject` visits them.
	 * Properties that are deleted before being visited are not visited.
	 *
	 * @grep function objectMap()
	 * @grep function objMap()
	 *
	 * @param {?object} object
	 * @param {function} callback
	 * @param {*} context
	 * @return {?object}
	 */
	function mapObject(object, callback, context) {
	  if (!object) {
	    return null;
	  }
	  var result = {};
	  for (var name in object) {
	    if (hasOwnProperty.call(object, name)) {
	      result[name] = callback.call(context, object[name], name, object);
	    }
	  }
	  return result;
	}
	
	module.exports = mapObject;


/***/ },

/***/ 21:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var invariant = __webpack_require__(22);
	var GoogleMapsAPI = __webpack_require__(19);
	var ReactMapComponentMixin = __webpack_require__(58);
	
	/**
	 * React render implementation
	 *
	 * @returns {null}
	 */
	function nullRenderer() {
	  return null;
	}
	
	/**
	 * Create base constructor for google map class
	 *
	 * @param {string} constructorName
	 * @returns {Function}
	 */
	function createGoogleMapClassConstructor(constructorName) {
	  var Constructor = GoogleMapsAPI[constructorName];
	
	  invariant(Constructor, 'Google Maps class of `%s` does not exist', constructorName);
	
	  return function() {
	    return new Constructor();
	  }
	}
	
	
	var ReactMapComponent = {
	
	  /**
	   * Create base map component of type
	   *
	   * @param {string} constructorName
	   * @param {function?} constructorFn
	   * @return {ReactComponent}
	   */
	  create: function(constructorName, constructorFn) {
	    return React.createClass({
	      displayName: constructorName,
	
	      mixins: [ReactMapComponentMixin],
	
	      constructGoogleMapsClass: constructorFn || createGoogleMapClassConstructor(constructorName),
	
	      render: nullRenderer
	    });
	  }
	};
	
	module.exports = ReactMapComponent;


/***/ },

/***/ 22:
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {/**
	 * Copyright 2013-2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule invariant
	 */
	
	"use strict";
	
	/**
	 * Use invariant() to assert state which your program assumes to be true.
	 *
	 * Provide sprintf-style format (only %s is supported) and arguments
	 * to provide information about what broke and what you were
	 * expecting.
	 *
	 * The invariant message will be stripped in production, but the invariant
	 * will remain to ensure logic does not differ in production.
	 */
	
	var invariant = function(condition, format, a, b, c, d, e, f) {
	  if ("production" !== process.env.NODE_ENV) {
	    if (format === undefined) {
	      throw new Error('invariant requires an error message argument');
	    }
	  }
	
	  if (!condition) {
	    var error;
	    if (format === undefined) {
	      error = new Error(
	        'Minified exception occurred; use the non-minified dev environment ' +
	        'for the full error message and additional helpful warnings.'
	      );
	    } else {
	      var args = [a, b, c, d, e, f];
	      var argIndex = 0;
	      error = new Error(
	        'Invariant Violation: ' +
	        format.replace(/%s/g, function() { return args[argIndex++]; })
	      );
	    }
	
	    error.framesToPop = 1; // we don't care about invariant's own frame
	    throw error;
	  }
	};
	
	module.exports = invariant;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(59)))

/***/ },

/***/ 23:
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {/**
	 * Copyright 2013-2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @typechecks
	 * @providesModule cloneWithProps
	 */
	
	"use strict";
	
	var ReactElement = __webpack_require__(42);
	var ReactPropTransferer = __webpack_require__(61);
	
	var keyOf = __webpack_require__(62);
	var warning = __webpack_require__(63);
	
	var CHILDREN_PROP = keyOf({children: null});
	
	/**
	 * Sometimes you want to change the props of a child passed to you. Usually
	 * this is to add a CSS class.
	 *
	 * @param {object} child child component you'd like to clone
	 * @param {object} props props you'd like to modify. They will be merged
	 * as if you used `transferPropsTo()`.
	 * @return {object} a clone of child with props merged in.
	 */
	function cloneWithProps(child, props) {
	  if ("production" !== process.env.NODE_ENV) {
	    ("production" !== process.env.NODE_ENV ? warning(
	      !child.ref,
	      'You are calling cloneWithProps() on a child with a ref. This is ' +
	      'dangerous because you\'re creating a new child which will not be ' +
	      'added as a ref to its parent.'
	    ) : null);
	  }
	
	  var newProps = ReactPropTransferer.mergeProps(props, child.props);
	
	  // Use `child.props.children` if it is provided.
	  if (!newProps.hasOwnProperty(CHILDREN_PROP) &&
	      child.props.hasOwnProperty(CHILDREN_PROP)) {
	    newProps.children = child.props.children;
	  }
	
	  // The current API doesn't retain _owner and _context, which is why this
	  // doesn't use ReactElement.cloneAndReplaceProps.
	  return ReactElement.createElement(child.type, newProps);
	}
	
	module.exports = cloneWithProps;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(59)))

/***/ },

/***/ 24:
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {/**
	 * Copyright 2013-2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule keyMirror
	 * @typechecks static-only
	 */
	
	"use strict";
	
	var invariant = __webpack_require__(22);
	
	/**
	 * Constructs an enumeration with keys equal to their value.
	 *
	 * For example:
	 *
	 *   var COLORS = keyMirror({blue: null, red: null});
	 *   var myColor = COLORS.blue;
	 *   var isColorValid = !!COLORS[myColor];
	 *
	 * The last line could not be performed if the values of the generated enum were
	 * not equal to their keys.
	 *
	 *   Input:  {key1: val1, key2: val2}
	 *   Output: {key1: key1, key2: key2}
	 *
	 * @param {object} obj
	 * @return {object}
	 */
	var keyMirror = function(obj) {
	  var ret = {};
	  var key;
	  ("production" !== process.env.NODE_ENV ? invariant(
	    obj instanceof Object && !Array.isArray(obj),
	    'keyMirror(...): Argument must be an object.'
	  ) : invariant(obj instanceof Object && !Array.isArray(obj)));
	  for (key in obj) {
	    if (!obj.hasOwnProperty(key)) {
	      continue;
	    }
	    ret[key] = key;
	  }
	  return ret;
	};
	
	module.exports = keyMirror;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(59)))

/***/ },

/***/ 25:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	/**
	 * Check if a prop or another specified prop has a valid value
	 * @type {function}
	 */
	exports.or = createChainableOrTypeChecker;
	
	function createChainableOrTypeChecker(orPropName, validate) {
	  function checkType(isRequired, props, propName, componentName) {
	    componentName = componentName || ANONYMOUS;
	    if (props[propName] == null && props[orPropName] == null) {
	      if (isRequired) {
	        return new Error(
	          'Required prop `' + propName + '` or `' + orPropName + '` was not specified in ' +
	            '`' + componentName + '`.'
	        );
	      }
	    } else {
	      var validatePropName = props[propName] == null ? orPropName : propName;
	      return validate(props, validatePropName, componentName);
	    }
	  }
	
	  var chainedCheckType = checkType.bind(null, false);
	  chainedCheckType.isRequired = checkType.bind(null, true);
	
	  return chainedCheckType;
	}

/***/ },

/***/ 40:
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copyright 2013-2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule ReactContext
	 */
	
	"use strict";
	
	var assign = __webpack_require__(4);
	
	/**
	 * Keeps track of the current context.
	 *
	 * The context is automatically passed down the component ownership hierarchy
	 * and is accessible via `this.context` on ReactCompositeComponents.
	 */
	var ReactContext = {
	
	  /**
	   * @internal
	   * @type {object}
	   */
	  current: {},
	
	  /**
	   * Temporarily extends the current context while executing scopedCallback.
	   *
	   * A typical use case might look like
	   *
	   *  render: function() {
	   *    var children = ReactContext.withContext({foo: 'foo'}, () => (
	   *
	   *    ));
	   *    return <div>{children}</div>;
	   *  }
	   *
	   * @param {object} newContext New context to merge into the existing context
	   * @param {function} scopedCallback Callback to run with the new context
	   * @return {ReactComponent|array<ReactComponent>}
	   */
	  withContext: function(newContext, scopedCallback) {
	    var result;
	    var previousContext = ReactContext.current;
	    ReactContext.current = assign({}, previousContext, newContext);
	    try {
	      result = scopedCallback();
	    } finally {
	      ReactContext.current = previousContext;
	    }
	    return result;
	  }
	
	};
	
	module.exports = ReactContext;


/***/ },

/***/ 41:
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copyright 2013-2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule ReactCurrentOwner
	 */
	
	"use strict";
	
	/**
	 * Keeps track of the current owner.
	 *
	 * The current owner is the component who should own any components that are
	 * currently being constructed.
	 *
	 * The depth indicate how many composite components are above this render level.
	 */
	var ReactCurrentOwner = {
	
	  /**
	   * @internal
	   * @type {ReactComponent}
	   */
	  current: null
	
	};
	
	module.exports = ReactCurrentOwner;


/***/ },

/***/ 42:
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {/**
	 * Copyright 2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule ReactElement
	 */
	
	"use strict";
	
	var ReactContext = __webpack_require__(40);
	var ReactCurrentOwner = __webpack_require__(41);
	
	var warning = __webpack_require__(63);
	
	var RESERVED_PROPS = {
	  key: true,
	  ref: true
	};
	
	/**
	 * Warn for mutations.
	 *
	 * @internal
	 * @param {object} object
	 * @param {string} key
	 */
	function defineWarningProperty(object, key) {
	  Object.defineProperty(object, key, {
	
	    configurable: false,
	    enumerable: true,
	
	    get: function() {
	      if (!this._store) {
	        return null;
	      }
	      return this._store[key];
	    },
	
	    set: function(value) {
	      ("production" !== process.env.NODE_ENV ? warning(
	        false,
	        'Don\'t set the ' + key + ' property of the component. ' +
	        'Mutate the existing props object instead.'
	      ) : null);
	      this._store[key] = value;
	    }
	
	  });
	}
	
	/**
	 * This is updated to true if the membrane is successfully created.
	 */
	var useMutationMembrane = false;
	
	/**
	 * Warn for mutations.
	 *
	 * @internal
	 * @param {object} element
	 */
	function defineMutationMembrane(prototype) {
	  try {
	    var pseudoFrozenProperties = {
	      props: true
	    };
	    for (var key in pseudoFrozenProperties) {
	      defineWarningProperty(prototype, key);
	    }
	    useMutationMembrane = true;
	  } catch (x) {
	    // IE will fail on defineProperty
	  }
	}
	
	/**
	 * Base constructor for all React elements. This is only used to make this
	 * work with a dynamic instanceof check. Nothing should live on this prototype.
	 *
	 * @param {*} type
	 * @param {string|object} ref
	 * @param {*} key
	 * @param {*} props
	 * @internal
	 */
	var ReactElement = function(type, key, ref, owner, context, props) {
	  // Built-in properties that belong on the element
	  this.type = type;
	  this.key = key;
	  this.ref = ref;
	
	  // Record the component responsible for creating this element.
	  this._owner = owner;
	
	  // TODO: Deprecate withContext, and then the context becomes accessible
	  // through the owner.
	  this._context = context;
	
	  if ("production" !== process.env.NODE_ENV) {
	    // The validation flag and props are currently mutative. We put them on
	    // an external backing store so that we can freeze the whole object.
	    // This can be replaced with a WeakMap once they are implemented in
	    // commonly used development environments.
	    this._store = { validated: false, props: props };
	
	    // We're not allowed to set props directly on the object so we early
	    // return and rely on the prototype membrane to forward to the backing
	    // store.
	    if (useMutationMembrane) {
	      Object.freeze(this);
	      return;
	    }
	  }
	
	  this.props = props;
	};
	
	// We intentionally don't expose the function on the constructor property.
	// ReactElement should be indistinguishable from a plain object.
	ReactElement.prototype = {
	  _isReactElement: true
	};
	
	if ("production" !== process.env.NODE_ENV) {
	  defineMutationMembrane(ReactElement.prototype);
	}
	
	ReactElement.createElement = function(type, config, children) {
	  var propName;
	
	  // Reserved names are extracted
	  var props = {};
	
	  var key = null;
	  var ref = null;
	
	  if (config != null) {
	    ref = config.ref === undefined ? null : config.ref;
	    if ("production" !== process.env.NODE_ENV) {
	      ("production" !== process.env.NODE_ENV ? warning(
	        config.key !== null,
	        'createElement(...): Encountered component with a `key` of null. In ' +
	        'a future version, this will be treated as equivalent to the string ' +
	        '\'null\'; instead, provide an explicit key or use undefined.'
	      ) : null);
	    }
	    // TODO: Change this back to `config.key === undefined`
	    key = config.key == null ? null : '' + config.key;
	    // Remaining properties are added to a new props object
	    for (propName in config) {
	      if (config.hasOwnProperty(propName) &&
	          !RESERVED_PROPS.hasOwnProperty(propName)) {
	        props[propName] = config[propName];
	      }
	    }
	  }
	
	  // Children can be more than one argument, and those are transferred onto
	  // the newly allocated props object.
	  var childrenLength = arguments.length - 2;
	  if (childrenLength === 1) {
	    props.children = children;
	  } else if (childrenLength > 1) {
	    var childArray = Array(childrenLength);
	    for (var i = 0; i < childrenLength; i++) {
	      childArray[i] = arguments[i + 2];
	    }
	    props.children = childArray;
	  }
	
	  // Resolve default props
	  if (type && type.defaultProps) {
	    var defaultProps = type.defaultProps;
	    for (propName in defaultProps) {
	      if (typeof props[propName] === 'undefined') {
	        props[propName] = defaultProps[propName];
	      }
	    }
	  }
	
	  return new ReactElement(
	    type,
	    key,
	    ref,
	    ReactCurrentOwner.current,
	    ReactContext.current,
	    props
	  );
	};
	
	ReactElement.createFactory = function(type) {
	  var factory = ReactElement.createElement.bind(null, type);
	  // Expose the type on the factory and the prototype so that it can be
	  // easily accessed on elements. E.g. <Foo />.type === Foo.type.
	  // This should not be named `constructor` since this may not be the function
	  // that created the element, and it may not even be a constructor.
	  factory.type = type;
	  return factory;
	};
	
	ReactElement.cloneAndReplaceProps = function(oldElement, newProps) {
	  var newElement = new ReactElement(
	    oldElement.type,
	    oldElement.key,
	    oldElement.ref,
	    oldElement._owner,
	    oldElement._context,
	    newProps
	  );
	
	  if ("production" !== process.env.NODE_ENV) {
	    // If the key on the original is valid, then the clone is valid
	    newElement._store.validated = oldElement._store.validated;
	  }
	  return newElement;
	};
	
	/**
	 * @param {?object} object
	 * @return {boolean} True if `object` is a valid component.
	 * @final
	 */
	ReactElement.isValidElement = function(object) {
	  // ReactTestUtils is often used outside of beforeEach where as React is
	  // within it. This leads to two different instances of React on the same
	  // page. To identify a element from a different React instance we use
	  // a flag instead of an instanceof check.
	  var isElement = !!(object && object._isReactElement);
	  // if (isElement && !(object instanceof ReactElement)) {
	  // This is an indicator that you're using multiple versions of React at the
	  // same time. This will screw with ownership and stuff. Fix it, please.
	  // TODO: We could possibly warn here.
	  // }
	  return isElement;
	};
	
	module.exports = ReactElement;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(59)))

/***/ },

/***/ 58:
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var assign = __webpack_require__(4);
	var invariant = __webpack_require__(22);
	var MapOption = __webpack_require__(10);
	var MapOptionConfig = __webpack_require__(12);
	var MapEvent = __webpack_require__(11);
	var GoogleMapsAPI = __webpack_require__(19);
	
	/**
	 * Cached reset map option object
	 */
	var resetMapOptionObject = {map: null};
	
	/**
	 * Empty props cache
	 */
	var emptyPropsCache = {};
	
	/**
	 * Empty function to be provided to event handlers
	 */
	function noop() {}
	
	/**
	 * GoogleMaps React component mixin
	 */
	var ReactMapComponentMixin = {
	  propTypes: assign({}, MapOptionConfig.Options),
	
	  shouldComponentUpdate: function() {
	    return this.__shouldComponentUpdate;
	  },
	
	  componentDidMount: function() {
	    this.__shouldComponentUpdate = true;
	    this.__dirtyOptions = {};
	    this.__eventCache = {};
	    this.__node = this.constructGoogleMapsClass();
	    this._setInitialMapProperties();
	    this._updateMapProperties(emptyPropsCache);
	  },
	
	  componentDidUpdate: function(prevProps) {
	    this._updateMapProperties(prevProps);
	  },
	
	  _setInitialMapProperties: function() {
	    var initialMapOptions = {};
	    var props = this.props;
	    for (var propKey in props) {
	      var optionName = MapOption.getInitialOptionName[propKey];
	      if (!props.hasOwnProperty(propKey) || !optionName) {
	        continue;
	      }
	
	      initialMapOptions[optionName] = props[propKey];
	    }
	
	    this.flushOptionChanges(initialMapOptions);
	  },
	
	  _updateMapProperties: function(lastProps) {
	    var nextProps = this.props;
	    var mapOptionChanges = {};
	    var mapEventChanges = {};
	    var propKey;
	
	    // Remove any options or events that no longer
	    // exist in the new set of props.
	    for (propKey in lastProps) {
	      if (nextProps.hasOwnProperty(propKey) ||
	        !lastProps.hasOwnProperty(propKey)) {
	        continue;
	      }
	
	      if (MapEvent.isStandardName[propKey]) {
	        mapEventChanges[propKey] = null;
	      } else if (MapOption.isStandardName[propKey]) {
	        mapOptionChanges[propKey] = null;
	      }
	    }
	
	    // Add any changed options or new events.
	    for (propKey in nextProps) {
	      var nextProp = nextProps[propKey];
	      var lastProp = lastProps[propKey];
	      if (!nextProps.hasOwnProperty(propKey) ||
	        (nextProp === lastProp && !this.__dirtyOptions[propKey])) {
	        continue;
	      }
	
	      if (MapEvent.isStandardName[propKey] && !lastProp) {
	        mapEventChanges[propKey] = nextProp;
	      } else if (MapOption.isStandardName[propKey]) {
	        mapOptionChanges[MapOption.getOptionName[propKey]] = nextProps[propKey];
	      }
	    }
	
	    // Added check of changed options that have side effect events,
	    // if they don't have a handler then add a noop one for this event
	    // to trigger the side effect dirty checking.
	    for (propKey in mapOptionChanges) {
	      var sideEffectEvent = MapEvent.getOptionSideEffectEvent[propKey];
	      if (!mapOptionChanges.hasOwnProperty(propKey) || !sideEffectEvent || nextProps[sideEffectEvent]) {
	        continue;
	      }
	
	      var hasNextProp = nextProps[propKey] != null;
	      var hasLastProp = lastProps[propKey] != null;
	
	      if (hasLastProp && !hasNextProp) {
	        mapEventChanges[sideEffectEvent] = null;
	      } else if (!hasLastProp && hasNextProp) {
	        mapEventChanges[sideEffectEvent] = noop;
	      }
	    }
	
	    this.flushOptionChanges(mapOptionChanges);
	    this.flushEventChanges(mapEventChanges);
	  },
	
	  flushOptionChanges: function(optionChanges) {
	    MapEvent.setEnabled(false);
	    this.__node.setOptions(optionChanges);
	    MapEvent.setEnabled(true);
	  },
	
	  flushEventChanges: function(eventChanges) {
	    for (var eventName in eventChanges) {
	      if (!eventChanges.hasOwnProperty(eventName)) {
	        continue;
	      }
	
	      if (eventChanges[eventName]) {
	        this.putListener(eventName);
	      } else {
	        this.deleteListener(eventName);
	      }
	    }
	  },
	
	  componentWillUnmount: function() {
	    this.deleteAllListeners();
	
	    if (this.props.map) {
	      // If we still have a map prop at this point we should unset it from the node
	      this.flushOptionChanges(resetMapOptionObject);
	    }
	    this.__node = null;
	  },
	
	  putListener: function(eventName) {
	    invariant(!this.__eventCache[eventName], 'Already has `%s` event bound', eventName);
	
	    this.__eventCache[eventName] = GoogleMapsAPI.event.addListener(
	      this.__node,
	      MapEvent.getEventName[eventName],
	      MapEvent.createEventDispatcher(eventName, this)
	    );
	  },
	
	  deleteListener: function(eventName) {
	    invariant(this.__eventCache[eventName], 'No event of `%s` bound to remove', eventName);
	
	    GoogleMapsAPI.event.removeListener(this.__eventCache[eventName]);
	    delete this.__eventCache[eventName];
	  },
	
	  deleteAllListeners: function() {
	    for (var eventName in this.__eventCache) {
	      if (this.__eventCache.hasOwnProperty(eventName)) {
	        this.deleteListener(eventName);
	      }
	    }
	  },
	
	  queueDirtyCheck: function() {
	    this.__shouldComponentUpdate = false;
	  },
	
	  flushDirtyChangesTo: function(effects) {
	    this.__shouldComponentUpdate = true;
	    this.__dirtyOptions[effects] = true;
	    this.forceUpdate();
	    this.__dirtyOptions = {};
	  },
	
	  getMapNode: function() {
	    return this.__node;
	  }
	};
	
	module.exports = ReactMapComponentMixin;


/***/ },

/***/ 59:
/***/ function(module, exports, __webpack_require__) {

	// shim for using process in browser
	
	var process = module.exports = {};
	
	process.nextTick = (function () {
	    var canSetImmediate = typeof window !== 'undefined'
	    && window.setImmediate;
	    var canMutationObserver = typeof window !== 'undefined'
	    && window.MutationObserver;
	    var canPost = typeof window !== 'undefined'
	    && window.postMessage && window.addEventListener
	    ;
	
	    if (canSetImmediate) {
	        return function (f) { return window.setImmediate(f) };
	    }
	
	    var queue = [];
	
	    if (canMutationObserver) {
	        var hiddenDiv = document.createElement("div");
	        var observer = new MutationObserver(function () {
	            var queueList = queue.slice();
	            queue.length = 0;
	            queueList.forEach(function (fn) {
	                fn();
	            });
	        });
	
	        observer.observe(hiddenDiv, { attributes: true });
	
	        return function nextTick(fn) {
	            if (!queue.length) {
	                hiddenDiv.setAttribute('yes', 'no');
	            }
	            queue.push(fn);
	        };
	    }
	
	    if (canPost) {
	        window.addEventListener('message', function (ev) {
	            var source = ev.source;
	            if ((source === window || source === null) && ev.data === 'process-tick') {
	                ev.stopPropagation();
	                if (queue.length > 0) {
	                    var fn = queue.shift();
	                    fn();
	                }
	            }
	        }, true);
	
	        return function nextTick(fn) {
	            queue.push(fn);
	            window.postMessage('process-tick', '*');
	        };
	    }
	
	    return function nextTick(fn) {
	        setTimeout(fn, 0);
	    };
	})();
	
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	
	function noop() {}
	
	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;
	
	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};
	
	// TODO(shtylman)
	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};


/***/ },

/***/ 61:
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {/**
	 * Copyright 2013-2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule ReactPropTransferer
	 */
	
	"use strict";
	
	var assign = __webpack_require__(4);
	var emptyFunction = __webpack_require__(68);
	var invariant = __webpack_require__(22);
	var joinClasses = __webpack_require__(127);
	var warning = __webpack_require__(63);
	
	var didWarn = false;
	
	/**
	 * Creates a transfer strategy that will merge prop values using the supplied
	 * `mergeStrategy`. If a prop was previously unset, this just sets it.
	 *
	 * @param {function} mergeStrategy
	 * @return {function}
	 */
	function createTransferStrategy(mergeStrategy) {
	  return function(props, key, value) {
	    if (!props.hasOwnProperty(key)) {
	      props[key] = value;
	    } else {
	      props[key] = mergeStrategy(props[key], value);
	    }
	  };
	}
	
	var transferStrategyMerge = createTransferStrategy(function(a, b) {
	  // `merge` overrides the first object's (`props[key]` above) keys using the
	  // second object's (`value`) keys. An object's style's existing `propA` would
	  // get overridden. Flip the order here.
	  return assign({}, b, a);
	});
	
	/**
	 * Transfer strategies dictate how props are transferred by `transferPropsTo`.
	 * NOTE: if you add any more exceptions to this list you should be sure to
	 * update `cloneWithProps()` accordingly.
	 */
	var TransferStrategies = {
	  /**
	   * Never transfer `children`.
	   */
	  children: emptyFunction,
	  /**
	   * Transfer the `className` prop by merging them.
	   */
	  className: createTransferStrategy(joinClasses),
	  /**
	   * Transfer the `style` prop (which is an object) by merging them.
	   */
	  style: transferStrategyMerge
	};
	
	/**
	 * Mutates the first argument by transferring the properties from the second
	 * argument.
	 *
	 * @param {object} props
	 * @param {object} newProps
	 * @return {object}
	 */
	function transferInto(props, newProps) {
	  for (var thisKey in newProps) {
	    if (!newProps.hasOwnProperty(thisKey)) {
	      continue;
	    }
	
	    var transferStrategy = TransferStrategies[thisKey];
	
	    if (transferStrategy && TransferStrategies.hasOwnProperty(thisKey)) {
	      transferStrategy(props, thisKey, newProps[thisKey]);
	    } else if (!props.hasOwnProperty(thisKey)) {
	      props[thisKey] = newProps[thisKey];
	    }
	  }
	  return props;
	}
	
	/**
	 * ReactPropTransferer are capable of transferring props to another component
	 * using a `transferPropsTo` method.
	 *
	 * @class ReactPropTransferer
	 */
	var ReactPropTransferer = {
	
	  TransferStrategies: TransferStrategies,
	
	  /**
	   * Merge two props objects using TransferStrategies.
	   *
	   * @param {object} oldProps original props (they take precedence)
	   * @param {object} newProps new props to merge in
	   * @return {object} a new object containing both sets of props merged.
	   */
	  mergeProps: function(oldProps, newProps) {
	    return transferInto(assign({}, oldProps), newProps);
	  },
	
	  /**
	   * @lends {ReactPropTransferer.prototype}
	   */
	  Mixin: {
	
	    /**
	     * Transfer props from this component to a target component.
	     *
	     * Props that do not have an explicit transfer strategy will be transferred
	     * only if the target component does not already have the prop set.
	     *
	     * This is usually used to pass down props to a returned root component.
	     *
	     * @param {ReactElement} element Component receiving the properties.
	     * @return {ReactElement} The supplied `component`.
	     * @final
	     * @protected
	     */
	    transferPropsTo: function(element) {
	      ("production" !== process.env.NODE_ENV ? invariant(
	        element._owner === this,
	        '%s: You can\'t call transferPropsTo() on a component that you ' +
	        'don\'t own, %s. This usually means you are calling ' +
	        'transferPropsTo() on a component passed in as props or children.',
	        this.constructor.displayName,
	        typeof element.type === 'string' ?
	        element.type :
	        element.type.displayName
	      ) : invariant(element._owner === this));
	
	      if ("production" !== process.env.NODE_ENV) {
	        if (!didWarn) {
	          didWarn = true;
	          ("production" !== process.env.NODE_ENV ? warning(
	            false,
	            'transferPropsTo is deprecated. ' +
	            'See http://fb.me/react-transferpropsto for more information.'
	          ) : null);
	        }
	      }
	
	      // Because elements are immutable we have to merge into the existing
	      // props object rather than clone it.
	      transferInto(element.props, this.props);
	
	      return element;
	    }
	
	  }
	};
	
	module.exports = ReactPropTransferer;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(59)))

/***/ },

/***/ 62:
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copyright 2013-2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule keyOf
	 */
	
	/**
	 * Allows extraction of a minified key. Let's the build system minify keys
	 * without loosing the ability to dynamically use key strings as values
	 * themselves. Pass in an object with a single key/val pair and it will return
	 * you the string key of that single record. Suppose you want to grab the
	 * value for a key 'className' inside of an object. Key/val minification may
	 * have aliased that key to be 'xa12'. keyOf({className: null}) will return
	 * 'xa12' in that case. Resolve keys you want to use once at startup time, then
	 * reuse those resolutions.
	 */
	var keyOf = function(oneKeyObj) {
	  var key;
	  for (key in oneKeyObj) {
	    if (!oneKeyObj.hasOwnProperty(key)) {
	      continue;
	    }
	    return key;
	  }
	  return null;
	};
	
	
	module.exports = keyOf;


/***/ },

/***/ 63:
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {/**
	 * Copyright 2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule warning
	 */
	
	"use strict";
	
	var emptyFunction = __webpack_require__(68);
	
	/**
	 * Similar to invariant but only logs a warning if the condition is not met.
	 * This can be used to log issues in development environments in critical
	 * paths. Removing the logging code for production environments will keep the
	 * same logic and follow the same code paths.
	 */
	
	var warning = emptyFunction;
	
	if ("production" !== process.env.NODE_ENV) {
	  warning = function(condition, format ) {for (var args=[],$__0=2,$__1=arguments.length;$__0<$__1;$__0++) args.push(arguments[$__0]);
	    if (format === undefined) {
	      throw new Error(
	        '`warning(condition, format, ...args)` requires a warning ' +
	        'message argument'
	      );
	    }
	
	    if (!condition) {
	      var argIndex = 0;
	      console.warn('Warning: ' + format.replace(/%s/g, function()  {return args[argIndex++];}));
	    }
	  };
	}
	
	module.exports = warning;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(59)))

/***/ },

/***/ 68:
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copyright 2013-2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule emptyFunction
	 */
	
	function makeEmptyFunction(arg) {
	  return function() {
	    return arg;
	  };
	}
	
	/**
	 * This function accepts and discards inputs; it has no side effects. This is
	 * primarily useful idiomatically for overridable function endpoints which
	 * always need to be callable, since JS lacks a null-call idiom ala Cocoa.
	 */
	function emptyFunction() {}
	
	emptyFunction.thatReturns = makeEmptyFunction;
	emptyFunction.thatReturnsFalse = makeEmptyFunction(false);
	emptyFunction.thatReturnsTrue = makeEmptyFunction(true);
	emptyFunction.thatReturnsNull = makeEmptyFunction(null);
	emptyFunction.thatReturnsThis = function() { return this; };
	emptyFunction.thatReturnsArgument = function(arg) { return arg; };
	
	module.exports = emptyFunction;


/***/ },

/***/ 127:
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copyright 2013-2014, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 *
	 * @providesModule joinClasses
	 * @typechecks static-only
	 */
	
	"use strict";
	
	/**
	 * Combines multiple className strings into one.
	 * http://jsperf.com/joinclasses-args-vs-array
	 *
	 * @param {...?string} classes
	 * @return {string}
	 */
	function joinClasses(className/*, ... */) {
	  if (!className) {
	    className = '';
	  }
	  var nextClass;
	  var argLength = arguments.length;
	  if (argLength > 1) {
	    for (var ii = 1; ii < argLength; ii++) {
	      nextClass = arguments[ii];
	      if (nextClass) {
	        className = (className ? className + ' ' : '') + nextClass;
	      }
	    }
	  }
	  return className;
	}
	
	module.exports = joinClasses;


/***/ }

/******/ });
//# sourceMappingURL=data:application/json;base64,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
