(defproject com.notbot/litmus "0.4.2-SNAPSHOT"
  :description "Testing library for Clojurescript"
  :url "http://github.com/hsalokor/litmus"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.0.0"
  :scm {:url "git@github.com/hsalokor/litmus.git"}
  :pom-addition [:developers [:developer
                              [:name "Harri Salokorpi"]
                              [:url "http://github.com/hsalokor/litmus"]
                              [:email "hsalokor@iki.fi"]
                              [:timezone "+3"]]]

  :dependencies [[org.clojure/clojure "1.5.1"]
                 [org.clojure/clojurescript "0.0-1909"]
                 [jayq "2.4.0"]
                 [com.jquery/jquery "1.9.1"]
                 [com.notbot/chai "1.9.2-1-SNAPSHOT"]
                 [com.notbot/mocha "1.12.0-1-SNAPSHOT"]
                 [com.notbot/smoax "0.2.1-1-SNAPSHOT"]]
  :plugins [[lein-cljsbuild "0.3.3"]]
  :hooks [leiningen.cljsbuild]
  :cljsbuild {:test-commands {"unit" ["mocha-phantomjs" "resources/test.html"]}
              :builds {:dev {:source-paths ["src/cljs"]
                             :compiler {:output-to "target/litmus.js"
                                        :optimizations :whitespace
                                        :externs ["src/cljs/externs/mocha.js"
                                                  "src/cljs/externs/chai.js"
                                                  "src/cljs/externs/jquery-1.9.js"]
                                        :pretty-print true}}
                       :prod {:source-paths ["src/cljs"]
			      :jar true
                              :compiler {:output-to "target/litmus.js"
                                         :optimizations :advanced
                                         :pretty-print true}}

                       :test {:source-paths ["src/cljs"
                                             "test/cljs/"]
                              :compiler {:output-to "target/tests.js"
                                         ;:optimizations :whitespace
                                         :pretty-print true}}}})
