(ns crimson.cluster
  (:require [clojure.spec.alpha :as s]
            [crimson.spec :as spec]
            [crimson.pool :as pool])
  (:import (redis.clients.jedis HostAndPort JedisCluster)))

(defn- host-and-port
  ^HostAndPort
  [{:keys [host port] :as params}]
  (HostAndPort. host port))

(defn init
  "Creates a new redis cluster and returns `JedisCluster` instance.

  Accepts:
    - nodes:              A set of maps with :host and :port
    - connection-timeout: connection timeout in  milliseconds
    - socket-timeout:     socket timeout in milliseconds
    - max-attempts:       maximum number of redirects for running a command in redis cluster
    - pool-config:        pool config for redis cluster"
  ^JedisCluster
  [{:keys [nodes
           connection-timeout
           socket-timeout
           max-attempts
           pool-config] :as params}]
  (if (false? (s/valid? ::spec/cluster-options params))
    (s/explain-data ::spec/cluster-options params)
    (JedisCluster. (set (map host-and-port nodes))
                   connection-timeout
                   socket-timeout
                   max-attempts
                   (pool/pool-config pool-config))))