;; Copyright 2016 Neumitra, Inc.

;; Licensed under the Apache License, Version 2.0 (the "License");
;; you may not use this file except in compliance with the License.
;; You may obtain a copy of the License at

;; http://www.apache.org/licenses/LICENSE-2.0

;; Unless required by applicable law or agreed to in writing, software
;; distributed under the License is distributed on an "AS IS" BASIS,
;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;; See the License for the specific language governing permissions and
;; limitations under the License.

(ns thrifty.parser.util
  "Hiccup-traversal utilities used by the parser via `specter'."
  (:require [com.rpl.specter :refer [walker select]]))

(defn match-hiccup
  "Match `[<tag> ...]'"
  [^clojure.lang.Keyword tag]
  (fn [v] (and (vector? v) (= (first v) tag))))

(defn find-tags
  "Find `[<tag> ...]' within `form' at any depth."
  [tag form]
  (select (walker (match-hiccup tag)) form))

(defn find-tag
  "Find the first `[<tag> ...]' within `form' at any depth."
  [tag form]
  (first (find-tags tag form)))

(defn find-next-tags
  "Find the next sibling `[<tag> ...]' within `form'."
  [tag form]
  (let [matcher (match-hiccup tag)]
    (filter matcher form)))

(defn find-next-tag
  "Find the first sibling `[<tag> ...]' within `form'."
  [tag form]
  (first (find-next-tags tag form)))

(defn find-identifier
  "Find first sibling `[:identifier ...]'; defines `name' field."
  [form]
  (second (find-next-tag :identifier form)))
