(ns nedap.lacinia.pedestal.multipart.impl.test)

(defn map->paths
  "returns all paths for given map. Paths can be used with #'clojure.core/get-in"
  [m]
  (letfn [(children [node]
            (let [v (get-in m node)]
              (cond
                (map? v)    (map (partial conj node) (keys v))
                (vector? v) (map (partial conj node) (range (count v)))
                :else [])))
          (branch? [node] (-> (children node) seq boolean))]
    (->> (keys m)
         (map vector)
         (mapcat #(tree-seq branch? children %)))))
