# lacinia-pedestal-multipart

<!-- (In short: What does the project do?) -->

Extension to [lacinia](https://github.com/walmartlabs/lacinia) & [lacinia-pedestal](https://github.com/walmartlabs/lacinia-pedestal) to implements the [graphql-multipart-request-spec](https://github.com/jaydenseric/graphql-multipart-request-spec).

## Installation

```clojure
[com.nedap.staffing-solutions/lacinia-pedestal-multipart "0.1.0-alpha1"]
```

## Synopsis

To support file uploads, there are two modifications to be made to a standard Lacinia setup.

1. Attach an `Upload` scalar to the schema using `nedap.lacinia.upload.util/attach-upload-scalar`:

```clojure
(require '[clojure.edn :as edn]
         '[clojure.java.io :as io]
         '[com.walmartlabs.lacinia.schema :as schema]
         '[nedap.lacinia.upload.util :as upload.util])

(defn schema
  []
  (-> (io/resource "schema.edn")
      slurp
      edn/read-string
      ...
      upload.util/attach-upload-scalar
      ...
      schema/compile))
```

2. Replace the default `body-data-interceptor` with `nedap.lacinia.pedestal.multipart/body-data-interceptor`, for example using lacinia.pedestal's `inject`:

```clojure
(require '[com.walmartlabs.lacinia.pedestal :refer [service-map inject] :as lp]
         '[io.pedestal.http :as http]
         '[io.pedestal.http.route :as route]
         '[nedap.lacinia.pedestal.multipart :refer [body-data-interceptor]])

(defn update-routes
  [routes]
  (map (fn [{:keys [method] :as route}]
         (if (= :post method)
           (update route :interceptors inject (body-data-interceptor) :replace ::lp/body-data)
           route))
       (route/expand-routes routes)))

(def service
  (-> (schema)
      (service-map {})
      (update ::http/routes update-routes)
      (http/create-server)
      (http/start)))
```

Your Lacinia server now accepts multipart GraphQL requests with file uploads. Files referenced in variables are represented as maps:

```clojure
{:filename "hello.txt"
 :mimetype "text/plain"
 :stream   #object[java.io.BufferedInputStream ...]
 :encoding "utf-8"}
```

## ns organisation

There are two public namespaces:

1. `nedap.lacinia.upload.util` for all schema related additions to Lacinia.
2. `nedap.lacinia.pedestal.multipart` for all Pedestal related additions to `lacinia-pedestal`. This namespace extends one of `lacinia.pedestal`'s multimethods.

## Limitations

Lacinia does not support batched requests (see also: walmartlabs/lacinia#48), this library therefore also not support multipart requests with batched queries.

## License

Copyright © Nedap

This program and the accompanying materials are made available under the terms of the [Eclipse Public License 2.0](https://www.eclipse.org/legal/epl-2.0).
