# Eastwood - temp fork

## Offering

Tweaking Eastwood in such a way that it can be run repeatedly within a regular development project, without incurring into code reloading issues (clojure.lang.Namepace errors) or cleanliness issues (extraneous aliases being introduced into the current namespace).

## Caveats

Any `defmacro` bodies subject to Eastwood analysis (i.e. those in your project, as per [formatting-stack](https://github.com/nedap/formatting-stack), and **not** macros from clojure.core, libs, etc) must not be implemented in terms of `refer`ed variables, or specific namespace aliases:

```diff
(ns foo
  (:require [clojure.string :as string]))

(def thing 42)

(defmacro example
- [thing string/blank?])
+ [foo/thing clojure.string/blank?])
```

For some reason, macros seem to only have access to the `dev`/`user` ns environment, so variables/aliases cannot be assumed.

Probably an issue in Eastwood or tools.analyzer.

## Roadmap

* Try this fork for a while
* Eventually propose a PR to Eastwood upstream.

## Installation

```clojure
[com.nedap.staffing-solutions/eastwood "0.3.7-alpha5"]
```

## License

Copyright (C) 2012-2015 Jonas Enlund, Nicola Mometto, and Andy Fingerhut

Distributed under the Eclipse Public License, the same as Clojure.

The source code of the following libraries has been copied into
Eastwood's source code, and each of their copyright and license info
is given below.  They are all distributed under the Eclipse Public
License 1.0.

### core.cache

[core.cache](https://github.com/clojure/core.cache)

Copyright (c) Rich Hickey, Michael Fogus and contributors, 2012. All rights reserved.  The use and distribution terms for this software are covered by the Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php) which can be found in the file epl-v10.html at the root of this distribution. By using this software in any fashion, you are agreeing to be bound by the terms of this license.  You must not remove this notice, or any other, from this software.

### core.contracts

[core.contracts](https://github.com/clojure/core.contracts)

Copyright (c) Rich Hickey, Michael Fogus and contributors, 2012. All rights reserved.  The use and distribution terms for this software are covered by the Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php) which can be found in the file epl-v10.html at the root of this distribution. By using this software in any fashion, you are agreeing to be bound by the terms of this license.  You must not remove this notice, or any other, from this software.

### core.memoize

[core.memoize](https://github.com/clojure/core.memoize)

Copyright (c) Rich Hickey and Michael Fogus, 2012, 2013. All rights reserved.  The use and distribution terms for this software are covered by the Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php) which can be found in the file epl-v10.html at the root of this distribution. By using this software in any fashion, you are agreeing to be bound by the terms of this license.  You must not remove this notice, or any other, from this software.

### core.unify

[core.unify](https://github.com/clojure/core.unify)

Copyright © 2011 Rich Hickey

Licensed under the EPL. (See the file epl.html.)

### data.priority-map

Copyright (C) 2013 Mark Engelberg

Distributed under the Eclipse Public License, the same as Clojure.

[data.priority-map](https://github.com/clojure/data.priority-map)

### leinjacker

[leinjacker](https://github.com/sattvik/leinjacker)

Copyright © 2012 Sattvik Software & Technology Resources, Ltd. Co.
All rights reserved.

Distributed under the Eclipse Public License, the same as Clojure.

### tools.analyzer

[tools.analyzer](https://github.com/clojure/tools.analyzer)

Copyright © 2013-2014 Nicola Mometto, Rich Hickey & contributors.

Distributed under the Eclipse Public License, the same as Clojure.

### tools.analyzer.jvm

[tools.analyzer.jvm](https://github.com/clojure/tools.analyzer.jvm)

Copyright © 2013-2014 Nicola Mometto, Rich Hickey & contributors.

Distributed under the Eclipse Public License, the same as Clojure.

### tools.namespace

[tools.namespace](https://github.com/clojure/tools.namespace)

Copyright © 2012 Stuart Sierra All rights reserved. The use and
distribution terms for this software are covered by the
[Eclipse Public License 1.0] which can be found in the file
epl-v10.html at the root of this distribution. By using this software
in any fashion, you are agreeing to be bound by the terms of this
license. You must not remove this notice, or any other, from this
software.

[Eclipse Public License 1.0]: http://opensource.org/licenses/eclipse-1.0.php

### tools.reader

[tools.reader](https://github.com/clojure/tools.reader)

Copyright © 2013-2014 Nicola Mometto, Rich Hickey & contributors.

Licensed under the EPL. (See the file epl.html.)
