(ns reframe-attrs.core)

;; Macros are created on the clojure side, but the functions generated
;; in the build-events-and-subscriptions macro need to be available
;; in clojurescript.
;;
;; It might make sense to define these inside the initial let expression
;; of build-events-and-subscriptions, as there wouldn't be a need for
;; requiring both the macro and this file ...

(defn all-path-forrr
  ([persistance plural-name id]
   [persistance plural-name :all id])
  ([persistance plural-name id fld]
   [persistance plural-name :all id fld])
  )

(defn update-recencyyyy
  [id s]
  (if (and s (= id (first s)))
    s
    (conj
      (if (nil? s)
        '()
        (remove #(= % id) s))
      id)))
