(ns mishmash.json-api)




(defn make-schema
  [{:keys [:type :defs :attrs]}]
  (atom {:type type :defs defs :attrs attrs}))

;; want

{:type "test"
 :attrs [{:name :id :seq 0 :type Integer :descript "id for test" :validations [] :reader nil}
         {:name :a :seq 0 :type Integer :descript "hello world" :validations [] :reader nil}
         ;; ...
         ]
 :attr-hash {:a {:name :a :seq 0 ;; ...
                 }}
 :id-index 0}




(defn vec-remove
    "remove elem in coll"
  [coll pos]
  (vec (concat (subvec coll 0 pos) (subvec coll (inc pos)))))

(defn find-id-index
  [schema]
  0
  )

(defn- json-api-sequential
  [{:keys [:schema :data]}]
  (let [id-index (find-id-index schema)
        id (nth data id-index)
        ;; attrs (reduce #(if (= :id %2) %1 (conj %2 ())))
        attrs {:a 1 :b {:x 17 :y 43}}
        ]
    {:data
     {:type (:type @schema)
      :id id
      :attributes attrs
      }}))

(defn- json-api-map
  [{:keys [:schema :data]}]
  {:data
   {:type (:type @schema)
    :id (:id data)
    :attributes (dissoc data :id)}}
  )

(defn- json-api-one
  [json]
  (let [data (:data json)]
    (cond
      (sequential? data) (json-api-sequential json)
      (map? data) (json-api-map json)
      :else (throw "unknown data type")))
  )

(defn ->json-api
  ([main] (->json-api main nil))
  ([main rest]
   (json-api-one main)
   ))


;; (->json-api {:schema [] :data [1 2]}
;;             [{:schema [] :data [[9 2] [9 3] [9 4]]}
;;              ]
;;             )

;; (->json-api {:schema [] :data [[1 2] [2 3] [3 4]]}
;;             [{:schema [] :data [[9 2] [9 3] [9 4]]}
;;              ]
;;             )
