(ns clj-common.threadpool)

(import java.util.concurrent.ExecutorService)
(import java.util.concurrent.Executors)
(import java.util.concurrent.TimeUnit)

(defn create-fixed-executor [threads-number]
  (Executors/newFixedThreadPool threads-number))

(defn wait-and-terminate [pool]
  (.shutdown pool)
  (.awaitTermination pool 60 TimeUnit/MINUTES))

(defn execute-async [pool fn-to-execute]
  (.submit
      ^ExecutorService pool
      ^Callable (fn []
                  (try
                    (fn-to-execute)
                    (catch Throwable e (.printStackTrace e))))))
