(ns clj-aws.kinesis
  (:require
    [amazonica.aws.kinesis :as kinesis]
    [clojure.core.async :as async]
    [clj-common.logging :as logging]
    [clj-common.json :as json]
    [clj-common.io :as io]
    [clj-common.jvm :as jvm]
    clj-common.async))

(def ^:dynamic *channel-size* 1000)


(def test (async/chan 1))

(clojure.core.async.impl.protocols/closed? test)

(async/close! test)

(clj-common.async/closed? test)

(defn create-async-delivery
  "Creates async delivery to Kinesis stream. Returns fn with two arities, when
  called with arrity zero, delivery stream will be closed. Arity one will deliver
  message. Message should be map {:partition ^String :body ^Map}"
  [stream]
  (let [channel (async/chan *channel-size*)]
    (async/go
      (loop []
        (if-let [{partition :partition message :body} (async/<! channel)]
          (do
            (kinesis/put-record
              stream
              (io/string->byte-buffer
                (str (json/write-to-string message) "\n"))
              partition)
            (recur))
          (logging/report "channel closed, stopping"))))
    (fn
      ([] (async/close! channel))
      ([message] (async/>!! channel message)))))

(kinesis/worker!
  :app "test-worker"
  :stream "vindb-http-requests"
  :checkpoint false ;; default to disabled checkpointing, can still force
  ;; a checkpoint by returning true from the processor function
  :processor (fn [records]
               (doseq [row records]
                 (println (:data row)
                          (:sequence-number row)
                          (:partition-key row)))))



