// Compiled by ClojureScript 1.8.40 {}
goog.provide('taoensso.sente');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('taoensso.sente.interfaces');
goog.require('cljs.core.async');
goog.require('taoensso.encore');
goog.require('clojure.string');
if(cljs.core.vector_QMARK_.call(null,taoensso.encore.encore_version)){
taoensso.encore.assert_min_encore_version.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(11),(0)], null));
} else {
taoensso.encore.assert_min_encore_version.call(null,2.11);
}
taoensso.sente.validate_event = (function taoensso$sente$validate_event(x){
if(!(cljs.core.vector_QMARK_.call(null,x))){
return new cljs.core.Keyword(null,"wrong-type","wrong-type",929556915);
} else {
if(cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(1),null,(2),null], null), null).call(null,cljs.core.count.call(null,x)))){
return new cljs.core.Keyword(null,"wrong-length","wrong-length",1367572281);
} else {
var vec__21977 = x;
var ev_id = cljs.core.nth.call(null,vec__21977,(0),null);
var _ = cljs.core.nth.call(null,vec__21977,(1),null);
if(!((ev_id instanceof cljs.core.Keyword))){
return new cljs.core.Keyword(null,"wrong-id-type","wrong-id-type",-1213601689);
} else {
if(cljs.core.not.call(null,cljs.core.namespace.call(null,ev_id))){
return new cljs.core.Keyword(null,"unnamespaced-id","unnamespaced-id",1976189772);
} else {
return null;

}
}

}
}
});
/**
 * Valid [ev-id ?ev-data] form?
 */
taoensso.sente.event_QMARK_ = (function taoensso$sente$event_QMARK_(x){
return (taoensso.sente.validate_event.call(null,x) == null);
});
taoensso.sente.as_event = (function taoensso$sente$as_event(x){
if(cljs.core.truth_(taoensso.sente.event_QMARK_.call(null,x))){
return x;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-event","chsk/bad-event",-565206930),x], null);
}
});
taoensso.sente.assert_event = (function taoensso$sente$assert_event(x){
var temp__4657__auto__ = taoensso.sente.validate_event.call(null,x);
if(cljs.core.truth_(temp__4657__auto__)){
var _QMARK_err = temp__4657__auto__;
var err_fmt = [cljs.core.str((function (){var G__21979 = (((_QMARK_err instanceof cljs.core.Keyword))?_QMARK_err.fqn:null);
switch (G__21979) {
case "wrong-type":
return "Malformed event (wrong type).";

break;
case "wrong-length":
return "Malformed event (wrong length).";

break;
case "wrong-id-type":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "unnamespaced-id":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "else":
return "Malformed event (unknown error).";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(_QMARK_err)].join('')));

}
})()),cljs.core.str(" Event should be of `[ev-id ?ev-data]` form: %s")].join('');
throw cljs.core.ex_info.call(null,taoensso.encore.format.call(null,err_fmt,[cljs.core.str(x)].join('')),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"malformed-event","malformed-event",-2090896605),x], null));
} else {
return null;
}
});
taoensso.sente.client_event_msg_QMARK_ = (function taoensso$sente$client_event_msg_QMARK_(x){
var and__6195__auto__ = cljs.core.map_QMARK_.call(null,x);
if(and__6195__auto__){
var and__6195__auto____$1 = taoensso.encore.keys_EQ_.call(null,x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null));
if(cljs.core.truth_(and__6195__auto____$1)){
var map__21983 = x;
var map__21983__$1 = ((((!((map__21983 == null)))?((((map__21983.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21983.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21983):map__21983);
var ch_recv = cljs.core.get.call(null,map__21983__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__21983__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__21983__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__21983__$1,new cljs.core.Keyword(null,"event","event",301435442));
var and__6195__auto____$2 = taoensso.encore.chan_QMARK_.call(null,ch_recv);
if(cljs.core.truth_(and__6195__auto____$2)){
var and__6195__auto____$3 = cljs.core.ifn_QMARK_.call(null,send_fn);
if(and__6195__auto____$3){
var and__6195__auto____$4 = taoensso.encore.atom_QMARK_.call(null,state);
if(cljs.core.truth_(and__6195__auto____$4)){
return taoensso.sente.event_QMARK_.call(null,event);
} else {
return and__6195__auto____$4;
}
} else {
return and__6195__auto____$3;
}
} else {
return and__6195__auto____$2;
}
} else {
return and__6195__auto____$1;
}
} else {
return and__6195__auto__;
}
});
taoensso.sente.server_event_msg_QMARK_ = (function taoensso$sente$server_event_msg_QMARK_(x){
var and__6195__auto__ = cljs.core.map_QMARK_.call(null,x);
if(and__6195__auto__){
var and__6195__auto____$1 = taoensso.encore.keys_EQ_.call(null,x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),null,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),null,new cljs.core.Keyword(null,"uid","uid",-1447769400),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null));
if(cljs.core.truth_(and__6195__auto____$1)){
var map__21987 = x;
var map__21987__$1 = ((((!((map__21987 == null)))?((((map__21987.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21987.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21987):map__21987);
var ch_recv = cljs.core.get.call(null,map__21987__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__21987__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var connected_uids = cljs.core.get.call(null,map__21987__$1,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231));
var ring_req = cljs.core.get.call(null,map__21987__$1,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961));
var client_id = cljs.core.get.call(null,map__21987__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var event = cljs.core.get.call(null,map__21987__$1,new cljs.core.Keyword(null,"event","event",301435442));
var _QMARK_reply_fn = cljs.core.get.call(null,map__21987__$1,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592));
var and__6195__auto____$2 = taoensso.encore.chan_QMARK_.call(null,ch_recv);
if(cljs.core.truth_(and__6195__auto____$2)){
var and__6195__auto____$3 = cljs.core.ifn_QMARK_.call(null,send_fn);
if(and__6195__auto____$3){
var and__6195__auto____$4 = taoensso.encore.atom_QMARK_.call(null,connected_uids);
if(cljs.core.truth_(and__6195__auto____$4)){
var and__6195__auto____$5 = cljs.core.map_QMARK_.call(null,ring_req);
if(and__6195__auto____$5){
var and__6195__auto____$6 = taoensso.encore.nblank_str_QMARK_.call(null,client_id);
if(cljs.core.truth_(and__6195__auto____$6)){
var and__6195__auto____$7 = taoensso.sente.event_QMARK_.call(null,event);
if(cljs.core.truth_(and__6195__auto____$7)){
return ((_QMARK_reply_fn == null)) || (cljs.core.ifn_QMARK_.call(null,_QMARK_reply_fn));
} else {
return and__6195__auto____$7;
}
} else {
return and__6195__auto____$6;
}
} else {
return and__6195__auto____$5;
}
} else {
return and__6195__auto____$4;
}
} else {
return and__6195__auto____$3;
}
} else {
return and__6195__auto____$2;
}
} else {
return and__6195__auto____$1;
}
} else {
return and__6195__auto__;
}
});
/**
 * All server `event-msg`s go through this
 */
taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_ = (function taoensso$sente$put_server_event_msg_GT_ch_recv_BANG_(ch_recv,p__21989){
var map__21993 = p__21989;
var map__21993__$1 = ((((!((map__21993 == null)))?((((map__21993.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21993.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21993):map__21993);
var ev_msg = map__21993__$1;
var event = cljs.core.get.call(null,map__21993__$1,new cljs.core.Keyword(null,"event","event",301435442));
var _QMARK_reply_fn = cljs.core.get.call(null,map__21993__$1,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592));
var vec__21995 = taoensso.sente.as_event.call(null,event);
var ev_id = cljs.core.nth.call(null,vec__21995,(0),null);
var ev__QMARK_data = cljs.core.nth.call(null,vec__21995,(1),null);
var valid_event = vec__21995;
var ev_msg_STAR_ = cljs.core.merge.call(null,ev_msg,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"event","event",301435442),valid_event,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),_QMARK_reply_fn,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null));
if(cljs.core.not.call(null,taoensso.sente.server_event_msg_QMARK_.call(null,ev_msg_STAR_))){
return taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",159,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__21995,ev_id,ev__QMARK_data,valid_event,ev_msg_STAR_,map__21993,map__21993__$1,ev_msg,event,_QMARK_reply_fn){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad ev-msg: %s",ev_msg], null);
});})(vec__21995,ev_id,ev__QMARK_data,valid_event,ev_msg_STAR_,map__21993,map__21993__$1,ev_msg,event,_QMARK_reply_fn))
,null)),null);
} else {
return cljs.core.async.put_BANG_.call(null,ch_recv,ev_msg_STAR_);
}
});
taoensso.sente.cb_error_QMARK_ = (function taoensso$sente$cb_error_QMARK_(cb_reply_clj){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264),null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439),null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489),null], null), null).call(null,cb_reply_clj);
});
taoensso.sente.cb_success_QMARK_ = (function taoensso$sente$cb_success_QMARK_(cb_reply_clj){
return cljs.core.not.call(null,taoensso.sente.cb_error_QMARK_.call(null,cb_reply_clj));
});
/**
 * pstr->clj
 */
taoensso.sente.unpack_STAR_ = (function taoensso$sente$unpack_STAR_(packer,pstr){
try{return taoensso.sente.interfaces.unpack.call(null,packer,(function (){var __x = pstr;
try{if(typeof __x === 'string'){
return __x;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e21999){if((e21999 instanceof Error)){
var __t = e21999;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(string? pstr)",__x,__t,null);
} else {
throw e21999;

}
}})());
}catch (e21998){var t = e21998;
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",175,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (t){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad package: %s (%s)",pstr,t], null);
});})(t))
,null)),null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-package","chsk/bad-package",501893679),pstr], null);
}});
taoensso.sente.with__QMARK_meta = (function taoensso$sente$with__QMARK_meta(x,_QMARK_m){
if(cljs.core.seq.call(null,_QMARK_m)){
return cljs.core.with_meta.call(null,x,_QMARK_m);
} else {
return x;
}
});
/**
 * clj->prefixed-pstr
 */
taoensso.sente.pack_STAR_ = (function taoensso$sente$pack_STAR_(var_args){
var args22000 = [];
var len__7276__auto___22003 = arguments.length;
var i__7277__auto___22004 = (0);
while(true){
if((i__7277__auto___22004 < len__7276__auto___22003)){
args22000.push((arguments[i__7277__auto___22004]));

var G__22005 = (i__7277__auto___22004 + (1));
i__7277__auto___22004 = G__22005;
continue;
} else {
}
break;
}

var G__22002 = args22000.length;
switch (G__22002) {
case 3:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22000.length)].join('')));

}
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (packer,_QMARK_packer_meta,clj){
return [cljs.core.str("-"),cljs.core.str(taoensso.sente.interfaces.pack.call(null,packer,taoensso.sente.with__QMARK_meta.call(null,clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (packer,_QMARK_packer_meta,clj,_QMARK_cb_uuid){
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.call(null,_QMARK_cb_uuid,new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321)))?(0):_QMARK_cb_uuid);
var wrapped_clj = (cljs.core.truth_(_QMARK_cb_uuid__$1)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,_QMARK_cb_uuid__$1], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj], null));
return [cljs.core.str("+"),cljs.core.str(taoensso.sente.interfaces.pack.call(null,packer,taoensso.sente.with__QMARK_meta.call(null,wrapped_clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$lang$maxFixedArity = 4;
taoensso.sente.pack = (function taoensso$sente$pack(var_args){
var args__7283__auto__ = [];
var len__7276__auto___22008 = arguments.length;
var i__7277__auto___22009 = (0);
while(true){
if((i__7277__auto___22009 < len__7276__auto___22008)){
args__7283__auto__.push((arguments[i__7277__auto___22009]));

var G__22010 = (i__7277__auto___22009 + (1));
i__7277__auto___22009 = G__22010;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((0) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((0)),(0),null)):null);
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(argseq__7284__auto__);
});

taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var pstr = cljs.core.apply.call(null,taoensso.sente.pack_STAR_,args);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",193,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (pstr){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Packing: %s -> %s",args,pstr], null);
});})(pstr))
,null)),null);

return pstr;
});

taoensso.sente.pack.cljs$lang$maxFixedArity = (0);

taoensso.sente.pack.cljs$lang$applyTo = (function (seq22007){
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22007));
});
/**
 * prefixed-pstr->[clj ?cb-uuid]
 */
taoensso.sente.unpack = (function taoensso$sente$unpack(packer,prefixed_pstr){
var __x_22017 = prefixed_pstr;
try{if(typeof __x_22017 === 'string'){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22014){if((e22014 instanceof Error)){
var __t_22018 = e22014;
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(string? prefixed-pstr)",__x_22017,__t_22018,null);
} else {
throw e22014;

}
}
var prefix = taoensso.encore.substr.call(null,prefixed_pstr,(0),(1));
var pstr = taoensso.encore.substr.call(null,prefixed_pstr,(1));
var clj = taoensso.sente.unpack_STAR_.call(null,packer,pstr);
var wrapped_QMARK_ = (function (){var G__22016 = prefix;
switch (G__22016) {
case "-":
return false;

break;
case "+":
return true;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(prefix)].join('')));

}
})();
var vec__22015 = (cljs.core.truth_(wrapped_QMARK_)?clj:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,null], null));
var clj__$1 = cljs.core.nth.call(null,vec__22015,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__22015,(1),null);
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.call(null,(0),_QMARK_cb_uuid))?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):_QMARK_cb_uuid);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",205,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (prefix,pstr,clj,wrapped_QMARK_,vec__22015,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unpacking: %s -> %s",prefixed_pstr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null)], null);
});})(prefix,pstr,clj,wrapped_QMARK_,vec__22015,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1))
,null)),null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null);
});

/**
 * Takes a web server adapter[1] and returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *  :send-fn ; (fn [user-id ev] for server>user push.
 *  :ajax-post-fn                ; (fn [ring-req]) for Ring CSRF-POST + chsk URL.
 *  :ajax-get-or-ws-handshake-fn ; (fn [ring-req]) for Ring GET + chsk URL.
 *  :connected-uids ; Watchable, read-only (atom {:ws #{_} :ajax #{_} :any #{_}}).
 * 
 *   Common options:
 *  :user-id-fn        ; (fn [ring-req]) -> unique user-id for server>user push.
 *  :csrf-token-fn     ; (fn [ring-req]) -> CSRF token for Ajax POSTs.
 *  :handshake-data-fn ; (fn [ring-req]) -> arb user data to append to handshake evs.
 *  :send-buf-ms-ajax  ; [2]
 *  :send-buf-ms-ws    ; [2]
 *  :packer            ; :edn (default), or an IPacker implementation (experimental).
 * 
 *   [1] e.g. `taoensso.sente.server-adapters.http-kit/http-kit-adapter` or
 *         `taoensso.sente.server-adapters.immutant/immutant-adapter`.
 *    You must have the necessary web-server dependency in your project.clj and
 *    the necessary entry in your namespace's `ns` form.
 * 
 *   [2] Optimization to allow transparent batching of rapidly-triggered
 *    server>user pushes. This is esp. important for Ajax clients which use a
 *    (slow) reconnecting poller. Actual event dispatch may occur <= given ms
 *    after send call (larger values => larger batch windows).
 */
taoensso.sente.make_channel_socket_server_BANG_ = (function taoensso$sente$make_channel_socket_server_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___22189 = arguments.length;
var i__7277__auto___22190 = (0);
while(true){
if((i__7277__auto___22190 < len__7276__auto___22189)){
args__7283__auto__.push((arguments[i__7277__auto___22190]));

var G__22191 = (i__7277__auto___22190 + (1));
i__7277__auto___22190 = G__22191;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((1) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((1)),(0),null)):null);
return taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7284__auto__);
});

taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (web_server_adapter,p__22023){
var vec__22024 = p__22023;
var map__22025 = cljs.core.nth.call(null,vec__22024,(0),null);
var map__22025__$1 = ((((!((map__22025 == null)))?((((map__22025.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22025.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22025):map__22025);
var recv_buf_or_n = cljs.core.get.call(null,map__22025__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer.call(null,(1000)));
var send_buf_ms_ajax = cljs.core.get.call(null,map__22025__$1,new cljs.core.Keyword(null,"send-buf-ms-ajax","send-buf-ms-ajax",1546129037),(100));
var send_buf_ms_ws = cljs.core.get.call(null,map__22025__$1,new cljs.core.Keyword(null,"send-buf-ms-ws","send-buf-ms-ws",-1149586238),(30));
var user_id_fn = cljs.core.get.call(null,map__22025__$1,new cljs.core.Keyword(null,"user-id-fn","user-id-fn",-1532150029),((function (vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws){
return (function (ring_req){
return cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"uid","uid",-1447769400)], null));
});})(vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws))
);
var csrf_token_fn = cljs.core.get.call(null,map__22025__$1,new cljs.core.Keyword(null,"csrf-token-fn","csrf-token-fn",-1846298394),((function (vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn){
return (function (ring_req){
var or__6207__auto__ = cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856)], null));
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
var or__6207__auto____$1 = cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword("ring.middleware.anti-forgery","anti-forgery-token","ring.middleware.anti-forgery/anti-forgery-token",571563484)], null));
if(cljs.core.truth_(or__6207__auto____$1)){
return or__6207__auto____$1;
} else {
return cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),"__anti-forgery-token"], null));
}
}
});})(vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn))
);
var handshake_data_fn = cljs.core.get.call(null,map__22025__$1,new cljs.core.Keyword(null,"handshake-data-fn","handshake-data-fn",2011983089),((function (vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn){
return (function (ring_req){
return null;
});})(vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn))
);
var packer = cljs.core.get.call(null,map__22025__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
if(cljs.core.truth_(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var __x = send_buf_ms_ajax;
try{if(cljs.core.truth_(taoensso.encore.pos_int_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22027){if((e22027 instanceof Error)){
var __t = e22027;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(enc/pos-int? send-buf-ms-ajax)",__x,__t,null);
} else {
throw e22027;

}
}})(),(function (){var __x = send_buf_ms_ws;
try{if(cljs.core.truth_(taoensso.encore.pos_int_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22028){if((e22028 instanceof Error)){
var __t = e22028;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(enc/pos-int? send-buf-ms-ws)",__x,__t,null);
} else {
throw e22028;

}
}})()], null))){
} else {
throw (new Error("Assert failed: (have? enc/pos-int? send-buf-ms-ajax send-buf-ms-ws)"));
}

if(cljs.core.truth_((function (){var __x = web_server_adapter;
try{if(((function (__x,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p1__22020_SHARP_){
if(!((p1__22020_SHARP_ == null))){
if((false) || (p1__22020_SHARP_.taoensso$sente$interfaces$IServerChanAdapter$)){
return true;
} else {
if((!p1__22020_SHARP_.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,taoensso.sente.interfaces.IServerChanAdapter,p1__22020_SHARP_);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,taoensso.sente.interfaces.IServerChanAdapter,p1__22020_SHARP_);
}
});})(__x,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
.call(null,__x)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22029){if((e22029 instanceof Error)){
var __t = e22029;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"((fn* [p1__22020#] (satisfies? interfaces/IServerChanAdapter p1__22020#)) web-server-adapter)",__x,__t,null);
} else {
throw e22029;

}
}})())){
} else {
throw (new Error("Assert failed: (have? (fn* [p1__22020#] (satisfies? interfaces/IServerChanAdapter p1__22020#)) web-server-adapter)"));
}

var packer__$1 = taoensso.sente.interfaces.coerce_packer.call(null,packer);
var ch_recv = cljs.core.async.chan.call(null,recv_buf_or_n);
var conns_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentArrayMap.EMPTY], null));
var connected_uids_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.PersistentHashSet.EMPTY], null));
var send_buffers_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentArrayMap.EMPTY], null));
var user_id_fn__$1 = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req,client_id){
var or__6207__auto__ = user_id_fn.call(null,cljs.core.assoc.call(null,ring_req,new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id));
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return new cljs.core.Keyword("taoensso.sente","nil-uid","taoensso.sente/nil-uid",-2111603486);
}
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var connect_uid_BANG_ = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (type,uid){
if(cljs.core.truth_((function (){var __x = uid;
try{if(cljs.core.truth_(taoensso.truss.impl.nnil_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22031){if((e22031 instanceof Error)){
var __t = e22031;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(taoensso.truss.impl/nnil? uid)",__x,__t,null);
} else {
throw e22031;

}
}})())){
} else {
throw (new Error("Assert failed: (have? uid)"));
}

var newly_connected_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,connected_uids_,cljs.core.PersistentVector.EMPTY,((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__22032){
var map__22033 = p__22032;
var map__22033__$1 = ((((!((map__22033 == null)))?((((map__22033.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22033.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22033):map__22033);
var old_m = map__22033__$1;
var ws = cljs.core.get.call(null,map__22033__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
var ajax = cljs.core.get.call(null,map__22033__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var any = cljs.core.get.call(null,map__22033__$1,new cljs.core.Keyword(null,"any","any",1705907423));
var new_m = (function (){var G__22035 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__22035) {
case "ws":
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.conj.call(null,ws,uid),new cljs.core.Keyword(null,"ajax","ajax",814345549),ajax,new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.conj.call(null,any,uid)], null);

break;
case "ajax":
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),ws,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.conj.call(null,ajax,uid),new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.conj.call(null,any,uid)], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
})();
return taoensso.encore.swapped.call(null,new_m,(function (){var old_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(old_m);
var new_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(new_m);
if((!(cljs.core.contains_QMARK_.call(null,old_any,uid))) && (cljs.core.contains_QMARK_.call(null,new_any,uid))){
return new cljs.core.Keyword(null,"newly-connected","newly-connected",-2029862681);
} else {
return null;
}
})());
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
return newly_connected_QMARK_;
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var upd_connected_uid_BANG_ = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (uid){
if(cljs.core.truth_((function (){var __x = uid;
try{if(cljs.core.truth_(taoensso.truss.impl.nnil_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22036){if((e22036 instanceof Error)){
var __t = e22036;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(taoensso.truss.impl/nnil? uid)",__x,__t,null);
} else {
throw e22036;

}
}})())){
} else {
throw (new Error("Assert failed: (have? uid)"));
}

var newly_disconnected_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,connected_uids_,cljs.core.PersistentVector.EMPTY,((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__22037){
var map__22038 = p__22037;
var map__22038__$1 = ((((!((map__22038 == null)))?((((map__22038.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22038.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22038):map__22038);
var old_m = map__22038__$1;
var ws = cljs.core.get.call(null,map__22038__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
var ajax = cljs.core.get.call(null,map__22038__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var any = cljs.core.get.call(null,map__22038__$1,new cljs.core.Keyword(null,"any","any",1705907423));
var conns_SINGLEQUOTE_ = cljs.core.deref.call(null,conns_);
var any_ws_clients_QMARK_ = cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443).cljs$core$IFn$_invoke$arity$1(conns_SINGLEQUOTE_),uid);
var any_ajax_clients_QMARK_ = cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549).cljs$core$IFn$_invoke$arity$1(conns_SINGLEQUOTE_),uid);
var any_clients_QMARK_ = (any_ws_clients_QMARK_) || (any_ajax_clients_QMARK_);
var new_m = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),((any_ws_clients_QMARK_)?cljs.core.conj.call(null,ws,uid):cljs.core.disj.call(null,ws,uid)),new cljs.core.Keyword(null,"ajax","ajax",814345549),((any_ajax_clients_QMARK_)?cljs.core.conj.call(null,ajax,uid):cljs.core.disj.call(null,ajax,uid)),new cljs.core.Keyword(null,"any","any",1705907423),((any_clients_QMARK_)?cljs.core.conj.call(null,any,uid):cljs.core.disj.call(null,any,uid))], null);
return taoensso.encore.swapped.call(null,new_m,(function (){var old_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(old_m);
var new_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(new_m);
if((cljs.core.contains_QMARK_.call(null,old_any,uid)) && (!(cljs.core.contains_QMARK_.call(null,new_any,uid)))){
return new cljs.core.Keyword(null,"newly-disconnected","newly-disconnected",-1586164962);
} else {
return null;
}
})());
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
return newly_disconnected_QMARK_;
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var send_fn = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() { 
var G__22193__delegate = function (user_id,ev,p__22040){
var vec__22041 = p__22040;
var map__22042 = cljs.core.nth.call(null,vec__22041,(0),null);
var map__22042__$1 = ((((!((map__22042 == null)))?((((map__22042.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22042.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22042):map__22042);
var opts = map__22042__$1;
var flush_QMARK_ = cljs.core.get.call(null,map__22042__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var uid_22194 = ((cljs.core._EQ_.call(null,user_id,new cljs.core.Keyword("sente","all-users-without-uid","sente/all-users-without-uid",-42979578)))?new cljs.core.Keyword("taoensso.sente","nil-uid","taoensso.sente/nil-uid",-2111603486):user_id);
var __22195 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",324,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (uid_22194,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (->uid %s) %s",uid_22194,ev], null);
});})(uid_22194,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);
var __22196__$1 = (cljs.core.truth_(uid_22194)?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Support for sending to `nil` user-ids has been REMOVED. "),cljs.core.str("Please send to `:sente/all-users-without-uid` instead.")].join('')),cljs.core.str("\n"),cljs.core.str("uid")].join('')))})());
var __22197__$2 = taoensso.sente.assert_event.call(null,ev);
var ev_uuid_22198 = taoensso.encore.uuid_str.call(null);
var flush_buffer_BANG__22199 = ((function (uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (type){
var temp__4657__auto__ = taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [type], null),((function (uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (m){
var vec__22044 = cljs.core.get.call(null,m,uid_22194);
var ___$3 = cljs.core.nth.call(null,vec__22044,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__22044,(1),null);
if(cljs.core.contains_QMARK_.call(null,ev_uuids,ev_uuid_22198)){
return taoensso.encore.swapped.call(null,cljs.core.dissoc.call(null,m,uid_22194),cljs.core.get.call(null,m,uid_22194));
} else {
return taoensso.encore.swapped.call(null,m,null);
}
});})(uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
if(cljs.core.truth_(temp__4657__auto__)){
var pulled = temp__4657__auto__;
var vec__22045 = pulled;
var buffered_evs = cljs.core.nth.call(null,vec__22045,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__22045,(1),null);
var __x_22200 = buffered_evs;
try{if(cljs.core.vector_QMARK_.call(null,__x_22200)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22046){if((e22046 instanceof Error)){
var __t_22201 = e22046;
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(vector? buffered-evs)",__x_22200,__t_22201,null);
} else {
throw e22046;

}
}
var __x_22202 = ev_uuids;
try{if(cljs.core.set_QMARK_.call(null,__x_22202)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22047){if((e22047 instanceof Error)){
var __t_22203 = e22047;
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(set? ev-uuids)",__x_22202,__t_22203,null);
} else {
throw e22047;

}
}
var packer_metas = cljs.core.mapv.call(null,cljs.core.meta,buffered_evs);
var combined_packer_meta = cljs.core.reduce.call(null,cljs.core.merge,cljs.core.PersistentArrayMap.EMPTY,packer_metas);
var buffered_evs_ppstr = taoensso.sente.pack.call(null,packer__$1,combined_packer_meta,buffered_evs);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",357,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (packer_metas,combined_packer_meta,buffered_evs_ppstr,vec__22045,buffered_evs,ev_uuids,pulled,temp__4657__auto__,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["buffered-evs-ppstr: %s (with meta %s)",buffered_evs_ppstr,combined_packer_meta], null);
});})(packer_metas,combined_packer_meta,buffered_evs_ppstr,vec__22045,buffered_evs,ev_uuids,pulled,temp__4657__auto__,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

var G__22048 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__22048) {
case "ws":
return taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_.call(null,conns_,uid_22194,buffered_evs_ppstr);

break;
case "ajax":
return taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.call(null,conns_,uid_22194,buffered_evs_ppstr);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
} else {
return null;
}
});})(uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
if(cljs.core._EQ_.call(null,ev,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","close","chsk/close",1840295819)], null))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",367,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk closing (client may reconnect): %s",uid_22194], null);
});})(uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

if(cljs.core.truth_(flush_QMARK_)){
var seq__22049_22205 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"ajax","ajax",814345549)], null));
var chunk__22050_22206 = null;
var count__22051_22207 = (0);
var i__22052_22208 = (0);
while(true){
if((i__22052_22208 < count__22051_22207)){
var type_22209 = cljs.core._nth.call(null,chunk__22050_22206,i__22052_22208);
flush_buffer_BANG__22199.call(null,type_22209);

var G__22210 = seq__22049_22205;
var G__22211 = chunk__22050_22206;
var G__22212 = count__22051_22207;
var G__22213 = (i__22052_22208 + (1));
seq__22049_22205 = G__22210;
chunk__22050_22206 = G__22211;
count__22051_22207 = G__22212;
i__22052_22208 = G__22213;
continue;
} else {
var temp__4657__auto___22214 = cljs.core.seq.call(null,seq__22049_22205);
if(temp__4657__auto___22214){
var seq__22049_22215__$1 = temp__4657__auto___22214;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22049_22215__$1)){
var c__7018__auto___22216 = cljs.core.chunk_first.call(null,seq__22049_22215__$1);
var G__22217 = cljs.core.chunk_rest.call(null,seq__22049_22215__$1);
var G__22218 = c__7018__auto___22216;
var G__22219 = cljs.core.count.call(null,c__7018__auto___22216);
var G__22220 = (0);
seq__22049_22205 = G__22217;
chunk__22050_22206 = G__22218;
count__22051_22207 = G__22219;
i__22052_22208 = G__22220;
continue;
} else {
var type_22221 = cljs.core.first.call(null,seq__22049_22215__$1);
flush_buffer_BANG__22199.call(null,type_22221);

var G__22222 = cljs.core.next.call(null,seq__22049_22215__$1);
var G__22223 = null;
var G__22224 = (0);
var G__22225 = (0);
seq__22049_22205 = G__22222;
chunk__22050_22206 = G__22223;
count__22051_22207 = G__22224;
i__22052_22208 = G__22225;
continue;
}
} else {
}
}
break;
}
} else {
}

var seq__22053_22226 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid_22194], null))));
var chunk__22054_22227 = null;
var count__22055_22228 = (0);
var i__22056_22229 = (0);
while(true){
if((i__22056_22229 < count__22055_22228)){
var server_ch_22230 = cljs.core._nth.call(null,chunk__22054_22227,i__22056_22229);
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_22230);

var G__22231 = seq__22053_22226;
var G__22232 = chunk__22054_22227;
var G__22233 = count__22055_22228;
var G__22234 = (i__22056_22229 + (1));
seq__22053_22226 = G__22231;
chunk__22054_22227 = G__22232;
count__22055_22228 = G__22233;
i__22056_22229 = G__22234;
continue;
} else {
var temp__4657__auto___22235 = cljs.core.seq.call(null,seq__22053_22226);
if(temp__4657__auto___22235){
var seq__22053_22236__$1 = temp__4657__auto___22235;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22053_22236__$1)){
var c__7018__auto___22237 = cljs.core.chunk_first.call(null,seq__22053_22236__$1);
var G__22238 = cljs.core.chunk_rest.call(null,seq__22053_22236__$1);
var G__22239 = c__7018__auto___22237;
var G__22240 = cljs.core.count.call(null,c__7018__auto___22237);
var G__22241 = (0);
seq__22053_22226 = G__22238;
chunk__22054_22227 = G__22239;
count__22055_22228 = G__22240;
i__22056_22229 = G__22241;
continue;
} else {
var server_ch_22242 = cljs.core.first.call(null,seq__22053_22236__$1);
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_22242);

var G__22243 = cljs.core.next.call(null,seq__22053_22236__$1);
var G__22244 = null;
var G__22245 = (0);
var G__22246 = (0);
seq__22053_22226 = G__22243;
chunk__22054_22227 = G__22244;
count__22055_22228 = G__22245;
i__22056_22229 = G__22246;
continue;
}
} else {
}
}
break;
}

var seq__22057_22247 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid_22194], null))));
var chunk__22058_22248 = null;
var count__22059_22249 = (0);
var i__22060_22250 = (0);
while(true){
if((i__22060_22250 < count__22059_22249)){
var vec__22061_22251 = cljs.core._nth.call(null,chunk__22058_22248,i__22060_22250);
var _QMARK_server_ch_22252 = cljs.core.nth.call(null,vec__22061_22251,(0),null);
var __22253__$3 = cljs.core.nth.call(null,vec__22061_22251,(1),null);
var temp__4657__auto___22254 = _QMARK_server_ch_22252;
if(cljs.core.truth_(temp__4657__auto___22254)){
var server_ch_22255 = temp__4657__auto___22254;
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_22255);
} else {
}

var G__22256 = seq__22057_22247;
var G__22257 = chunk__22058_22248;
var G__22258 = count__22059_22249;
var G__22259 = (i__22060_22250 + (1));
seq__22057_22247 = G__22256;
chunk__22058_22248 = G__22257;
count__22059_22249 = G__22258;
i__22060_22250 = G__22259;
continue;
} else {
var temp__4657__auto___22260 = cljs.core.seq.call(null,seq__22057_22247);
if(temp__4657__auto___22260){
var seq__22057_22261__$1 = temp__4657__auto___22260;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22057_22261__$1)){
var c__7018__auto___22262 = cljs.core.chunk_first.call(null,seq__22057_22261__$1);
var G__22263 = cljs.core.chunk_rest.call(null,seq__22057_22261__$1);
var G__22264 = c__7018__auto___22262;
var G__22265 = cljs.core.count.call(null,c__7018__auto___22262);
var G__22266 = (0);
seq__22057_22247 = G__22263;
chunk__22058_22248 = G__22264;
count__22059_22249 = G__22265;
i__22060_22250 = G__22266;
continue;
} else {
var vec__22062_22267 = cljs.core.first.call(null,seq__22057_22261__$1);
var _QMARK_server_ch_22268 = cljs.core.nth.call(null,vec__22062_22267,(0),null);
var __22269__$3 = cljs.core.nth.call(null,vec__22062_22267,(1),null);
var temp__4657__auto___22270__$1 = _QMARK_server_ch_22268;
if(cljs.core.truth_(temp__4657__auto___22270__$1)){
var server_ch_22271 = temp__4657__auto___22270__$1;
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_22271);
} else {
}

var G__22272 = cljs.core.next.call(null,seq__22057_22261__$1);
var G__22273 = null;
var G__22274 = (0);
var G__22275 = (0);
seq__22057_22247 = G__22272;
chunk__22058_22248 = G__22273;
count__22059_22249 = G__22274;
i__22060_22250 = G__22275;
continue;
}
} else {
}
}
break;
}
} else {
var seq__22063_22276 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"ajax","ajax",814345549)], null));
var chunk__22064_22277 = null;
var count__22065_22278 = (0);
var i__22066_22279 = (0);
while(true){
if((i__22066_22279 < count__22065_22278)){
var type_22280 = cljs.core._nth.call(null,chunk__22064_22277,i__22066_22279);
taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_22280,uid_22194], null),((function (seq__22063_22276,chunk__22064_22277,count__22065_22278,i__22066_22279,type_22280,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
if(cljs.core.not.call(null,_QMARK_v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev], null),cljs.core.PersistentHashSet.fromArray([ev_uuid_22198], true)], null);
} else {
var vec__22067 = _QMARK_v;
var buffered_evs = cljs.core.nth.call(null,vec__22067,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__22067,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,buffered_evs,ev),cljs.core.conj.call(null,ev_uuids,ev_uuid_22198)], null);
}
});})(seq__22063_22276,chunk__22064_22277,count__22065_22278,i__22066_22279,type_22280,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var G__22281 = seq__22063_22276;
var G__22282 = chunk__22064_22277;
var G__22283 = count__22065_22278;
var G__22284 = (i__22066_22279 + (1));
seq__22063_22276 = G__22281;
chunk__22064_22277 = G__22282;
count__22065_22278 = G__22283;
i__22066_22279 = G__22284;
continue;
} else {
var temp__4657__auto___22285 = cljs.core.seq.call(null,seq__22063_22276);
if(temp__4657__auto___22285){
var seq__22063_22286__$1 = temp__4657__auto___22285;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22063_22286__$1)){
var c__7018__auto___22287 = cljs.core.chunk_first.call(null,seq__22063_22286__$1);
var G__22288 = cljs.core.chunk_rest.call(null,seq__22063_22286__$1);
var G__22289 = c__7018__auto___22287;
var G__22290 = cljs.core.count.call(null,c__7018__auto___22287);
var G__22291 = (0);
seq__22063_22276 = G__22288;
chunk__22064_22277 = G__22289;
count__22065_22278 = G__22290;
i__22066_22279 = G__22291;
continue;
} else {
var type_22292 = cljs.core.first.call(null,seq__22063_22286__$1);
taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_22292,uid_22194], null),((function (seq__22063_22276,chunk__22064_22277,count__22065_22278,i__22066_22279,type_22292,seq__22063_22286__$1,temp__4657__auto___22285,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
if(cljs.core.not.call(null,_QMARK_v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev], null),cljs.core.PersistentHashSet.fromArray([ev_uuid_22198], true)], null);
} else {
var vec__22068 = _QMARK_v;
var buffered_evs = cljs.core.nth.call(null,vec__22068,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__22068,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,buffered_evs,ev),cljs.core.conj.call(null,ev_uuids,ev_uuid_22198)], null);
}
});})(seq__22063_22276,chunk__22064_22277,count__22065_22278,i__22066_22279,type_22292,seq__22063_22286__$1,temp__4657__auto___22285,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var G__22293 = cljs.core.next.call(null,seq__22063_22286__$1);
var G__22294 = null;
var G__22295 = (0);
var G__22296 = (0);
seq__22063_22276 = G__22293;
chunk__22064_22277 = G__22294;
count__22065_22278 = G__22295;
i__22066_22279 = G__22296;
continue;
}
} else {
}
}
break;
}

var c__18337__auto___22297 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___22297,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___22297,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_22078){
var state_val_22079 = (state_22078[(1)]);
if((state_val_22079 === (1))){
var state_22078__$1 = state_22078;
if(cljs.core.truth_(flush_QMARK_)){
var statearr_22080_22298 = state_22078__$1;
(statearr_22080_22298[(1)] = (2));

} else {
var statearr_22081_22299 = state_22078__$1;
(statearr_22081_22299[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22079 === (2))){
var state_22078__$1 = state_22078;
var statearr_22082_22300 = state_22078__$1;
(statearr_22082_22300[(2)] = null);

(statearr_22082_22300[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22079 === (3))){
var inst_22071 = cljs.core.async.timeout.call(null,send_buf_ms_ws);
var state_22078__$1 = state_22078;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22078__$1,(5),inst_22071);
} else {
if((state_val_22079 === (4))){
var inst_22075 = (state_22078[(2)]);
var inst_22076 = flush_buffer_BANG__22199.call(null,new cljs.core.Keyword(null,"ws","ws",86841443));
var state_22078__$1 = (function (){var statearr_22083 = state_22078;
(statearr_22083[(7)] = inst_22075);

return statearr_22083;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22078__$1,inst_22076);
} else {
if((state_val_22079 === (5))){
var inst_22073 = (state_22078[(2)]);
var state_22078__$1 = state_22078;
var statearr_22084_22301 = state_22078__$1;
(statearr_22084_22301[(2)] = inst_22073);

(statearr_22084_22301[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});})(c__18337__auto___22297,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__18225__auto__,c__18337__auto___22297,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__18226__auto__ = null;
var taoensso$sente$state_machine__18226__auto____0 = (function (){
var statearr_22088 = [null,null,null,null,null,null,null,null];
(statearr_22088[(0)] = taoensso$sente$state_machine__18226__auto__);

(statearr_22088[(1)] = (1));

return statearr_22088;
});
var taoensso$sente$state_machine__18226__auto____1 = (function (state_22078){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_22078);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e22089){if((e22089 instanceof Object)){
var ex__18229__auto__ = e22089;
var statearr_22090_22302 = state_22078;
(statearr_22090_22302[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22078);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22089;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22303 = state_22078;
state_22078 = G__22303;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
taoensso$sente$state_machine__18226__auto__ = function(state_22078){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18226__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18226__auto____1.call(this,state_22078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18226__auto____0;
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18226__auto____1;
return taoensso$sente$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___22297,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__18339__auto__ = (function (){var statearr_22091 = f__18338__auto__.call(null);
(statearr_22091[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___22297);

return statearr_22091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___22297,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);


var c__18337__auto___22304 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___22304,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___22304,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_22101){
var state_val_22102 = (state_22101[(1)]);
if((state_val_22102 === (1))){
var state_22101__$1 = state_22101;
if(cljs.core.truth_(flush_QMARK_)){
var statearr_22103_22305 = state_22101__$1;
(statearr_22103_22305[(1)] = (2));

} else {
var statearr_22104_22306 = state_22101__$1;
(statearr_22104_22306[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22102 === (2))){
var state_22101__$1 = state_22101;
var statearr_22105_22307 = state_22101__$1;
(statearr_22105_22307[(2)] = null);

(statearr_22105_22307[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22102 === (3))){
var inst_22094 = cljs.core.async.timeout.call(null,send_buf_ms_ajax);
var state_22101__$1 = state_22101;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22101__$1,(5),inst_22094);
} else {
if((state_val_22102 === (4))){
var inst_22098 = (state_22101[(2)]);
var inst_22099 = flush_buffer_BANG__22199.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var state_22101__$1 = (function (){var statearr_22106 = state_22101;
(statearr_22106[(7)] = inst_22098);

return statearr_22106;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22101__$1,inst_22099);
} else {
if((state_val_22102 === (5))){
var inst_22096 = (state_22101[(2)]);
var state_22101__$1 = state_22101;
var statearr_22107_22308 = state_22101__$1;
(statearr_22107_22308[(2)] = inst_22096);

(statearr_22107_22308[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});})(c__18337__auto___22304,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__18225__auto__,c__18337__auto___22304,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__18226__auto__ = null;
var taoensso$sente$state_machine__18226__auto____0 = (function (){
var statearr_22111 = [null,null,null,null,null,null,null,null];
(statearr_22111[(0)] = taoensso$sente$state_machine__18226__auto__);

(statearr_22111[(1)] = (1));

return statearr_22111;
});
var taoensso$sente$state_machine__18226__auto____1 = (function (state_22101){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_22101);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e22112){if((e22112 instanceof Object)){
var ex__18229__auto__ = e22112;
var statearr_22113_22309 = state_22101;
(statearr_22113_22309[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22101);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22112;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22310 = state_22101;
state_22101 = G__22310;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
taoensso$sente$state_machine__18226__auto__ = function(state_22101){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18226__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18226__auto____1.call(this,state_22101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18226__auto____0;
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18226__auto____1;
return taoensso$sente$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___22304,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__18339__auto__ = (function (){var statearr_22114 = f__18338__auto__.call(null);
(statearr_22114[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___22304);

return statearr_22114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___22304,uid_22194,__22195,__22196__$1,__22197__$2,ev_uuid_22198,flush_buffer_BANG__22199,vec__22041,map__22042,map__22042__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

}

return null;
};
var G__22193 = function (user_id,ev,var_args){
var p__22040 = null;
if (arguments.length > 2) {
var G__22311__i = 0, G__22311__a = new Array(arguments.length -  2);
while (G__22311__i < G__22311__a.length) {G__22311__a[G__22311__i] = arguments[G__22311__i + 2]; ++G__22311__i;}
  p__22040 = new cljs.core.IndexedSeq(G__22311__a,0);
} 
return G__22193__delegate.call(this,user_id,ev,p__22040);};
G__22193.cljs$lang$maxFixedArity = 2;
G__22193.cljs$lang$applyTo = (function (arglist__22312){
var user_id = cljs.core.first(arglist__22312);
arglist__22312 = cljs.core.next(arglist__22312);
var ev = cljs.core.first(arglist__22312);
var p__22040 = cljs.core.rest(arglist__22312);
return G__22193__delegate(user_id,ev,p__22040);
});
G__22193.cljs$core$IFn$_invoke$arity$variadic = G__22193__delegate;
return G__22193;
})()
;})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var ev_msg_const = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),connected_uids_], null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),connected_uids_,new cljs.core.Keyword(null,"ajax-post-fn","ajax-post-fn",1830071264),((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req){
return taoensso.sente.interfaces.ring_req__GT_server_ch_resp.call(null,web_server_adapter,ring_req,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-open","on-open",-1391088163),((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch){
var params = cljs.core.get.call(null,ring_req,new cljs.core.Keyword(null,"params","params",710516235));
var ppstr = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252));
var client_id = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var vec__22115 = taoensso.sente.unpack.call(null,packer__$1,ppstr);
var clj = cljs.core.nth.call(null,vec__22115,(0),null);
var has_cb_QMARK_ = cljs.core.nth.call(null,vec__22115,(1),null);
taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_.call(null,ch_recv,cljs.core.merge.call(null,ev_msg_const,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req,new cljs.core.Keyword(null,"event","event",301435442),clj,new cljs.core.Keyword(null,"uid","uid",-1447769400),user_id_fn__$1.call(null,ring_req,client_id),new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),(cljs.core.truth_(has_cb_QMARK_)?((function (params,ppstr,client_id,vec__22115,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function taoensso$sente$reply_fn(resp_clj){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",435,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (params,ppstr,client_id,vec__22115,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ajax reply): %s",resp_clj], null);
});})(params,ppstr,client_id,vec__22115,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,cljs.core.meta.call(null,resp_clj),resp_clj),new cljs.core.Keyword(null,"close-after-send","close-after-send",1264946103));
});})(params,ppstr,client_id,vec__22115,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
:null)], null)));

if(cljs.core.truth_(has_cb_QMARK_)){
return null;
} else {
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",442,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (params,ppstr,client_id,vec__22115,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ajax reply): dummy-cb-200"], null);
});})(params,ppstr,client_id,vec__22115,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,null,new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337)),new cljs.core.Keyword(null,"close-after-send","close-after-send",1264946103));
}
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null));
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"ajax-get-or-ws-handshake-fn","ajax-get-or-ws-handshake-fn",-1210409233),((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req){
var csrf_token = csrf_token_fn.call(null,ring_req);
var params = cljs.core.get.call(null,ring_req,new cljs.core.Keyword(null,"params","params",710516235));
var client_id = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var uid = user_id_fn__$1.call(null,ring_req,client_id);
var websocket_QMARK_ = new cljs.core.Keyword(null,"websocket?","websocket?",1552493139).cljs$core$IFn$_invoke$arity$1(ring_req);
var receive_event_msg_BANG_ = ((function (csrf_token,params,client_id,uid,websocket_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() { 
var G__22313__delegate = function (event,p__22116){
var vec__22117 = p__22116;
var _QMARK_reply_fn = cljs.core.nth.call(null,vec__22117,(0),null);
return taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_.call(null,ch_recv,cljs.core.merge.call(null,ev_msg_const,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req,new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),_QMARK_reply_fn,new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null)));
};
var G__22313 = function (event,var_args){
var p__22116 = null;
if (arguments.length > 1) {
var G__22314__i = 0, G__22314__a = new Array(arguments.length -  1);
while (G__22314__i < G__22314__a.length) {G__22314__a[G__22314__i] = arguments[G__22314__i + 1]; ++G__22314__i;}
  p__22116 = new cljs.core.IndexedSeq(G__22314__a,0);
} 
return G__22313__delegate.call(this,event,p__22116);};
G__22313.cljs$lang$maxFixedArity = 1;
G__22313.cljs$lang$applyTo = (function (arglist__22315){
var event = cljs.core.first(arglist__22315);
var p__22116 = cljs.core.rest(arglist__22315);
return G__22313__delegate(event,p__22116);
});
G__22313.cljs$core$IFn$_invoke$arity$variadic = G__22313__delegate;
return G__22313;
})()
;})(csrf_token,params,client_id,uid,websocket_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var handshake_BANG_ = ((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",467,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Handshake!"], null);
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

var _QMARK_handshake_data = handshake_data_fn.call(null,ring_req);
var handshake_ev = ((!((_QMARK_handshake_data == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,csrf_token,_QMARK_handshake_data], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,csrf_token], null)], null));
return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,null,handshake_ev),cljs.core.not.call(null,websocket_QMARK_));
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
if(clojure.string.blank_QMARK_.call(null,client_id)){
var err_msg = "Client's Ring request doesn't have a client id. Does your server have the necessary keyword Ring middleware (`wrap-params` & `wrap-keyword-params`)?";
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",479,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (err_msg,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(err_msg),cljs.core.str(": %s")].join(''),ring_req], null);
});})(err_msg,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

throw cljs.core.ex_info.call(null,err_msg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req], null));
} else {
return taoensso.sente.interfaces.ring_req__GT_server_ch_resp.call(null,web_server_adapter,ring_req,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-open","on-open",-1391088163),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch){
if(cljs.core.truth_(websocket_QMARK_)){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",487,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["New WebSocket channel: %s (%s)",uid,[cljs.core.str(server_ch)].join('')], null);
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

taoensso.encore.reset_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id], null),server_ch);

if(cljs.core.truth_(connect_uid_BANG_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443),uid))){
receive_event_msg_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","uidport-open","chsk/uidport-open",1685786954)], null));
} else {
}

return handshake_BANG_.call(null,server_ch);
} else {
var initial_conn_from_client_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid,client_id], null),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
return taoensso.encore.swapped.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [server_ch,taoensso.encore.now_udt.call(null)], null),(_QMARK_v == null));
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
var handshake_QMARK_ = (function (){var or__6207__auto__ = initial_conn_from_client_QMARK_;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return new cljs.core.Keyword(null,"handshake?","handshake?",-423743093).cljs$core$IFn$_invoke$arity$1(params);
}
})();
if(cljs.core.truth_(connect_uid_BANG_.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549),uid))){
receive_event_msg_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","uidport-open","chsk/uidport-open",1685786954)], null));
} else {
}

if(cljs.core.truth_(handshake_QMARK_)){
return handshake_BANG_.call(null,server_ch);
} else {
return null;
}
}
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"on-msg","on-msg",-2021925279),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,req_ppstr){
var vec__22118 = taoensso.sente.unpack.call(null,packer__$1,req_ppstr);
var clj = cljs.core.nth.call(null,vec__22118,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__22118,(1),null);
return receive_event_msg_BANG_.call(null,clj,(cljs.core.truth_(_QMARK_cb_uuid)?((function (vec__22118,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function taoensso$sente$reply_fn(resp_clj){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",514,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__22118,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ws reply): %s",resp_clj], null);
});})(vec__22118,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,cljs.core.meta.call(null,resp_clj),resp_clj,_QMARK_cb_uuid));
});})(vec__22118,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
:null));
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"on-close","on-close",-761178394),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,status){
if(cljs.core.truth_(websocket_QMARK_)){
taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid], null),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_m){
var new_m = cljs.core.dissoc.call(null,_QMARK_m,client_id);
if(cljs.core.empty_QMARK_.call(null,new_m)){
return new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782);
} else {
return new_m;
}
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var c__18337__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_22132){
var state_val_22133 = (state_22132[(1)]);
if((state_val_22133 === (1))){
var inst_22119 = cljs.core.async.timeout.call(null,(5000));
var state_22132__$1 = state_22132;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22132__$1,(2),inst_22119);
} else {
if((state_val_22133 === (2))){
var inst_22121 = (state_22132[(2)]);
var inst_22122 = upd_connected_uid_BANG_.call(null,uid);
var state_22132__$1 = (function (){var statearr_22134 = state_22132;
(statearr_22134[(7)] = inst_22121);

return statearr_22134;
})();
if(cljs.core.truth_(inst_22122)){
var statearr_22135_22316 = state_22132__$1;
(statearr_22135_22316[(1)] = (3));

} else {
var statearr_22136_22317 = state_22132__$1;
(statearr_22136_22317[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22133 === (3))){
var inst_22124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22125 = [new cljs.core.Keyword("chsk","uidport-close","chsk/uidport-close",901058678)];
var inst_22126 = (new cljs.core.PersistentVector(null,1,(5),inst_22124,inst_22125,null));
var inst_22127 = receive_event_msg_BANG_.call(null,inst_22126);
var state_22132__$1 = state_22132;
var statearr_22137_22318 = state_22132__$1;
(statearr_22137_22318[(2)] = inst_22127);

(statearr_22137_22318[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22133 === (4))){
var state_22132__$1 = state_22132;
var statearr_22138_22319 = state_22132__$1;
(statearr_22138_22319[(2)] = null);

(statearr_22138_22319[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22133 === (5))){
var inst_22130 = (state_22132[(2)]);
var state_22132__$1 = state_22132;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22132__$1,inst_22130);
} else {
return null;
}
}
}
}
}
});})(c__18337__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__18225__auto__,c__18337__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__18226__auto__ = null;
var taoensso$sente$state_machine__18226__auto____0 = (function (){
var statearr_22142 = [null,null,null,null,null,null,null,null];
(statearr_22142[(0)] = taoensso$sente$state_machine__18226__auto__);

(statearr_22142[(1)] = (1));

return statearr_22142;
});
var taoensso$sente$state_machine__18226__auto____1 = (function (state_22132){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_22132);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e22143){if((e22143 instanceof Object)){
var ex__18229__auto__ = e22143;
var statearr_22144_22320 = state_22132;
(statearr_22144_22320[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22132);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22143;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22321 = state_22132;
state_22132 = G__22321;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
taoensso$sente$state_machine__18226__auto__ = function(state_22132){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18226__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18226__auto____1.call(this,state_22132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18226__auto____0;
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18226__auto____1;
return taoensso$sente$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__18339__auto__ = (function (){var statearr_22145 = f__18338__auto__.call(null);
(statearr_22145[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto__);

return statearr_22145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

return c__18337__auto__;
} else {
taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,new cljs.core.Keyword(null,"ajax","ajax",814345549),client_id], null),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__22146){
var vec__22147 = p__22146;
var server_ch__$1 = cljs.core.nth.call(null,vec__22147,(0),null);
var udt_last_connected = cljs.core.nth.call(null,vec__22147,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,udt_last_connected], null);
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var udt_disconnected = taoensso.encore.now_udt.call(null);
var c__18337__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_22170){
var state_val_22171 = (state_22170[(1)]);
if((state_val_22171 === (1))){
var inst_22148 = cljs.core.async.timeout.call(null,(5000));
var state_22170__$1 = state_22170;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22170__$1,(2),inst_22148);
} else {
if((state_val_22171 === (2))){
var inst_22150 = (state_22170[(2)]);
var inst_22151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22152 = [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid];
var inst_22153 = (new cljs.core.PersistentVector(null,2,(5),inst_22151,inst_22152,null));
var inst_22154 = (function (){return ((function (inst_22150,inst_22151,inst_22152,inst_22153,state_val_22171,c__18337__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_m){
var vec__22172 = cljs.core.get.call(null,_QMARK_m,client_id);
var _ = cljs.core.nth.call(null,vec__22172,(0),null);
var _QMARK_udt_last_connected = cljs.core.nth.call(null,vec__22172,(1),null);
var disconnected_QMARK_ = (function (){var and__6195__auto__ = _QMARK_udt_last_connected;
if(cljs.core.truth_(and__6195__auto__)){
return (udt_disconnected >= _QMARK_udt_last_connected);
} else {
return and__6195__auto__;
}
})();
if(cljs.core.not.call(null,disconnected_QMARK_)){
return taoensso.encore.swapped.call(null,_QMARK_m,cljs.core.not.call(null,new cljs.core.Keyword(null,"disconnected","disconnected",-1908014586)));
} else {
var new_m = cljs.core.dissoc.call(null,_QMARK_m,client_id);
return taoensso.encore.swapped.call(null,((cljs.core.empty_QMARK_.call(null,new_m))?new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782):new_m),new cljs.core.Keyword(null,"disconnected","disconnected",-1908014586));
}
});
;})(inst_22150,inst_22151,inst_22152,inst_22153,state_val_22171,c__18337__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var inst_22155 = taoensso.encore.swap_in_BANG_.call(null,conns_,inst_22153,inst_22154);
var state_22170__$1 = (function (){var statearr_22173 = state_22170;
(statearr_22173[(7)] = inst_22150);

return statearr_22173;
})();
if(cljs.core.truth_(inst_22155)){
var statearr_22174_22322 = state_22170__$1;
(statearr_22174_22322[(1)] = (3));

} else {
var statearr_22175_22323 = state_22170__$1;
(statearr_22175_22323[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22171 === (3))){
var inst_22157 = upd_connected_uid_BANG_.call(null,uid);
var state_22170__$1 = state_22170;
if(cljs.core.truth_(inst_22157)){
var statearr_22176_22324 = state_22170__$1;
(statearr_22176_22324[(1)] = (6));

} else {
var statearr_22177_22325 = state_22170__$1;
(statearr_22177_22325[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22171 === (4))){
var state_22170__$1 = state_22170;
var statearr_22178_22326 = state_22170__$1;
(statearr_22178_22326[(2)] = null);

(statearr_22178_22326[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22171 === (5))){
var inst_22168 = (state_22170[(2)]);
var state_22170__$1 = state_22170;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22170__$1,inst_22168);
} else {
if((state_val_22171 === (6))){
var inst_22159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22160 = [new cljs.core.Keyword("chsk","uidport-close","chsk/uidport-close",901058678)];
var inst_22161 = (new cljs.core.PersistentVector(null,1,(5),inst_22159,inst_22160,null));
var inst_22162 = receive_event_msg_BANG_.call(null,inst_22161);
var state_22170__$1 = state_22170;
var statearr_22179_22327 = state_22170__$1;
(statearr_22179_22327[(2)] = inst_22162);

(statearr_22179_22327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22171 === (7))){
var state_22170__$1 = state_22170;
var statearr_22180_22328 = state_22170__$1;
(statearr_22180_22328[(2)] = null);

(statearr_22180_22328[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22171 === (8))){
var inst_22165 = (state_22170[(2)]);
var state_22170__$1 = state_22170;
var statearr_22181_22329 = state_22170__$1;
(statearr_22181_22329[(2)] = inst_22165);

(statearr_22181_22329[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__18337__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__18225__auto__,c__18337__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__18226__auto__ = null;
var taoensso$sente$state_machine__18226__auto____0 = (function (){
var statearr_22185 = [null,null,null,null,null,null,null,null];
(statearr_22185[(0)] = taoensso$sente$state_machine__18226__auto__);

(statearr_22185[(1)] = (1));

return statearr_22185;
});
var taoensso$sente$state_machine__18226__auto____1 = (function (state_22170){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_22170);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e22186){if((e22186 instanceof Object)){
var ex__18229__auto__ = e22186;
var statearr_22187_22330 = state_22170;
(statearr_22187_22330[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22170);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22186;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22331 = state_22170;
state_22170 = G__22331;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
taoensso$sente$state_machine__18226__auto__ = function(state_22170){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18226__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18226__auto____1.call(this,state_22170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18226__auto____0;
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18226__auto____1;
return taoensso$sente$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__18339__auto__ = (function (){var statearr_22188 = f__18338__auto__.call(null);
(statearr_22188[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto__);

return statearr_22188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

return c__18337__auto__;
}
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null));
}
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22024,map__22025,map__22025__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null);
});

taoensso.sente.make_channel_socket_server_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_server_BANG_.cljs$lang$applyTo = (function (seq22021){
var G__22022 = cljs.core.first.call(null,seq22021);
var seq22021__$1 = cljs.core.next.call(null,seq22021);
return taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22022,seq22021__$1);
});
/**
 * Actually pushes buffered events (as packed-str) to all uid's WebSocket conns.
 */
taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_ = (function taoensso$sente$send_buffered_server_evs_GT_ws_clients_BANG_(conns_,uid,buffered_evs_pstr){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",576,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-buffered-server-evs>ws-clients!: %s",buffered_evs_pstr], null);
}),null)),null);

var seq__22336 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid], null))));
var chunk__22337 = null;
var count__22338 = (0);
var i__22339 = (0);
while(true){
if((i__22339 < count__22338)){
var server_ch = cljs.core._nth.call(null,chunk__22337,i__22339);
taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,buffered_evs_pstr);

var G__22340 = seq__22336;
var G__22341 = chunk__22337;
var G__22342 = count__22338;
var G__22343 = (i__22339 + (1));
seq__22336 = G__22340;
chunk__22337 = G__22341;
count__22338 = G__22342;
i__22339 = G__22343;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__22336);
if(temp__4657__auto__){
var seq__22336__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22336__$1)){
var c__7018__auto__ = cljs.core.chunk_first.call(null,seq__22336__$1);
var G__22344 = cljs.core.chunk_rest.call(null,seq__22336__$1);
var G__22345 = c__7018__auto__;
var G__22346 = cljs.core.count.call(null,c__7018__auto__);
var G__22347 = (0);
seq__22336 = G__22344;
chunk__22337 = G__22345;
count__22338 = G__22346;
i__22339 = G__22347;
continue;
} else {
var server_ch = cljs.core.first.call(null,seq__22336__$1);
taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,buffered_evs_pstr);

var G__22348 = cljs.core.next.call(null,seq__22336__$1);
var G__22349 = null;
var G__22350 = (0);
var G__22351 = (0);
seq__22336 = G__22348;
chunk__22337 = G__22349;
count__22338 = G__22350;
i__22339 = G__22351;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Actually pushes buffered events (as packed-str) to all uid's Ajax conns.
 *   Allows some time for possible Ajax poller reconnects.
 */
taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_ = (function taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___22441 = arguments.length;
var i__7277__auto___22442 = (0);
while(true){
if((i__7277__auto___22442 < len__7276__auto___22441)){
args__7283__auto__.push((arguments[i__7277__auto___22442]));

var G__22443 = (i__7277__auto___22442 + (1));
i__7277__auto___22442 = G__22443;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((3) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((3)),(0),null)):null);
return taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7284__auto__);
});

taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (conns_,uid,buffered_evs_pstr,p__22356){
var vec__22357 = p__22356;
var map__22358 = cljs.core.nth.call(null,vec__22357,(0),null);
var map__22358__$1 = ((((!((map__22358 == null)))?((((map__22358.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22358.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22358):map__22358);
var nmax_attempts = cljs.core.get.call(null,map__22358__$1,new cljs.core.Keyword(null,"nmax-attempts","nmax-attempts",1471144610),(7));
var ms_base = cljs.core.get.call(null,map__22358__$1,new cljs.core.Keyword(null,"ms-base","ms-base",-1962784511),(90));
var ms_rand = cljs.core.get.call(null,map__22358__$1,new cljs.core.Keyword(null,"ms-rand","ms-rand",1169398874),(90));

taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",589,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-buffered-server-evs>ajax-clients!: %s",buffered_evs_pstr], null);
});})(vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand))
,null)),null);

var client_ids_unsatisfied = cljs.core.keys.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid], null)));
if(cljs.core.empty_QMARK_.call(null,client_ids_unsatisfied)){
return null;
} else {
var c__18337__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand){
return (function (state_22407){
var state_val_22408 = (state_22407[(1)]);
if((state_val_22408 === (7))){
var inst_22368 = (state_22407[(7)]);
var inst_22361 = (state_22407[(8)]);
var inst_22362 = (state_22407[(9)]);
var inst_22379 = (function (){var n = inst_22361;
var client_ids_satisfied = inst_22362;
var _QMARK_pulled = inst_22368;
return ((function (n,client_ids_satisfied,_QMARK_pulled,inst_22368,inst_22361,inst_22362,state_val_22408,c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand){
return (function (s,client_id,p__22378){
var vec__22409 = p__22378;
var _QMARK_server_ch = cljs.core.nth.call(null,vec__22409,(0),null);
var _ = cljs.core.nth.call(null,vec__22409,(1),null);
if(((_QMARK_server_ch == null)) || (cljs.core.not.call(null,taoensso.sente.interfaces.sch_send_BANG_.call(null,_QMARK_server_ch,buffered_evs_pstr,new cljs.core.Keyword(null,"close-after-send","close-after-send",1264946103))))){
return s;
} else {
return cljs.core.conj.call(null,s,client_id);
}
});
;})(n,client_ids_satisfied,_QMARK_pulled,inst_22368,inst_22361,inst_22362,state_val_22408,c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand))
})();
var inst_22380 = cljs.core.PersistentHashSet.EMPTY;
var inst_22381 = cljs.core.reduce_kv.call(null,inst_22379,inst_22380,inst_22368);
var state_22407__$1 = state_22407;
var statearr_22410_22444 = state_22407__$1;
(statearr_22410_22444[(2)] = inst_22381);

(statearr_22410_22444[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (1))){
var inst_22360 = cljs.core.PersistentHashSet.EMPTY;
var inst_22361 = (0);
var inst_22362 = inst_22360;
var state_22407__$1 = (function (){var statearr_22411 = state_22407;
(statearr_22411[(8)] = inst_22361);

(statearr_22411[(9)] = inst_22362);

return statearr_22411;
})();
var statearr_22412_22445 = state_22407__$1;
(statearr_22412_22445[(2)] = null);

(statearr_22412_22445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (4))){
var state_22407__$1 = state_22407;
var statearr_22413_22446 = state_22407__$1;
(statearr_22413_22446[(2)] = true);

(statearr_22413_22446[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (15))){
var inst_22403 = (state_22407[(2)]);
var state_22407__$1 = state_22407;
var statearr_22414_22447 = state_22407__$1;
(statearr_22414_22447[(2)] = inst_22403);

(statearr_22414_22447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (13))){
var inst_22394 = cljs.core.rand_int.call(null,ms_rand);
var inst_22395 = (ms_base + inst_22394);
var inst_22396 = cljs.core.async.timeout.call(null,inst_22395);
var state_22407__$1 = state_22407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22407__$1,(16),inst_22396);
} else {
if((state_val_22408 === (6))){
var inst_22368 = (state_22407[(7)]);
var inst_22376 = (state_22407[(2)]);
var state_22407__$1 = (function (){var statearr_22415 = state_22407;
(statearr_22415[(10)] = inst_22376);

return statearr_22415;
})();
if(cljs.core.truth_(inst_22368)){
var statearr_22416_22448 = state_22407__$1;
(statearr_22416_22448[(1)] = (7));

} else {
var statearr_22417_22449 = state_22407__$1;
(statearr_22417_22449[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (3))){
var inst_22405 = (state_22407[(2)]);
var state_22407__$1 = state_22407;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22407__$1,inst_22405);
} else {
if((state_val_22408 === (12))){
var inst_22392 = (state_22407[(2)]);
var state_22407__$1 = state_22407;
if(cljs.core.truth_(inst_22392)){
var statearr_22418_22450 = state_22407__$1;
(statearr_22418_22450[(1)] = (13));

} else {
var statearr_22419_22451 = state_22407__$1;
(statearr_22419_22451[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (2))){
var inst_22368 = (state_22407[(7)]);
var inst_22361 = (state_22407[(8)]);
var inst_22362 = (state_22407[(9)]);
var inst_22364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22365 = [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid];
var inst_22366 = (new cljs.core.PersistentVector(null,2,(5),inst_22364,inst_22365,null));
var inst_22367 = (function (){var n = inst_22361;
var client_ids_satisfied = inst_22362;
return ((function (n,client_ids_satisfied,inst_22368,inst_22361,inst_22362,inst_22364,inst_22365,inst_22366,state_val_22408,c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand){
return (function (m){
var ks_to_pull = cljs.core.remove.call(null,client_ids_satisfied,cljs.core.keys.call(null,m));
if(cljs.core.empty_QMARK_.call(null,ks_to_pull)){
return taoensso.encore.swapped.call(null,m,null);
} else {
return taoensso.encore.swapped.call(null,cljs.core.reduce.call(null,((function (ks_to_pull,n,client_ids_satisfied,inst_22368,inst_22361,inst_22362,inst_22364,inst_22365,inst_22366,state_val_22408,c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand){
return (function (m__$1,k){
var vec__22420 = cljs.core.get.call(null,m__$1,k);
var _QMARK_server_ch = cljs.core.nth.call(null,vec__22420,(0),null);
var udt_last_connected = cljs.core.nth.call(null,vec__22420,(1),null);
return cljs.core.assoc.call(null,m__$1,k,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,udt_last_connected], null));
});})(ks_to_pull,n,client_ids_satisfied,inst_22368,inst_22361,inst_22362,inst_22364,inst_22365,inst_22366,state_val_22408,c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand))
,m,ks_to_pull),cljs.core.select_keys.call(null,m,ks_to_pull));
}
});
;})(n,client_ids_satisfied,inst_22368,inst_22361,inst_22362,inst_22364,inst_22365,inst_22366,state_val_22408,c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand))
})();
var inst_22368__$1 = taoensso.encore.swap_in_BANG_.call(null,conns_,inst_22366,inst_22367);
var inst_22369 = (function (){var n = inst_22361;
var client_ids_satisfied = inst_22362;
var _QMARK_pulled = inst_22368__$1;
var __x = inst_22368__$1;
return ((function (n,client_ids_satisfied,_QMARK_pulled,__x,inst_22368,inst_22361,inst_22362,inst_22364,inst_22365,inst_22366,inst_22367,inst_22368__$1,state_val_22408,c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand){
return (function (__x__$1){
var or__6207__auto__ = taoensso.truss.impl.non_throwing.call(null,cljs.core.nil_QMARK_).call(null,__x__$1);
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return taoensso.truss.impl.non_throwing.call(null,cljs.core.map_QMARK_).call(null,__x__$1);
}
});
;})(n,client_ids_satisfied,_QMARK_pulled,__x,inst_22368,inst_22361,inst_22362,inst_22364,inst_22365,inst_22366,inst_22367,inst_22368__$1,state_val_22408,c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand))
})();
var inst_22370 = inst_22369.call(null,inst_22368__$1);
var state_22407__$1 = (function (){var statearr_22421 = state_22407;
(statearr_22421[(7)] = inst_22368__$1);

return statearr_22421;
})();
if(cljs.core.truth_(inst_22370)){
var statearr_22422_22452 = state_22407__$1;
(statearr_22422_22452[(1)] = (4));

} else {
var statearr_22423_22453 = state_22407__$1;
(statearr_22423_22453[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (11))){
var inst_22386 = (state_22407[(11)]);
var state_22407__$1 = state_22407;
var statearr_22424_22454 = state_22407__$1;
(statearr_22424_22454[(2)] = inst_22386);

(statearr_22424_22454[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (9))){
var inst_22361 = (state_22407[(8)]);
var inst_22362 = (state_22407[(9)]);
var inst_22386 = (state_22407[(11)]);
var inst_22384 = (state_22407[(2)]);
var inst_22385 = cljs.core.into.call(null,inst_22362,inst_22384);
var inst_22386__$1 = (inst_22361 < nmax_attempts);
var state_22407__$1 = (function (){var statearr_22425 = state_22407;
(statearr_22425[(12)] = inst_22385);

(statearr_22425[(11)] = inst_22386__$1);

return statearr_22425;
})();
if(cljs.core.truth_(inst_22386__$1)){
var statearr_22426_22455 = state_22407__$1;
(statearr_22426_22455[(1)] = (10));

} else {
var statearr_22427_22456 = state_22407__$1;
(statearr_22427_22456[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (5))){
var inst_22368 = (state_22407[(7)]);
var inst_22373 = "([:or nil? map?] ?pulled)";
var inst_22374 = taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,inst_22373,inst_22368,null,null);
var state_22407__$1 = state_22407;
var statearr_22428_22457 = state_22407__$1;
(statearr_22428_22457[(2)] = inst_22374);

(statearr_22428_22457[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (14))){
var state_22407__$1 = state_22407;
var statearr_22429_22458 = state_22407__$1;
(statearr_22429_22458[(2)] = null);

(statearr_22429_22458[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (16))){
var inst_22361 = (state_22407[(8)]);
var inst_22385 = (state_22407[(12)]);
var inst_22398 = (state_22407[(2)]);
var inst_22399 = (inst_22361 + (1));
var inst_22361__$1 = inst_22399;
var inst_22362 = inst_22385;
var state_22407__$1 = (function (){var statearr_22430 = state_22407;
(statearr_22430[(8)] = inst_22361__$1);

(statearr_22430[(9)] = inst_22362);

(statearr_22430[(13)] = inst_22398);

return statearr_22430;
})();
var statearr_22431_22459 = state_22407__$1;
(statearr_22431_22459[(2)] = null);

(statearr_22431_22459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (10))){
var inst_22385 = (state_22407[(12)]);
var inst_22388 = cljs.core.complement.call(null,inst_22385);
var inst_22389 = cljs.core.some.call(null,inst_22388,client_ids_unsatisfied);
var state_22407__$1 = state_22407;
var statearr_22432_22460 = state_22407__$1;
(statearr_22432_22460[(2)] = inst_22389);

(statearr_22432_22460[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22408 === (8))){
var state_22407__$1 = state_22407;
var statearr_22433_22461 = state_22407__$1;
(statearr_22433_22461[(2)] = null);

(statearr_22433_22461[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand))
;
return ((function (switch__18225__auto__,c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand){
return (function() {
var taoensso$sente$state_machine__18226__auto__ = null;
var taoensso$sente$state_machine__18226__auto____0 = (function (){
var statearr_22437 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22437[(0)] = taoensso$sente$state_machine__18226__auto__);

(statearr_22437[(1)] = (1));

return statearr_22437;
});
var taoensso$sente$state_machine__18226__auto____1 = (function (state_22407){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_22407);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e22438){if((e22438 instanceof Object)){
var ex__18229__auto__ = e22438;
var statearr_22439_22462 = state_22407;
(statearr_22439_22462[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22407);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22438;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22463 = state_22407;
state_22407 = G__22463;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
taoensso$sente$state_machine__18226__auto__ = function(state_22407){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18226__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18226__auto____1.call(this,state_22407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18226__auto____0;
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18226__auto____1;
return taoensso$sente$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand))
})();
var state__18339__auto__ = (function (){var statearr_22440 = f__18338__auto__.call(null);
(statearr_22440[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto__);

return statearr_22440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto__,client_ids_unsatisfied,vec__22357,map__22358,map__22358__$1,nmax_attempts,ms_base,ms_rand))
);

return c__18337__auto__;
}
});

taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$lang$maxFixedArity = (3);

taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$lang$applyTo = (function (seq22352){
var G__22353 = cljs.core.first.call(null,seq22352);
var seq22352__$1 = cljs.core.next.call(null,seq22352);
var G__22354 = cljs.core.first.call(null,seq22352__$1);
var seq22352__$2 = cljs.core.next.call(null,seq22352__$1);
var G__22355 = cljs.core.first.call(null,seq22352__$2);
var seq22352__$3 = cljs.core.next.call(null,seq22352__$2);
return taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22353,G__22354,G__22355,seq22352__$3);
});
/**
 * Alias of `taoensso.encore/ajax-lite`
 */
taoensso.sente.ajax_lite = taoensso.encore.ajax_lite;

/**
 * @interface
 */
taoensso.sente.IChSocket = function(){};

/**
 * Implementation detail
 */
taoensso.sente._chsk_connect_BANG_ = (function taoensso$sente$_chsk_connect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(chsk);
} else {
var x__6870__auto__ = (((chsk == null))?null:chsk);
var m__6871__auto__ = (taoensso.sente._chsk_connect_BANG_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,chsk);
} else {
var m__6871__auto____$1 = (taoensso.sente._chsk_connect_BANG_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.-chsk-connect!",chsk);
}
}
}
});

/**
 * Implementation detail
 */
taoensso.sente._chsk_send_BANG_ = (function taoensso$sente$_chsk_send_BANG_(chsk,ev,opts){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 == null)))){
return chsk.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3(chsk,ev,opts);
} else {
var x__6870__auto__ = (((chsk == null))?null:chsk);
var m__6871__auto__ = (taoensso.sente._chsk_send_BANG_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,chsk,ev,opts);
} else {
var m__6871__auto____$1 = (taoensso.sente._chsk_send_BANG_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,chsk,ev,opts);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.-chsk-send!",chsk);
}
}
}
});

/**
 * DEPRECATED: Please use `chsk-disconnect!` instead
 */
taoensso.sente.chsk_destroy_BANG_ = (function taoensso$sente$chsk_destroy_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1(chsk);
} else {
var x__6870__auto__ = (((chsk == null))?null:chsk);
var m__6871__auto__ = (taoensso.sente.chsk_destroy_BANG_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,chsk);
} else {
var m__6871__auto____$1 = (taoensso.sente.chsk_destroy_BANG_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-destroy!",chsk);
}
}
}
});

/**
 * Disconnects channel socket
 */
taoensso.sente.chsk_disconnect_BANG_ = (function taoensso$sente$chsk_disconnect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1(chsk);
} else {
var x__6870__auto__ = (((chsk == null))?null:chsk);
var m__6871__auto__ = (taoensso.sente.chsk_disconnect_BANG_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,chsk);
} else {
var m__6871__auto____$1 = (taoensso.sente.chsk_disconnect_BANG_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-disconnect!",chsk);
}
}
}
});

/**
 * Reconnects channel socket (useful for reauthenticating after login/logout, etc.)
 */
taoensso.sente.chsk_reconnect_BANG_ = (function taoensso$sente$chsk_reconnect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1(chsk);
} else {
var x__6870__auto__ = (((chsk == null))?null:chsk);
var m__6871__auto__ = (taoensso.sente.chsk_reconnect_BANG_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,chsk);
} else {
var m__6871__auto____$1 = (taoensso.sente.chsk_reconnect_BANG_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-reconnect!",chsk);
}
}
}
});

/**
 * Sends `[ev-id ev-?data :as event]`, returns true on apparent success.
 */
taoensso.sente.chsk_send_BANG_ = (function taoensso$sente$chsk_send_BANG_(var_args){
var args22464 = [];
var len__7276__auto___22467 = arguments.length;
var i__7277__auto___22468 = (0);
while(true){
if((i__7277__auto___22468 < len__7276__auto___22467)){
args22464.push((arguments[i__7277__auto___22468]));

var G__22469 = (i__7277__auto___22468 + (1));
i__7277__auto___22468 = G__22469;
continue;
} else {
}
break;
}

var G__22466 = args22464.length;
switch (G__22466) {
case 2:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22464.length)].join('')));

}
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (chsk,ev){
return taoensso.sente.chsk_send_BANG_.call(null,chsk,ev,cljs.core.PersistentArrayMap.EMPTY);
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (chsk,ev,_QMARK_timeout_ms,_QMARK_cb){
return taoensso.sente.chsk_send_BANG_.call(null,chsk,ev,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),_QMARK_timeout_ms,new cljs.core.Keyword(null,"cb","cb",589947841),_QMARK_cb], null));
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (chsk,ev,opts){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",646,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (%s) %s",cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"cb","cb",589947841),cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"cb","cb",589947841).cljs$core$IFn$_invoke$arity$1(opts))),ev], null);
}),null)),null);

return taoensso.sente._chsk_send_BANG_.call(null,chsk,ev,opts);
});

taoensso.sente.chsk_send_BANG_.cljs$lang$maxFixedArity = 4;
taoensso.sente.assert_send_args = (function taoensso$sente$assert_send_args(x,_QMARK_timeout_ms,_QMARK_cb){
taoensso.sente.assert_event.call(null,x);

if(cljs.core.truth_((function (){var or__6207__auto__ = ((_QMARK_timeout_ms == null)) && ((_QMARK_cb == null));
if(or__6207__auto__){
return or__6207__auto__;
} else {
return taoensso.encore.nneg_int_QMARK_.call(null,_QMARK_timeout_ms);
}
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(taoensso.encore.format.call(null,"cb requires a timeout; timeout-ms should be a +ive integer: %s",_QMARK_timeout_ms)),cljs.core.str("\n"),cljs.core.str("(or (and (nil? ?timeout-ms) (nil? ?cb)) (and (enc/nneg-int? ?timeout-ms)))")].join('')));
}

if(cljs.core.truth_((function (){var or__6207__auto__ = (_QMARK_cb == null);
if(or__6207__auto__){
return or__6207__auto__;
} else {
var or__6207__auto____$1 = cljs.core.ifn_QMARK_.call(null,_QMARK_cb);
if(or__6207__auto____$1){
return or__6207__auto____$1;
} else {
return taoensso.encore.chan_QMARK_.call(null,_QMARK_cb);
}
}
})())){
return null;
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(taoensso.encore.format.call(null,"cb should be nil, an ifn, or a channel: %s",cljs.core.type.call(null,_QMARK_cb))),cljs.core.str("\n"),cljs.core.str("(or (nil? ?cb) (ifn? ?cb) (enc/chan? ?cb))")].join('')));
}
});
taoensso.sente.pull_unused_cb_fn_BANG_ = (function taoensso$sente$pull_unused_cb_fn_BANG_(cbs_waiting_,_QMARK_cb_uuid){
var temp__4657__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto__)){
var cb_uuid = temp__4657__auto__;
return taoensso.encore.swap_in_BANG_.call(null,cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid], null),((function (cb_uuid,temp__4657__auto__){
return (function (_QMARK_f){
return taoensso.encore.swapped.call(null,new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782),_QMARK_f);
});})(cb_uuid,temp__4657__auto__))
);
} else {
return null;
}
});
taoensso.sente.merge_GT_chsk_state_BANG_ = (function taoensso$sente$merge_GT_chsk_state_BANG_(p__22471,merge_state){
var map__22475 = p__22471;
var map__22475__$1 = ((((!((map__22475 == null)))?((((map__22475.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22475.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22475):map__22475);
var chsk = map__22475__$1;
var chs = cljs.core.get.call(null,map__22475__$1,new cljs.core.Keyword(null,"chs","chs",376886120));
var state_ = cljs.core.get.call(null,map__22475__$1,new cljs.core.Keyword(null,"state_","state_",957667102));
var vec__22477 = taoensso.encore.swap_in_BANG_.call(null,state_,cljs.core.PersistentVector.EMPTY,((function (map__22475,map__22475__$1,chsk,chs,state_){
return (function (old_state){
var new_state = cljs.core.merge.call(null,old_state,merge_state);
var new_state__$1 = ((cljs.core.not.call(null,(function (){var and__6195__auto__ = new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116).cljs$core$IFn$_invoke$arity$1(old_state);
if(cljs.core.truth_(and__6195__auto__)){
var and__6195__auto____$1 = new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(new_state);
if(cljs.core.truth_(and__6195__auto____$1)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(old_state));
} else {
return and__6195__auto____$1;
}
} else {
return and__6195__auto__;
}
})()))?new_state:cljs.core.assoc.call(null,cljs.core.dissoc.call(null,new_state,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116)),new cljs.core.Keyword(null,"requested-reconnect?","requested-reconnect?",-1504983666),true));
return taoensso.encore.swapped.call(null,new_state__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_state,new_state__$1], null));
});})(map__22475,map__22475__$1,chsk,chs,state_))
);
var old_state = cljs.core.nth.call(null,vec__22477,(0),null);
var new_state = cljs.core.nth.call(null,vec__22477,(1),null);
if(cljs.core.not_EQ_.call(null,old_state,new_state)){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(chs),new_state);

return new_state;
} else {
return null;
}
});
/**
 * Experimental, undocumented. Allows a core.async channel to be provided
 *   instead of a cb-fn. The channel will receive values of form
 *   [<event-id>.cb <reply>].
 */
taoensso.sente.cb_chan_as_fn = (function taoensso$sente$cb_chan_as_fn(_QMARK_cb,ev){
if(((_QMARK_cb == null)) || (cljs.core.ifn_QMARK_.call(null,_QMARK_cb))){
return _QMARK_cb;
} else {
var __x_22482 = _QMARK_cb;
try{if(cljs.core.truth_(taoensso.encore.chan_QMARK_.call(null,__x_22482))){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22480){if((e22480 instanceof Error)){
var __t_22483 = e22480;
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(enc/chan? ?cb)",__x_22482,__t_22483,null);
} else {
throw e22480;

}
}
taoensso.sente.assert_event.call(null,ev);

var vec__22481 = ev;
var ev_id = cljs.core.nth.call(null,vec__22481,(0),null);
var _ = cljs.core.nth.call(null,vec__22481,(1),null);
var cb_ch = _QMARK_cb;
return ((function (vec__22481,ev_id,_,cb_ch){
return (function (reply){
return cljs.core.async.put_BANG_.call(null,cb_ch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,[cljs.core.str(taoensso.encore.fq_name.call(null,ev_id)),cljs.core.str(".cb")].join('')),reply], null));
});
;})(vec__22481,ev_id,_,cb_ch))
}
});
taoensso.sente.receive_buffered_evs_BANG_ = (function taoensso$sente$receive_buffered_evs_BANG_(chs,clj){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",703,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["receive-buffered-evs!: %s",clj], null);
}),null)),null);

var buffered_evs = (function (){var __x = clj;
try{if(cljs.core.vector_QMARK_.call(null,__x)){
return __x;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22489){if((e22489 instanceof Error)){
var __t = e22489;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(vector? clj)",__x,__t,null);
} else {
throw e22489;

}
}})();
var seq__22490 = cljs.core.seq.call(null,buffered_evs);
var chunk__22491 = null;
var count__22492 = (0);
var i__22493 = (0);
while(true){
if((i__22493 < count__22492)){
var ev = cljs.core._nth.call(null,chunk__22491,i__22493);
taoensso.sente.assert_event.call(null,ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__22494 = seq__22490;
var G__22495 = chunk__22491;
var G__22496 = count__22492;
var G__22497 = (i__22493 + (1));
seq__22490 = G__22494;
chunk__22491 = G__22495;
count__22492 = G__22496;
i__22493 = G__22497;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__22490);
if(temp__4657__auto__){
var seq__22490__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22490__$1)){
var c__7018__auto__ = cljs.core.chunk_first.call(null,seq__22490__$1);
var G__22498 = cljs.core.chunk_rest.call(null,seq__22490__$1);
var G__22499 = c__7018__auto__;
var G__22500 = cljs.core.count.call(null,c__7018__auto__);
var G__22501 = (0);
seq__22490 = G__22498;
chunk__22491 = G__22499;
count__22492 = G__22500;
i__22493 = G__22501;
continue;
} else {
var ev = cljs.core.first.call(null,seq__22490__$1);
taoensso.sente.assert_event.call(null,ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__22502 = cljs.core.next.call(null,seq__22490__$1);
var G__22503 = null;
var G__22504 = (0);
var G__22505 = (0);
seq__22490 = G__22502;
chunk__22491 = G__22503;
count__22492 = G__22504;
i__22493 = G__22505;
continue;
}
} else {
return null;
}
}
break;
}
});
taoensso.sente.handle_when_handshake_BANG_ = (function taoensso$sente$handle_when_handshake_BANG_(chsk,chs,clj){
var handshake_QMARK_ = (cljs.core.vector_QMARK_.call(null,clj)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,clj),new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686)));
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",713,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (handshake_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["handle-when-handshake (%s): %s",((handshake_QMARK_)?new cljs.core.Keyword(null,"handshake","handshake",68079331):new cljs.core.Keyword(null,"non-handshake","non-handshake",576986062)),clj], null);
});})(handshake_QMARK_))
,null)),null);

if(handshake_QMARK_){
var vec__22508 = clj;
var _ = cljs.core.nth.call(null,vec__22508,(0),null);
var vec__22509 = cljs.core.nth.call(null,vec__22508,(1),null);
var _QMARK_uid = cljs.core.nth.call(null,vec__22509,(0),null);
var _QMARK_csrf_token = cljs.core.nth.call(null,vec__22509,(1),null);
var _QMARK_handshake_data = cljs.core.nth.call(null,vec__22509,(2),null);
var handshake_ev = vec__22508;
if(clojure.string.blank_QMARK_.call(null,_QMARK_csrf_token)){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",719,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__22508,_,vec__22509,_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,handshake_ev,handshake_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SECURITY WARNING: no CSRF token available for use by Sente"], null);
});})(vec__22508,_,vec__22509,_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,handshake_ev,handshake_QMARK_))
,null)),null);
} else {
}

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"open?","open?",1238443125),true,new cljs.core.Keyword(null,"uid","uid",-1447769400),_QMARK_uid,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),_QMARK_csrf_token], null));

taoensso.sente.assert_event.call(null,handshake_ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(chs),handshake_ev);

return new cljs.core.Keyword(null,"handled","handled",1889700151);
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChWebSocket = (function (client_id,chs,params,packer,url,state_,cbs_waiting_,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,backoff_ms_fn,active_retry_id_,retry_count_,__meta,__extmap,__hash){
this.client_id = client_id;
this.chs = chs;
this.params = params;
this.packer = packer;
this.url = url;
this.state_ = state_;
this.cbs_waiting_ = cbs_waiting_;
this.socket_ = socket_;
this.kalive_ms = kalive_ms;
this.kalive_timer_ = kalive_timer_;
this.kalive_due_QMARK__ = kalive_due_QMARK__;
this.backoff_ms_fn = backoff_ms_fn;
this.active_retry_id_ = active_retry_id_;
this.retry_count_ = retry_count_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6829__auto__,k__6830__auto__){
var self__ = this;
var this__6829__auto____$1 = this;
return cljs.core._lookup.call(null,this__6829__auto____$1,k__6830__auto__,null);
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6831__auto__,k22511,else__6832__auto__){
var self__ = this;
var this__6831__auto____$1 = this;
var G__22513 = (((k22511 instanceof cljs.core.Keyword))?k22511.fqn:null);
switch (G__22513) {
case "client-id":
return self__.client_id;

break;
case "kalive-ms":
return self__.kalive_ms;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "retry-count_":
return self__.retry_count_;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "socket_":
return self__.socket_;

break;
case "url":
return self__.url;

break;
case "active-retry-id_":
return self__.active_retry_id_;

break;
case "kalive-due?_":
return self__.kalive_due_QMARK__;

break;
case "cbs-waiting_":
return self__.cbs_waiting_;

break;
case "kalive-timer_":
return self__.kalive_timer_;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k22511,else__6832__auto__);

}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6843__auto__,writer__6844__auto__,opts__6845__auto__){
var self__ = this;
var this__6843__auto____$1 = this;
var pr_pair__6846__auto__ = ((function (this__6843__auto____$1){
return (function (keyval__6847__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6844__auto__,cljs.core.pr_writer,""," ","",opts__6845__auto__,keyval__6847__auto__);
});})(this__6843__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__6844__auto__,pr_pair__6846__auto__,"#taoensso.sente.ChWebSocket{",", ","}",opts__6845__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),self__.retry_count_],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$ = true;

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__22510){
var self__ = this;
var G__22510__$1 = this;
return (new cljs.core.RecordIter((0),G__22510__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6827__auto__){
var self__ = this;
var this__6827__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6823__auto__){
var self__ = this;
var this__6823__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6833__auto__){
var self__ = this;
var this__6833__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6824__auto__){
var self__ = this;
var this__6824__auto____$1 = this;
var h__6642__auto__ = self__.__hash;
if(!((h__6642__auto__ == null))){
return h__6642__auto__;
} else {
var h__6642__auto____$1 = cljs.core.hash_imap.call(null,this__6824__auto____$1);
self__.__hash = h__6642__auto____$1;

return h__6642__auto____$1;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6825__auto__,other__6826__auto__){
var self__ = this;
var this__6825__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6195__auto__ = other__6826__auto__;
if(cljs.core.truth_(and__6195__auto__)){
var and__6195__auto____$1 = (this__6825__auto____$1.constructor === other__6826__auto__.constructor);
if(and__6195__auto____$1){
return cljs.core.equiv_map.call(null,this__6825__auto____$1,other__6826__auto__);
} else {
return and__6195__auto____$1;
}
} else {
return and__6195__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6838__auto__,k__6839__auto__){
var self__ = this;
var this__6838__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),null,new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),null,new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__6839__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6838__auto____$1),self__.__meta),k__6839__auto__);
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6839__auto__)),null));
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6836__auto__,k__6837__auto__,G__22510){
var self__ = this;
var this__6836__auto____$1 = this;
var pred__22514 = cljs.core.keyword_identical_QMARK_;
var expr__22515 = k__6837__auto__;
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),expr__22515))){
return (new taoensso.sente.ChWebSocket(G__22510,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"chs","chs",376886120),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,G__22510,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,G__22510,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"packer","packer",66077544),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,G__22510,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,G__22510,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,G__22510,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,G__22510,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,G__22510,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,G__22510,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,G__22510,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,G__22510,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,G__22510,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,G__22510,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22514.call(null,new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),expr__22515))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,G__22510,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6837__auto__,G__22510),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6841__auto__){
var self__ = this;
var this__6841__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),self__.retry_count_],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6828__auto__,G__22510){
var self__ = this;
var this__6828__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,G__22510,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6834__auto__,entry__6835__auto__){
var self__ = this;
var this__6834__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6835__auto__)){
return cljs.core._assoc.call(null,this__6834__auto____$1,cljs.core._nth.call(null,entry__6835__auto__,(0)),cljs.core._nth.call(null,entry__6835__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6834__auto____$1,entry__6835__auto__);
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$ = true;

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,p__22517){
var self__ = this;
var map__22518 = p__22517;
var map__22518__$1 = ((((!((map__22518 == null)))?((((map__22518.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22518.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22518):map__22518);
var opts = map__22518__$1;
var _QMARK_timeout_ms = cljs.core.get.call(null,map__22518__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.call(null,map__22518__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.call(null,map__22518__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var chsk__$1 = this;
taoensso.sente.assert_send_args.call(null,ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",750,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (_QMARK_cb_fn,chsk__$1,map__22518,map__22518__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send against closed chsk."], null);
});})(_QMARK_cb_fn,chsk__$1,map__22518,map__22518__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264));
} else {
return null;
}
} else {
var _QMARK_cb_uuid = (cljs.core.truth_(_QMARK_cb_fn)?taoensso.encore.uuid_str.call(null,(6)):null);
var ppstr = taoensso.sente.pack.call(null,self__.packer,cljs.core.meta.call(null,ev),ev,_QMARK_cb_uuid);
var temp__4657__auto___22554 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto___22554)){
var cb_uuid_22555 = temp__4657__auto___22554;
taoensso.encore.reset_in_BANG_.call(null,self__.cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid_22555], null),(function (){var __x = _QMARK_cb_fn;
try{if(cljs.core.truth_(taoensso.truss.impl.nnil_QMARK_.call(null,__x))){
return __x;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22520){if((e22520 instanceof Error)){
var __t = e22520;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(taoensso.truss.impl/nnil? ?cb-fn)",__x,__t,null);
} else {
throw e22520;

}
}})());

var temp__4657__auto___22556__$1 = _QMARK_timeout_ms;
if(cljs.core.truth_(temp__4657__auto___22556__$1)){
var timeout_ms_22557 = temp__4657__auto___22556__$1;
var c__18337__auto___22558 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___22558,timeout_ms_22557,temp__4657__auto___22556__$1,cb_uuid_22555,temp__4657__auto___22554,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22518,map__22518__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___22558,timeout_ms_22557,temp__4657__auto___22556__$1,cb_uuid_22555,temp__4657__auto___22554,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22518,map__22518__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (state_22531){
var state_val_22532 = (state_22531[(1)]);
if((state_val_22532 === (1))){
var inst_22521 = cljs.core.async.timeout.call(null,timeout_ms_22557);
var state_22531__$1 = state_22531;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22531__$1,(2),inst_22521);
} else {
if((state_val_22532 === (2))){
var inst_22524 = (state_22531[(7)]);
var inst_22523 = (state_22531[(2)]);
var inst_22524__$1 = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,_QMARK_cb_uuid);
var state_22531__$1 = (function (){var statearr_22533 = state_22531;
(statearr_22533[(8)] = inst_22523);

(statearr_22533[(7)] = inst_22524__$1);

return statearr_22533;
})();
if(cljs.core.truth_(inst_22524__$1)){
var statearr_22534_22559 = state_22531__$1;
(statearr_22534_22559[(1)] = (3));

} else {
var statearr_22535_22560 = state_22531__$1;
(statearr_22535_22560[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22532 === (3))){
var inst_22524 = (state_22531[(7)]);
var inst_22526 = inst_22524.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
var state_22531__$1 = state_22531;
var statearr_22536_22561 = state_22531__$1;
(statearr_22536_22561[(2)] = inst_22526);

(statearr_22536_22561[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22532 === (4))){
var state_22531__$1 = state_22531;
var statearr_22537_22562 = state_22531__$1;
(statearr_22537_22562[(2)] = null);

(statearr_22537_22562[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22532 === (5))){
var inst_22529 = (state_22531[(2)]);
var state_22531__$1 = state_22531;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22531__$1,inst_22529);
} else {
return null;
}
}
}
}
}
});})(c__18337__auto___22558,timeout_ms_22557,temp__4657__auto___22556__$1,cb_uuid_22555,temp__4657__auto___22554,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22518,map__22518__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
;
return ((function (switch__18225__auto__,c__18337__auto___22558,timeout_ms_22557,temp__4657__auto___22556__$1,cb_uuid_22555,temp__4657__auto___22554,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22518,map__22518__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function() {
var taoensso$sente$state_machine__18226__auto__ = null;
var taoensso$sente$state_machine__18226__auto____0 = (function (){
var statearr_22541 = [null,null,null,null,null,null,null,null,null];
(statearr_22541[(0)] = taoensso$sente$state_machine__18226__auto__);

(statearr_22541[(1)] = (1));

return statearr_22541;
});
var taoensso$sente$state_machine__18226__auto____1 = (function (state_22531){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_22531);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e22542){if((e22542 instanceof Object)){
var ex__18229__auto__ = e22542;
var statearr_22543_22563 = state_22531;
(statearr_22543_22563[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22531);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22542;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22564 = state_22531;
state_22531 = G__22564;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
taoensso$sente$state_machine__18226__auto__ = function(state_22531){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18226__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18226__auto____1.call(this,state_22531);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18226__auto____0;
taoensso$sente$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18226__auto____1;
return taoensso$sente$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___22558,timeout_ms_22557,temp__4657__auto___22556__$1,cb_uuid_22555,temp__4657__auto___22554,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22518,map__22518__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
})();
var state__18339__auto__ = (function (){var statearr_22544 = f__18338__auto__.call(null);
(statearr_22544[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___22558);

return statearr_22544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___22558,timeout_ms_22557,temp__4657__auto___22556__$1,cb_uuid_22555,temp__4657__auto___22554,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22518,map__22518__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
);

} else {
}
} else {
}

try{cljs.core.deref.call(null,self__.socket_).send(ppstr);

cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,false);

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}catch (e22545){if((e22545 instanceof Error)){
var e = e22545;
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",769,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22518,map__22518__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"Chsk send error"], null);
});})(e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22518,map__22518__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

var temp__4657__auto___22565 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto___22565)){
var cb_uuid_22566 = temp__4657__auto___22565;
var cb_fn_STAR__22567 = (function (){var or__6207__auto__ = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,cb_uuid_22566);
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
var __x = _QMARK_cb_fn;
try{if(cljs.core.truth_(taoensso.truss.impl.nnil_QMARK_.call(null,__x))){
return __x;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22546){if((e22546 instanceof Error)){
var __t = e22546;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(taoensso.truss.impl/nnil? ?cb-fn)",__x,__t,null);
} else {
throw e22546;

}
}}
})();
cb_fn_STAR__22567.call(null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439));
} else {
}

return false;
} else {
throw e22545;

}
}}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
return taoensso.sente.chsk_disconnect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"disconnected");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

var temp__4657__auto__ = cljs.core.deref.call(null,self__.socket_);
if(cljs.core.truth_(temp__4657__auto__)){
var s = temp__4657__auto__;
return s.close((1000),"CLOSE_NORMAL");
} else {
return null;
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"reconnecting");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116),true], null));

var temp__4657__auto___22568 = cljs.core.deref.call(null,self__.socket_);
if(cljs.core.truth_(temp__4657__auto___22568)){
var s_22569 = temp__4657__auto___22568;
s_22569.close((3000),"SENTE_RECONNECT");
} else {
}

return taoensso.sente._chsk_connect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var temp__4657__auto__ = (function (){var or__6207__auto__ = taoensso.encore.oget.call(null,window,"WebSocket");
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return taoensso.encore.oget.call(null,window,"MozWebSocket");
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var WebSocket = temp__4657__auto__;
var retry_id = taoensso.encore.uuid_str.call(null);
var connect_fn = ((function (retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function taoensso$sente$connect_fn(){
var retry_fn = ((function (retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,self__.active_retry_id_),retry_id)){
var retry_count_STAR_ = cljs.core.swap_BANG_.call(null,self__.retry_count_,cljs.core.inc);
var backoff_ms = self__.backoff_ms_fn.call(null,retry_count_STAR_);
window.clearInterval(cljs.core.deref.call(null,self__.kalive_timer_));

taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",800,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_count_STAR_,backoff_ms,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect (%s)",retry_count_STAR_], null);
});})(retry_count_STAR_,backoff_ms,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);

return window.setTimeout(taoensso$sente$connect_fn,backoff_ms);
} else {
return null;
}
});})(retry_id,WebSocket,temp__4657__auto__,chsk__$1))
;
var _QMARK_socket = (function (){try{return (new WebSocket(taoensso.encore.merge_url_with_query_string.call(null,self__.url,cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null)))));
}catch (e22550){if((e22550 instanceof Error)){
var e = e22550;
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",811,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,retry_fn,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"WebSocket js/Error"], null);
});})(e,retry_fn,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);

return null;
} else {
throw e22550;

}
}})();
if(cljs.core.not.call(null,_QMARK_socket)){
return retry_fn.call(null);
} else {
return cljs.core.reset_BANG_.call(null,self__.socket_,(function (){var G__22551 = _QMARK_socket;
(G__22551["onerror"] = ((function (G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (ws_ev){
return taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",820,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["WebSocket error: %s",ws_ev], null);
});})(G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);
});})(G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__22551["onmessage"] = ((function (G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (ws_ev){
var ppstr = taoensso.encore.oget.call(null,ws_ev,"data");
var vec__22552 = taoensso.sente.unpack.call(null,self__.packer,ppstr);
var clj = cljs.core.nth.call(null,vec__22552,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__22552,(1),null);
var or__6207__auto__ = (function (){var and__6195__auto__ = taoensso.sente.handle_when_handshake_BANG_.call(null,chsk__$1,self__.chs,clj);
if(cljs.core.truth_(and__6195__auto__)){
return cljs.core.reset_BANG_.call(null,self__.retry_count_,(0));
} else {
return and__6195__auto__;
}
})();
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
var temp__4655__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4655__auto__)){
var cb_uuid = temp__4655__auto__;
var temp__4655__auto____$1 = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,cb_uuid);
if(cljs.core.truth_(temp__4655__auto____$1)){
var cb_fn = temp__4655__auto____$1;
return cb_fn.call(null,clj);
} else {
return taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",838,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (temp__4655__auto____$1,cb_uuid,temp__4655__auto__,or__6207__auto__,ppstr,vec__22552,clj,_QMARK_cb_uuid,G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",clj], null);
});})(temp__4655__auto____$1,cb_uuid,temp__4655__auto__,or__6207__auto__,ppstr,vec__22552,clj,_QMARK_cb_uuid,G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);
}
} else {
var buffered_evs = clj;
return taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,buffered_evs);
}
}
});})(G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__22551["onopen"] = ((function (G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (_ws_ev){
return cljs.core.reset_BANG_.call(null,self__.kalive_timer_,window.setInterval(((function (G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
if(cljs.core.truth_(cljs.core.deref.call(null,self__.kalive_due_QMARK__))){
taoensso.sente.chsk_send_BANG_.call(null,chsk__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","ws-ping","chsk/ws-ping",191675304)], null));
} else {
}

return cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,true);
});})(G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,self__.kalive_ms));
});})(G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__22551["onclose"] = ((function (G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (_ws_ev){
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

return retry_fn.call(null);
});})(G__22551,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

return G__22551;
})());
}
});})(retry_id,WebSocket,temp__4657__auto__,chsk__$1))
;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,retry_id);

cljs.core.reset_BANG_.call(null,self__.retry_count_,(0));

connect_fn.call(null);

return chsk__$1;
} else {
return null;
}
});

taoensso.sente.ChWebSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"cbs-waiting_","cbs-waiting_",121502466,null),new cljs.core.Symbol(null,"socket_","socket_",1279482619,null),new cljs.core.Symbol(null,"kalive-ms","kalive-ms",1851265548,null),new cljs.core.Symbol(null,"kalive-timer_","kalive-timer_",-1096022620,null),new cljs.core.Symbol(null,"kalive-due?_","kalive-due?_",1679969599,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null),new cljs.core.Symbol(null,"active-retry-id_","active-retry-id_",1468292413,null),new cljs.core.Symbol(null,"retry-count_","retry-count_",1660769620,null)], null);
});

taoensso.sente.ChWebSocket.cljs$lang$type = true;

taoensso.sente.ChWebSocket.cljs$lang$ctorPrSeq = (function (this__6863__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChWebSocket");
});

taoensso.sente.ChWebSocket.cljs$lang$ctorPrWriter = (function (this__6863__auto__,writer__6864__auto__){
return cljs.core._write.call(null,writer__6864__auto__,"taoensso.sente/ChWebSocket");
});

taoensso.sente.__GT_ChWebSocket = (function taoensso$sente$__GT_ChWebSocket(client_id,chs,params,packer,url,state_,cbs_waiting_,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,backoff_ms_fn,active_retry_id_,retry_count_){
return (new taoensso.sente.ChWebSocket(client_id,chs,params,packer,url,state_,cbs_waiting_,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,backoff_ms_fn,active_retry_id_,retry_count_,null,null,null));
});

taoensso.sente.map__GT_ChWebSocket = (function taoensso$sente$map__GT_ChWebSocket(G__22512){
return (new taoensso.sente.ChWebSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"socket_","socket_",-361048908).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114).cljs$core$IFn$_invoke$arity$1(G__22512),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093).cljs$core$IFn$_invoke$arity$1(G__22512),null,cljs.core.dissoc.call(null,G__22512,new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093)),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChAjaxSocket = (function (client_id,chs,params,packer,url,state_,timeout_ms,ajax_opts,curr_xhr_,active_retry_id_,backoff_ms_fn,__meta,__extmap,__hash){
this.client_id = client_id;
this.chs = chs;
this.params = params;
this.packer = packer;
this.url = url;
this.state_ = state_;
this.timeout_ms = timeout_ms;
this.ajax_opts = ajax_opts;
this.curr_xhr_ = curr_xhr_;
this.active_retry_id_ = active_retry_id_;
this.backoff_ms_fn = backoff_ms_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6829__auto__,k__6830__auto__){
var self__ = this;
var this__6829__auto____$1 = this;
return cljs.core._lookup.call(null,this__6829__auto____$1,k__6830__auto__,null);
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6831__auto__,k22571,else__6832__auto__){
var self__ = this;
var this__6831__auto____$1 = this;
var G__22573 = (((k22571 instanceof cljs.core.Keyword))?k22571.fqn:null);
switch (G__22573) {
case "curr-xhr_":
return self__.curr_xhr_;

break;
case "client-id":
return self__.client_id;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "url":
return self__.url;

break;
case "active-retry-id_":
return self__.active_retry_id_;

break;
case "ajax-opts":
return self__.ajax_opts;

break;
case "timeout-ms":
return self__.timeout_ms;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k22571,else__6832__auto__);

}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6843__auto__,writer__6844__auto__,opts__6845__auto__){
var self__ = this;
var this__6843__auto____$1 = this;
var pr_pair__6846__auto__ = ((function (this__6843__auto____$1){
return (function (keyval__6847__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6844__auto__,cljs.core.pr_writer,""," ","",opts__6845__auto__,keyval__6847__auto__);
});})(this__6843__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__6844__auto__,pr_pair__6846__auto__,"#taoensso.sente.ChAjaxSocket{",", ","}",opts__6845__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$ = true;

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__22570){
var self__ = this;
var G__22570__$1 = this;
return (new cljs.core.RecordIter((0),G__22570__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6827__auto__){
var self__ = this;
var this__6827__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6823__auto__){
var self__ = this;
var this__6823__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6833__auto__){
var self__ = this;
var this__6833__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6824__auto__){
var self__ = this;
var this__6824__auto____$1 = this;
var h__6642__auto__ = self__.__hash;
if(!((h__6642__auto__ == null))){
return h__6642__auto__;
} else {
var h__6642__auto____$1 = cljs.core.hash_imap.call(null,this__6824__auto____$1);
self__.__hash = h__6642__auto____$1;

return h__6642__auto____$1;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6825__auto__,other__6826__auto__){
var self__ = this;
var this__6825__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6195__auto__ = other__6826__auto__;
if(cljs.core.truth_(and__6195__auto__)){
var and__6195__auto____$1 = (this__6825__auto____$1.constructor === other__6826__auto__.constructor);
if(and__6195__auto____$1){
return cljs.core.equiv_map.call(null,this__6825__auto____$1,other__6826__auto__);
} else {
return and__6195__auto____$1;
}
} else {
return and__6195__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6838__auto__,k__6839__auto__){
var self__ = this;
var this__6838__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),null,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__6839__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6838__auto____$1),self__.__meta),k__6839__auto__);
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6839__auto__)),null));
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6836__auto__,k__6837__auto__,G__22570){
var self__ = this;
var this__6836__auto____$1 = this;
var pred__22574 = cljs.core.keyword_identical_QMARK_;
var expr__22575 = k__6837__auto__;
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(G__22570,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"chs","chs",376886120),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,G__22570,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,G__22570,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"packer","packer",66077544),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,G__22570,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,G__22570,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,G__22570,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,G__22570,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,G__22570,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,G__22570,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,G__22570,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22574.call(null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),expr__22575))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,G__22570,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6837__auto__,G__22570),null));
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6841__auto__){
var self__ = this;
var this__6841__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6828__auto__,G__22570){
var self__ = this;
var this__6828__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,G__22570,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6834__auto__,entry__6835__auto__){
var self__ = this;
var this__6834__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6835__auto__)){
return cljs.core._assoc.call(null,this__6834__auto____$1,cljs.core._nth.call(null,entry__6835__auto__,(0)),cljs.core._nth.call(null,entry__6835__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6834__auto____$1,entry__6835__auto__);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$ = true;

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,p__22577){
var self__ = this;
var map__22578 = p__22577;
var map__22578__$1 = ((((!((map__22578 == null)))?((((map__22578.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22578.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22578):map__22578);
var opts = map__22578__$1;
var _QMARK_timeout_ms = cljs.core.get.call(null,map__22578__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.call(null,map__22578__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.call(null,map__22578__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var chsk__$1 = this;
taoensso.sente.assert_send_args.call(null,ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",879,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (_QMARK_cb_fn,chsk__$1,map__22578,map__22578__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send against closed chsk."], null);
});})(_QMARK_cb_fn,chsk__$1,map__22578,map__22578__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264));
} else {
return null;
}
} else {
var csrf_token = new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_));
taoensso.sente.ajax_lite.call(null,self__.url,cljs.core.merge.call(null,self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),_QMARK_timeout_ms,new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs.core.merge.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(self__.ajax_opts),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"X-CSRF-Token","X-CSRF-Token",1562992453),csrf_token], null)),new cljs.core.Keyword(null,"params","params",710516235),(function (){var ppstr = taoensso.sente.pack.call(null,self__.packer,cljs.core.meta.call(null,ev),ev,(cljs.core.truth_(_QMARK_cb_fn)?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):null));
return cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"_","_",1453416199),taoensso.encore.now_udt.call(null),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),csrf_token,new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252),ppstr], null));
})()], null)),((function (csrf_token,_QMARK_cb_fn,chsk__$1,map__22578,map__22578__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function taoensso$sente$ajax_cb(p__22580){
var map__22584 = p__22580;
var map__22584__$1 = ((((!((map__22584 == null)))?((((map__22584.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22584.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22584):map__22584);
var _QMARK_error = cljs.core.get.call(null,map__22584__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.call(null,map__22584__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.call(null,_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
} else {
return null;
}
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439));
} else {
return null;
}
}
} else {
var content = _QMARK_content;
var resp_ppstr = content;
var vec__22586 = taoensso.sente.unpack.call(null,self__.packer,resp_ppstr);
var resp_clj = cljs.core.nth.call(null,vec__22586,(0),null);
var _ = cljs.core.nth.call(null,vec__22586,(1),null);
if(cljs.core.truth_(_QMARK_cb_fn)){
_QMARK_cb_fn.call(null,resp_clj);
} else {
if(cljs.core.not_EQ_.call(null,resp_clj,new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",919,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (content,resp_ppstr,vec__22586,resp_clj,_,map__22584,map__22584__$1,_QMARK_error,_QMARK_content,csrf_token,_QMARK_cb_fn,chsk__$1,map__22578,map__22578__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",resp_clj], null);
});})(content,resp_ppstr,vec__22586,resp_clj,_,map__22584,map__22584__$1,_QMARK_error,_QMARK_content,csrf_token,_QMARK_cb_fn,chsk__$1,map__22578,map__22578__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);
} else {
}
}

return taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));
}
});})(csrf_token,_QMARK_cb_fn,chsk__$1,map__22578,map__22578__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
);

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
return taoensso.sente.chsk_disconnect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"disconnected");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

var temp__4657__auto__ = cljs.core.deref.call(null,self__.curr_xhr_);
if(cljs.core.truth_(temp__4657__auto__)){
var x = temp__4657__auto__;
return x.abort();
} else {
return null;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"reconnecting");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116),true], null));

var temp__4657__auto___22602 = cljs.core.deref.call(null,self__.curr_xhr_);
if(cljs.core.truth_(temp__4657__auto___22602)){
var x_22603 = temp__4657__auto___22602;
x_22603.abort();
} else {
}

return taoensso.sente._chsk_connect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var retry_id = taoensso.encore.uuid_str.call(null);
var poll_fn = ((function (retry_id,chsk__$1){
return (function taoensso$sente$poll_fn(retry_count){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",940,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_id,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["async-poll-for-update!"], null);
});})(retry_id,chsk__$1))
,null)),null);

var retry_fn = ((function (retry_id,chsk__$1){
return (function (){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,self__.active_retry_id_),retry_id)){
var retry_count_STAR_ = (retry_count + (1));
var backoff_ms = self__.backoff_ms_fn.call(null,retry_count_STAR_);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",946,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_count_STAR_,backoff_ms,retry_id,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect (%s)",retry_count_STAR_], null);
});})(retry_count_STAR_,backoff_ms,retry_id,chsk__$1))
,null)),null);

return window.setTimeout(((function (retry_count_STAR_,backoff_ms,retry_id,chsk__$1){
return (function (){
return taoensso$sente$poll_fn.call(null,retry_count_STAR_);
});})(retry_count_STAR_,backoff_ms,retry_id,chsk__$1))
,backoff_ms);
} else {
return null;
}
});})(retry_id,chsk__$1))
;
return cljs.core.reset_BANG_.call(null,self__.curr_xhr_,taoensso.sente.ajax_lite.call(null,self__.url,cljs.core.merge.call(null,self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms,new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"_","_",1453416199),taoensso.encore.now_udt.call(null),new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null),(cljs.core.truth_(new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handshake?","handshake?",-423743093),true], null)))], null)),((function (retry_fn,retry_id,chsk__$1){
return (function taoensso$sente$poll_fn_$_ajax_cb(p__22594){
var map__22598 = p__22594;
var map__22598__$1 = ((((!((map__22598 == null)))?((((map__22598.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22598.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22598):map__22598);
var _QMARK_error = cljs.core.get.call(null,map__22598__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.call(null,map__22598__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.call(null,_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
return taoensso$sente$poll_fn.call(null,(0));
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

return retry_fn.call(null);

}
} else {
var content = _QMARK_content;
var ppstr = content;
var vec__22600 = taoensso.sente.unpack.call(null,self__.packer,ppstr);
var clj = cljs.core.nth.call(null,vec__22600,(0),null);
var _ = cljs.core.nth.call(null,vec__22600,(1),null);
var or__6207__auto___22604 = taoensso.sente.handle_when_handshake_BANG_.call(null,chsk__$1,self__.chs,clj);
if(cljs.core.truth_(or__6207__auto___22604)){
} else {
var buffered_evs_22605 = clj;
taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,buffered_evs_22605);

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));
}

return taoensso$sente$poll_fn.call(null,(0));
}
});})(retry_fn,retry_id,chsk__$1))
));
});})(retry_id,chsk__$1))
;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,retry_id);

poll_fn.call(null,(0));

return chsk__$1;
});

taoensso.sente.ChAjaxSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"timeout-ms","timeout-ms",-1900214363,null),new cljs.core.Symbol(null,"ajax-opts","ajax-opts",1122292418,null),new cljs.core.Symbol(null,"curr-xhr_","curr-xhr_",321757831,null),new cljs.core.Symbol(null,"active-retry-id_","active-retry-id_",1468292413,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null)], null);
});

taoensso.sente.ChAjaxSocket.cljs$lang$type = true;

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrSeq = (function (this__6863__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrWriter = (function (this__6863__auto__,writer__6864__auto__){
return cljs.core._write.call(null,writer__6864__auto__,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.__GT_ChAjaxSocket = (function taoensso$sente$__GT_ChAjaxSocket(client_id,chs,params,packer,url,state_,timeout_ms,ajax_opts,curr_xhr_,active_retry_id_,backoff_ms_fn){
return (new taoensso.sente.ChAjaxSocket(client_id,chs,params,packer,url,state_,timeout_ms,ajax_opts,curr_xhr_,active_retry_id_,backoff_ms_fn,null,null,null));
});

taoensso.sente.map__GT_ChAjaxSocket = (function taoensso$sente$map__GT_ChAjaxSocket(G__22572){
return (new taoensso.sente.ChAjaxSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__22572),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__22572),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__22572),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__22572),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__22572),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__22572),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406).cljs$core$IFn$_invoke$arity$1(G__22572),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109).cljs$core$IFn$_invoke$arity$1(G__22572),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696).cljs$core$IFn$_invoke$arity$1(G__22572),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114).cljs$core$IFn$_invoke$arity$1(G__22572),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__22572),null,cljs.core.dissoc.call(null,G__22572,new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955)),null));
});

taoensso.sente.get_chsk_url = (function taoensso$sente$get_chsk_url(protocol,chsk_host,chsk_path,type){
var protocol__$1 = (function (){var G__22607 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__22607) {
case "ajax":
return protocol;

break;
case "ws":
if(cljs.core._EQ_.call(null,protocol,"https:")){
return "wss:";
} else {
return "ws:";
}

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
})();
return [cljs.core.str(protocol__$1),cljs.core.str("//"),cljs.core.str(taoensso.encore.path.call(null,chsk_host,chsk_path))].join('');
});
/**
 * Returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *           ; May `put!` (inject) arbitrary `event`s to this channel.
 *  :send-fn ; (fn [event & [?timeout-ms ?cb-fn]]) for client>server send.
 *  :state   ; Watchable, read-only (atom {:type _ :open? _ :uid _ :csrf-token _}).
 *  :chsk    ; IChSocket implementer. You can usu. ignore this.
 * 
 *   Common options:
 *  :type           ; e/o #{:auto :ws :ajax}. You'll usually want the default (:auto)
 *  :host           ; Server host (defaults to current page's host)
 *  :params         ; Map of any params to incl. in chsk Ring requests (handy for
 *                  ; application-level auth, etc.)
 *  :ws-kalive-ms   ; Ping to keep a WebSocket conn alive if no activity w/in given
 *                  ; number of milliseconds
 *  :lp-timeout-ms  ; Ping to keep a long-polling (Ajax) conn alive '' [1]
 *  :packer         ; :edn (default), or an IPacker implementation (experimental)
 *  :ajax-opts      ; Base opts map provided to `taoensso.encore/ajax-lite`
 *  :wrap-recv-evs? ; Should events from server be wrapped in [:chsk/recv _]?
 * 
 *   [1] If you're using Immutant and override the default :lp-timeout-ms, you'll
 *    need to provide the same timeout value to
 *    `taoensso.sente.server-adapters.immutant/make-immutant-adapter` and use
 *    the result of that function as the web server adapter to your server-side
 *    `make-channel-socket-server!`.
 */
taoensso.sente.make_channel_socket_client_BANG_ = (function taoensso$sente$make_channel_socket_client_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___22623 = arguments.length;
var i__7277__auto___22624 = (0);
while(true){
if((i__7277__auto___22624 < len__7276__auto___22623)){
args__7283__auto__.push((arguments[i__7277__auto___22624]));

var G__22625 = (i__7277__auto___22624 + (1));
i__7277__auto___22624 = G__22625;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((1) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((1)),(0),null)):null);
return taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7284__auto__);
});

taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (path,p__22612){
var vec__22613 = p__22612;
var map__22614 = cljs.core.nth.call(null,vec__22613,(0),null);
var map__22614__$1 = ((((!((map__22614 == null)))?((((map__22614.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22614.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22614):map__22614);
var opts = map__22614__$1;
var ajax_opts = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109));
var ws_kalive_ms = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),(25000));
var lp_timeout_ms = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"lp-timeout-ms","lp-timeout-ms",-1451963133),(25000));
var client_id = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140),(function (){var or__6207__auto__ = new cljs.core.Keyword(null,"client-uuid","client-uuid",-1717531965).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return taoensso.encore.uuid_str.call(null);
}
})());
var packer = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
var params = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"params","params",710516235));
var type = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"auto","auto",-566279492));
var host = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var recv_buf_or_n = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer.call(null,(2048)));
var backoff_ms_fn = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),taoensso.encore.exp_backoff);
var wrap_recv_evs_QMARK_ = cljs.core.get.call(null,map__22614__$1,new cljs.core.Keyword(null,"wrap-recv-evs?","wrap-recv-evs?",-1996694153),true);
var _deprecated_more_opts = cljs.core.nth.call(null,vec__22613,(1),null);
if(cljs.core.truth_((function (){var __x = type;
try{if(((function (__x,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (__x__$1){
return cljs.core.contains_QMARK_.call(null,taoensso.truss.impl.set_STAR_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null,new cljs.core.Keyword(null,"auto","auto",-566279492),null], null), null)),__x__$1);
});})(__x,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
.call(null,__x)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22616){if((e22616 instanceof Error)){
var __t = e22616;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"([:in #{:ws :ajax :auto}] type)",__x,__t,null);
} else {
throw e22616;

}
}})())){
} else {
throw (new Error("Assert failed: (have? [:in #{:ws :ajax :auto}] type)"));
}

if(cljs.core.truth_((function (){var __x = client_id;
try{if(cljs.core.truth_(taoensso.encore.nblank_str_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22617){if((e22617 instanceof Error)){
var __t = e22617;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(enc/nblank-str? client-id)",__x,__t,null);
} else {
throw e22617;

}
}})())){
} else {
throw (new Error("Assert failed: (have? enc/nblank-str? client-id)"));
}

if(!((_deprecated_more_opts == null))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",1055,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["`make-channel-socket-client!` fn signature CHANGED with Sente v0.10.0."], null);
});})(vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null);
} else {
}

if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"lp-timeout","lp-timeout",1149461302))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",1057,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [":lp-timeout opt has CHANGED; please use :lp-timout-ms."], null);
});})(vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null);
} else {
}

var packer__$1 = taoensso.sente.interfaces.coerce_packer.call(null,packer);
var win_location = taoensso.encore.get_window_location.call(null);
var win_protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(win_location);
var host__$1 = (function (){var or__6207__auto__ = host;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(win_location);
}
})();
var path__$1 = (function (){var or__6207__auto__ = path;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return new cljs.core.Keyword(null,"pathname","pathname",-1420497528).cljs$core$IFn$_invoke$arity$1(win_location);
}
})();
var private_chs = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(10))),new cljs.core.Keyword(null,"internal","internal",-854870097),cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(10))),new cljs.core.Keyword(null,"<server","<server",-2135373537),cljs.core.async.chan.call(null,recv_buf_or_n)], null);
var ever_opened_QMARK__ = cljs.core.atom.call(null,false);
var state_STAR_ = ((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (state){
if(cljs.core.truth_((function (){var or__6207__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(state));
if(or__6207__auto__){
return or__6207__auto__;
} else {
return cljs.core.deref.call(null,ever_opened_QMARK__);
}
})())){
return state;
} else {
cljs.core.reset_BANG_.call(null,ever_opened_QMARK__,true);

return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"first-open?","first-open?",396686530),true);
}
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
;
var public_ch_recv = cljs.core.async.merge.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(private_chs),cljs.core.async.map_LT_.call(null,((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (state){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","state","chsk/state",-1991397620),state_STAR_.call(null,state)], null);
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(private_chs)),(function (){var _LT_server_ch = new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(private_chs);
if(cljs.core.truth_(wrap_recv_evs_QMARK_)){
return cljs.core.async.map_LT_.call(null,((function (_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","recv","chsk/recv",561097091),ev], null);
});})(_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,_LT_server_ch);
} else {
return cljs.core.async.map_LT_.call(null,((function (_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
var vec__22618 = ev;
var id = cljs.core.nth.call(null,vec__22618,(0),null);
var _QMARK_data = cljs.core.nth.call(null,vec__22618,(1),null);
var __x_22626 = (function (){try{return cljs.core.namespace.call(null,id);
}catch (e22619){if((e22619 instanceof Error)){
var __t = e22619;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"((fn* [p1__22609#] (not= p1__22609# \"chsk\")) (namespace id))",taoensso.truss.impl._invar_undefined_val,__t,null);
} else {
throw e22619;

}
}})();
try{if(((function (__x_22626,vec__22618,id,_QMARK_data,_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (p1__22609_SHARP_){
return cljs.core.not_EQ_.call(null,p1__22609_SHARP_,"chsk");
});})(__x_22626,vec__22618,id,_QMARK_data,_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
.call(null,__x_22626)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22620){if((e22620 instanceof Error)){
var __t_22627 = e22620;
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"((fn* [p1__22609#] (not= p1__22609# \"chsk\")) (namespace id))",__x_22626,__t_22627,null);
} else {
throw e22620;

}
}
return ev;
});})(_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,_LT_server_ch);
}
})()], null));
var chsk = (function (){var or__6207__auto__ = (function (){var and__6195__auto__ = cljs.core.not_EQ_.call(null,type,new cljs.core.Keyword(null,"ajax","ajax",814345549));
if(and__6195__auto__){
return taoensso.sente._chsk_connect_BANG_.call(null,taoensso.sente.map__GT_ChWebSocket.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"state_","state_",957667102)],[client_id,ws_kalive_ms,packer__$1,private_chs,params,cljs.core.atom.call(null,(0)),backoff_ms_fn,cljs.core.atom.call(null,null),(function (){var temp__4655__auto__ = new cljs.core.Keyword(null,"chsk-url-fn","chsk-url-fn",1968894294).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return f.call(null,path__$1,win_location,new cljs.core.Keyword(null,"ws","ws",86841443));
} else {
return taoensso.sente.get_chsk_url.call(null,win_protocol,host__$1,path__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
}
})(),cljs.core.atom.call(null,"pending"),cljs.core.atom.call(null,true),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.call(null,null),cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"open?","open?",1238443125),false], null))])));
} else {
return and__6195__auto__;
}
})();
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
var and__6195__auto__ = cljs.core.not_EQ_.call(null,type,new cljs.core.Keyword(null,"ws","ws",86841443));
if(and__6195__auto__){
return taoensso.sente._chsk_connect_BANG_.call(null,taoensso.sente.map__GT_ChAjaxSocket.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"state_","state_",957667102)],[cljs.core.atom.call(null,null),client_id,packer__$1,private_chs,params,backoff_ms_fn,(function (){var temp__4655__auto__ = new cljs.core.Keyword(null,"chsk-url-fn","chsk-url-fn",1968894294).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return f.call(null,path__$1,win_location,new cljs.core.Keyword(null,"ajax","ajax",814345549));
} else {
return taoensso.sente.get_chsk_url.call(null,win_protocol,host__$1,path__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
}
})(),cljs.core.atom.call(null,"pending"),ajax_opts,lp_timeout_ms,cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ajax","ajax",814345549),new cljs.core.Keyword(null,"open?","open?",1238443125),false], null))])));
} else {
return and__6195__auto__;
}
}
})();
var _ = (cljs.core.truth_(chsk)?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Failed to create channel socket"),cljs.core.str("\n"),cljs.core.str("chsk")].join('')))})());
var send_fn = cljs.core.partial.call(null,taoensso.sente.chsk_send_BANG_,chsk);
var public_ch_recv__$1 = cljs.core.async.map_LT_.call(null,((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function taoensso$sente$ev__GT_ev_msg(ev){
var vec__22622 = taoensso.sente.as_event.call(null,ev);
var ev_id = cljs.core.nth.call(null,vec__22622,(0),null);
var ev__QMARK_data = cljs.core.nth.call(null,vec__22622,(1),null);
var ev__$1 = vec__22622;
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),public_ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk),new cljs.core.Keyword(null,"event","event",301435442),ev__$1,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null);
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__22613,map__22614,map__22614__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,public_ch_recv);
if(cljs.core.truth_(chsk)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"chsk","chsk",-863703081),chsk,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),public_ch_recv__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk)], null);
} else {
return null;
}
});

taoensso.sente.make_channel_socket_client_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_client_BANG_.cljs$lang$applyTo = (function (seq22610){
var G__22611 = cljs.core.first.call(null,seq22610);
var seq22610__$1 = cljs.core.next.call(null,seq22610);
return taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22611,seq22610__$1);
});
taoensso.sente._start_chsk_router_BANG_ = (function taoensso$sente$_start_chsk_router_BANG_(server_QMARK_,ch_recv,event_msg_handler,opts){
var map__22834 = opts;
var map__22834__$1 = ((((!((map__22834 == null)))?((((map__22834.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22834.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22834):map__22834);
var trace_evs_QMARK_ = cljs.core.get.call(null,map__22834__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__22834__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
var ch_ctrl = cljs.core.async.chan.call(null);
var c__18337__auto___23040 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (state_22965){
var state_val_22966 = (state_22965[(1)]);
if((state_val_22966 === (7))){
var inst_22961 = (state_22965[(2)]);
var state_22965__$1 = state_22965;
var statearr_22967_23041 = state_22965__$1;
(statearr_22967_23041[(2)] = inst_22961);

(statearr_22967_23041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (20))){
var inst_22843 = (state_22965[(7)]);
var inst_22870 = (state_22965[(8)]);
var inst_22842 = (state_22965[(9)]);
var inst_22869 = (state_22965[(10)]);
var inst_22845 = (state_22965[(11)]);
var inst_22844 = (state_22965[(12)]);
var inst_22880 = (function (){var vec__22837 = inst_22842;
var v = inst_22843;
var p = inst_22844;
var stop_QMARK_ = inst_22845;
var map__22848 = inst_22869;
var event_msg = inst_22869;
var event = inst_22870;
return ((function (vec__22837,v,p,stop_QMARK_,map__22848,event_msg,event,inst_22843,inst_22870,inst_22842,inst_22869,inst_22845,inst_22844,state_val_22966,c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Pre-handler event: %s",event], null);
});
;})(vec__22837,v,p,stop_QMARK_,map__22848,event_msg,event,inst_22843,inst_22870,inst_22842,inst_22869,inst_22845,inst_22844,state_val_22966,c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_22881 = (new cljs.core.Delay(inst_22880,null));
var inst_22882 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",1176,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_22881,null);
var state_22965__$1 = state_22965;
var statearr_22968_23042 = state_22965__$1;
(statearr_22968_23042[(2)] = inst_22882);

(statearr_22968_23042[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (27))){
var inst_22869 = (state_22965[(10)]);
var inst_22887 = (state_22965[(2)]);
var inst_22888 = "(server-event-msg? event-msg)";
var inst_22889 = taoensso.truss.impl._invar_violation_BANG_.call(null,null,"taoensso.sente",null,inst_22888,inst_22869,inst_22887,null);
var state_22965__$1 = state_22965;
var statearr_22969_23043 = state_22965__$1;
(statearr_22969_23043[(2)] = inst_22889);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22965__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (1))){
var state_22965__$1 = state_22965;
var statearr_22970_23044 = state_22965__$1;
(statearr_22970_23044[(2)] = null);

(statearr_22970_23044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (24))){
var state_22965__$1 = state_22965;
var statearr_22971_23045 = state_22965__$1;
(statearr_22971_23045[(2)] = null);

(statearr_22971_23045[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (39))){
var state_22965__$1 = state_22965;
var statearr_22972_23046 = state_22965__$1;
(statearr_22972_23046[(2)] = null);

(statearr_22972_23046[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (46))){
var inst_22934 = (state_22965[(13)]);
var inst_22942 = (state_22965[(2)]);
var inst_22943 = [inst_22942,null];
var inst_22944 = (new cljs.core.PersistentVector(null,2,(5),inst_22934,inst_22943,null));
var state_22965__$1 = state_22965;
var statearr_22973_23047 = state_22965__$1;
(statearr_22973_23047[(2)] = inst_22944);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22965__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (4))){
var inst_22842 = (state_22965[(9)]);
var inst_22845 = (state_22965[(11)]);
var inst_22844 = (state_22965[(12)]);
var inst_22842__$1 = (state_22965[(2)]);
var inst_22843 = cljs.core.nth.call(null,inst_22842__$1,(0),null);
var inst_22844__$1 = cljs.core.nth.call(null,inst_22842__$1,(1),null);
var inst_22845__$1 = taoensso.encore.kw_identical_QMARK_.call(null,inst_22844__$1,ch_ctrl);
var state_22965__$1 = (function (){var statearr_22974 = state_22965;
(statearr_22974[(7)] = inst_22843);

(statearr_22974[(9)] = inst_22842__$1);

(statearr_22974[(11)] = inst_22845__$1);

(statearr_22974[(12)] = inst_22844__$1);

return statearr_22974;
})();
if(cljs.core.truth_(inst_22845__$1)){
var statearr_22975_23048 = state_22965__$1;
(statearr_22975_23048[(1)] = (5));

} else {
var statearr_22976_23049 = state_22965__$1;
(statearr_22976_23049[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (15))){
var inst_22843 = (state_22965[(7)]);
var state_22965__$1 = state_22965;
var statearr_22977_23050 = state_22965__$1;
(statearr_22977_23050[(2)] = inst_22843);

(statearr_22977_23050[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (48))){
var state_22965__$1 = state_22965;
var statearr_22978_23051 = state_22965__$1;
(statearr_22978_23051[(2)] = null);

(statearr_22978_23051[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (21))){
var state_22965__$1 = state_22965;
var statearr_22979_23052 = state_22965__$1;
(statearr_22979_23052[(2)] = null);

(statearr_22979_23052[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (31))){
var inst_22898 = (state_22965[(2)]);
var state_22965__$1 = state_22965;
var statearr_22980_23053 = state_22965__$1;
(statearr_22980_23053[(2)] = inst_22898);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22965__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (32))){
var inst_22915 = (state_22965[(2)]);
var state_22965__$1 = state_22965;
var statearr_22981_23054 = state_22965__$1;
(statearr_22981_23054[(2)] = inst_22915);

(statearr_22981_23054[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (40))){
var inst_22958 = (state_22965[(2)]);
var state_22965__$1 = (function (){var statearr_22982 = state_22965;
(statearr_22982[(14)] = inst_22958);

return statearr_22982;
})();
var statearr_22983_23055 = state_22965__$1;
(statearr_22983_23055[(2)] = null);

(statearr_22983_23055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (33))){
var inst_22869 = (state_22965[(10)]);
var inst_22902 = (state_22965[(2)]);
var inst_22903 = "(client-event-msg? event-msg)";
var inst_22904 = taoensso.truss.impl._invar_violation_BANG_.call(null,null,"taoensso.sente",null,inst_22903,inst_22869,inst_22902,null);
var state_22965__$1 = state_22965;
var statearr_22984_23056 = state_22965__$1;
(statearr_22984_23056[(2)] = inst_22904);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22965__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (13))){
var inst_22861 = (state_22965[(2)]);
var state_22965__$1 = state_22965;
var statearr_22985_23057 = state_22965__$1;
(statearr_22985_23057[(2)] = inst_22861);

(statearr_22985_23057[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (22))){
var inst_22885 = (state_22965[(2)]);
var state_22965__$1 = (function (){var statearr_22986 = state_22965;
(statearr_22986[(15)] = inst_22885);

return statearr_22986;
})();
if(cljs.core.truth_(server_QMARK_)){
var statearr_22987_23058 = state_22965__$1;
(statearr_22987_23058[(1)] = (23));

} else {
var statearr_22988_23059 = state_22965__$1;
(statearr_22988_23059[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (36))){
var inst_22911 = taoensso.truss.impl._invar_violation_BANG_.call(null);
var state_22965__$1 = state_22965;
var statearr_22989_23060 = state_22965__$1;
(statearr_22989_23060[(2)] = inst_22911);

(statearr_22989_23060[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (41))){
var inst_22948 = (state_22965[(16)]);
var inst_22946 = (state_22965[(17)]);
var inst_22946__$1 = (state_22965[(2)]);
var inst_22947 = cljs.core.nth.call(null,inst_22946__$1,(0),null);
var inst_22948__$1 = cljs.core.nth.call(null,inst_22946__$1,(1),null);
var state_22965__$1 = (function (){var statearr_22990 = state_22965;
(statearr_22990[(16)] = inst_22948__$1);

(statearr_22990[(18)] = inst_22947);

(statearr_22990[(17)] = inst_22946__$1);

return statearr_22990;
})();
if(cljs.core.truth_(inst_22948__$1)){
var statearr_22991_23061 = state_22965__$1;
(statearr_22991_23061[(1)] = (47));

} else {
var statearr_22992_23062 = state_22965__$1;
(statearr_22992_23062[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (43))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22965,(42),Error,null,(41));
var inst_22934 = cljs.core.PersistentVector.EMPTY_NODE;
var state_22965__$1 = (function (){var statearr_22993 = state_22965;
(statearr_22993[(13)] = inst_22934);

return statearr_22993;
})();
if(cljs.core.truth_(error_handler)){
var statearr_22994_23063 = state_22965__$1;
(statearr_22994_23063[(1)] = (44));

} else {
var statearr_22995_23064 = state_22965__$1;
(statearr_22995_23064[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (29))){
var inst_22869 = (state_22965[(10)]);
var state_22965__$1 = state_22965;
var statearr_22996_23065 = state_22965__$1;
(statearr_22996_23065[(2)] = inst_22869);

(statearr_22996_23065[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (44))){
var inst_22869 = (state_22965[(10)]);
var inst_22924 = (state_22965[(19)]);
var inst_22936 = error_handler.call(null,inst_22924,inst_22869);
var state_22965__$1 = state_22965;
var statearr_22997_23066 = state_22965__$1;
(statearr_22997_23066[(2)] = inst_22936);

(statearr_22997_23066[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (6))){
var inst_22843 = (state_22965[(7)]);
var inst_22851 = (inst_22843 == null);
var inst_22852 = cljs.core.not.call(null,inst_22851);
var state_22965__$1 = state_22965;
if(inst_22852){
var statearr_22998_23067 = state_22965__$1;
(statearr_22998_23067[(1)] = (8));

} else {
var statearr_22999_23068 = state_22965__$1;
(statearr_22999_23068[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (28))){
var inst_22869 = (state_22965[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22965,(27),Error,null,(26));
var inst_22893 = taoensso.sente.server_event_msg_QMARK_.call(null,inst_22869);
var state_22965__$1 = state_22965;
if(cljs.core.truth_(inst_22893)){
var statearr_23000_23069 = state_22965__$1;
(statearr_23000_23069[(1)] = (29));

} else {
var statearr_23001_23070 = state_22965__$1;
(statearr_23001_23070[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (25))){
var inst_22878 = (state_22965[(20)]);
var inst_22917 = (state_22965[(2)]);
var inst_22918 = event_msg_handler.call(null,inst_22917);
var inst_22919 = [inst_22918,null];
var inst_22920 = (new cljs.core.PersistentVector(null,2,(5),inst_22878,inst_22919,null));
var state_22965__$1 = state_22965;
var statearr_23002_23071 = state_22965__$1;
(statearr_23002_23071[(2)] = inst_22920);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22965__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (34))){
var inst_22869 = (state_22965[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22965,(33),Error,null,(32));
var inst_22908 = taoensso.sente.client_event_msg_QMARK_.call(null,inst_22869);
var state_22965__$1 = state_22965;
if(cljs.core.truth_(inst_22908)){
var statearr_23003_23072 = state_22965__$1;
(statearr_23003_23072[(1)] = (35));

} else {
var statearr_23004_23073 = state_22965__$1;
(statearr_23004_23073[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (17))){
var inst_22924 = (state_22965[(19)]);
var inst_22922 = (state_22965[(21)]);
var inst_22922__$1 = (state_22965[(2)]);
var inst_22923 = cljs.core.nth.call(null,inst_22922__$1,(0),null);
var inst_22924__$1 = cljs.core.nth.call(null,inst_22922__$1,(1),null);
var state_22965__$1 = (function (){var statearr_23005 = state_22965;
(statearr_23005[(22)] = inst_22923);

(statearr_23005[(19)] = inst_22924__$1);

(statearr_23005[(21)] = inst_22922__$1);

return statearr_23005;
})();
if(cljs.core.truth_(inst_22924__$1)){
var statearr_23006_23074 = state_22965__$1;
(statearr_23006_23074[(1)] = (38));

} else {
var statearr_23007_23075 = state_22965__$1;
(statearr_23007_23075[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (3))){
var inst_22963 = (state_22965[(2)]);
var state_22965__$1 = state_22965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22965__$1,inst_22963);
} else {
if((state_val_22966 === (12))){
var state_22965__$1 = state_22965;
var statearr_23008_23076 = state_22965__$1;
(statearr_23008_23076[(2)] = false);

(statearr_23008_23076[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (2))){
var inst_22838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22839 = [ch_recv,ch_ctrl];
var inst_22840 = (new cljs.core.PersistentVector(null,2,(5),inst_22838,inst_22839,null));
var state_22965__$1 = state_22965;
return cljs.core.async.ioc_alts_BANG_.call(null,state_22965__$1,(4),inst_22840);
} else {
if((state_val_22966 === (23))){
var state_22965__$1 = state_22965;
var statearr_23009_23077 = state_22965__$1;
(statearr_23009_23077[(2)] = null);

(statearr_23009_23077[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (47))){
var inst_22948 = (state_22965[(16)]);
var inst_22843 = (state_22965[(7)]);
var inst_22870 = (state_22965[(8)]);
var inst_22842 = (state_22965[(9)]);
var inst_22869 = (state_22965[(10)]);
var inst_22924 = (state_22965[(19)]);
var inst_22845 = (state_22965[(11)]);
var inst_22947 = (state_22965[(18)]);
var inst_22946 = (state_22965[(17)]);
var inst_22844 = (state_22965[(12)]);
var inst_22922 = (state_22965[(21)]);
var inst_22950 = (function (){var p = inst_22844;
var _QMARK_error = inst_22924;
var v = inst_22843;
var _ = inst_22947;
var vec__22926 = inst_22946;
var e2 = inst_22948;
var vec__22849 = inst_22922;
var _QMARK_error2 = inst_22948;
var event_msg = inst_22869;
var vec__22837 = inst_22842;
var e = inst_22924;
var temp__4657__auto__ = inst_22948;
var event = inst_22870;
var map__22848 = inst_22869;
var stop_QMARK_ = inst_22845;
return ((function (p,_QMARK_error,v,_,vec__22926,e2,vec__22849,_QMARK_error2,event_msg,vec__22837,e,temp__4657__auto__,event,map__22848,stop_QMARK_,inst_22948,inst_22843,inst_22870,inst_22842,inst_22869,inst_22924,inst_22845,inst_22947,inst_22946,inst_22844,inst_22922,state_val_22966,c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e2,"Chsk router `error-handler` error: %s",event], null);
});
;})(p,_QMARK_error,v,_,vec__22926,e2,vec__22849,_QMARK_error2,event_msg,vec__22837,e,temp__4657__auto__,event,map__22848,stop_QMARK_,inst_22948,inst_22843,inst_22870,inst_22842,inst_22869,inst_22924,inst_22845,inst_22947,inst_22946,inst_22844,inst_22922,state_val_22966,c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_22951 = (new cljs.core.Delay(inst_22950,null));
var inst_22952 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",1189,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_22951,null);
var state_22965__$1 = state_22965;
var statearr_23010_23078 = state_22965__$1;
(statearr_23010_23078[(2)] = inst_22952);

(statearr_23010_23078[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (35))){
var inst_22869 = (state_22965[(10)]);
var state_22965__$1 = state_22965;
var statearr_23011_23079 = state_22965__$1;
(statearr_23011_23079[(2)] = inst_22869);

(statearr_23011_23079[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (19))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22965,(18),Error,null,(17));
var inst_22878 = cljs.core.PersistentVector.EMPTY_NODE;
var state_22965__$1 = (function (){var statearr_23012 = state_22965;
(statearr_23012[(20)] = inst_22878);

return statearr_23012;
})();
if(cljs.core.truth_(trace_evs_QMARK_)){
var statearr_23013_23080 = state_22965__$1;
(statearr_23013_23080[(1)] = (20));

} else {
var statearr_23014_23081 = state_22965__$1;
(statearr_23014_23081[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (11))){
var state_22965__$1 = state_22965;
var statearr_23015_23082 = state_22965__$1;
(statearr_23015_23082[(2)] = true);

(statearr_23015_23082[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (9))){
var state_22965__$1 = state_22965;
var statearr_23016_23083 = state_22965__$1;
(statearr_23016_23083[(2)] = false);

(statearr_23016_23083[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (5))){
var state_22965__$1 = state_22965;
var statearr_23017_23084 = state_22965__$1;
(statearr_23017_23084[(2)] = null);

(statearr_23017_23084[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (14))){
var inst_22843 = (state_22965[(7)]);
var inst_22866 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22843);
var state_22965__$1 = state_22965;
var statearr_23018_23085 = state_22965__$1;
(statearr_23018_23085[(2)] = inst_22866);

(statearr_23018_23085[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (45))){
var inst_22843 = (state_22965[(7)]);
var inst_22870 = (state_22965[(8)]);
var inst_22842 = (state_22965[(9)]);
var inst_22869 = (state_22965[(10)]);
var inst_22923 = (state_22965[(22)]);
var inst_22924 = (state_22965[(19)]);
var inst_22845 = (state_22965[(11)]);
var inst_22844 = (state_22965[(12)]);
var inst_22922 = (state_22965[(21)]);
var inst_22938 = (function (){var p = inst_22844;
var _QMARK_error = inst_22924;
var v = inst_22843;
var temp__4655__auto__ = error_handler;
var _ = inst_22923;
var vec__22849 = inst_22922;
var event_msg = inst_22869;
var vec__22837 = inst_22842;
var e = inst_22924;
var temp__4657__auto__ = inst_22924;
var event = inst_22870;
var map__22848 = inst_22869;
var stop_QMARK_ = inst_22845;
return ((function (p,_QMARK_error,v,temp__4655__auto__,_,vec__22849,event_msg,vec__22837,e,temp__4657__auto__,event,map__22848,stop_QMARK_,inst_22843,inst_22870,inst_22842,inst_22869,inst_22923,inst_22924,inst_22845,inst_22844,inst_22922,state_val_22966,c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"Chsk router `event-msg-handler` error: %s",event], null);
});
;})(p,_QMARK_error,v,temp__4655__auto__,_,vec__22849,event_msg,vec__22837,e,temp__4657__auto__,event,map__22848,stop_QMARK_,inst_22843,inst_22870,inst_22842,inst_22869,inst_22923,inst_22924,inst_22845,inst_22844,inst_22922,state_val_22966,c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_22939 = (new cljs.core.Delay(inst_22938,null));
var inst_22940 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init5011374508296446144.clj",1187,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_22939,null);
var state_22965__$1 = state_22965;
var statearr_23019_23086 = state_22965__$1;
(statearr_23019_23086[(2)] = inst_22940);

(statearr_23019_23086[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (26))){
var inst_22900 = (state_22965[(2)]);
var state_22965__$1 = state_22965;
var statearr_23020_23087 = state_22965__$1;
(statearr_23020_23087[(2)] = inst_22900);

(statearr_23020_23087[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (16))){
var inst_22869 = (state_22965[(10)]);
var inst_22869__$1 = (state_22965[(2)]);
var inst_22870 = cljs.core.get.call(null,inst_22869__$1,new cljs.core.Keyword(null,"event","event",301435442));
var state_22965__$1 = (function (){var statearr_23021 = state_22965;
(statearr_23021[(8)] = inst_22870);

(statearr_23021[(10)] = inst_22869__$1);

return statearr_23021;
})();
var statearr_23022_23088 = state_22965__$1;
(statearr_23022_23088[(2)] = null);

(statearr_23022_23088[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (38))){
var state_22965__$1 = state_22965;
var statearr_23023_23089 = state_22965__$1;
(statearr_23023_23089[(2)] = null);

(statearr_23023_23089[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (30))){
var inst_22896 = taoensso.truss.impl._invar_violation_BANG_.call(null);
var state_22965__$1 = state_22965;
var statearr_23024_23090 = state_22965__$1;
(statearr_23024_23090[(2)] = inst_22896);

(statearr_23024_23090[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (10))){
var inst_22864 = (state_22965[(2)]);
var state_22965__$1 = state_22965;
if(cljs.core.truth_(inst_22864)){
var statearr_23025_23091 = state_22965__$1;
(statearr_23025_23091[(1)] = (14));

} else {
var statearr_23026_23092 = state_22965__$1;
(statearr_23026_23092[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (18))){
var inst_22871 = (state_22965[(2)]);
var inst_22872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22873 = [null,inst_22871];
var inst_22874 = (new cljs.core.PersistentVector(null,2,(5),inst_22872,inst_22873,null));
var state_22965__$1 = state_22965;
var statearr_23027_23093 = state_22965__$1;
(statearr_23027_23093[(2)] = inst_22874);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22965__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (42))){
var inst_22927 = (state_22965[(2)]);
var inst_22928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22929 = [null,inst_22927];
var inst_22930 = (new cljs.core.PersistentVector(null,2,(5),inst_22928,inst_22929,null));
var state_22965__$1 = state_22965;
var statearr_23028_23094 = state_22965__$1;
(statearr_23028_23094[(2)] = inst_22930);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22965__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (37))){
var inst_22913 = (state_22965[(2)]);
var state_22965__$1 = state_22965;
var statearr_23029_23095 = state_22965__$1;
(statearr_23029_23095[(2)] = inst_22913);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22965__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (8))){
var inst_22843 = (state_22965[(7)]);
var inst_22854 = inst_22843.cljs$lang$protocol_mask$partition0$;
var inst_22855 = (inst_22854 & (64));
var inst_22856 = inst_22843.cljs$core$ISeq$;
var inst_22857 = (inst_22855) || (inst_22856);
var state_22965__$1 = state_22965;
if(cljs.core.truth_(inst_22857)){
var statearr_23030_23096 = state_22965__$1;
(statearr_23030_23096[(1)] = (11));

} else {
var statearr_23031_23097 = state_22965__$1;
(statearr_23031_23097[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22966 === (49))){
var inst_22955 = (state_22965[(2)]);
var state_22965__$1 = state_22965;
var statearr_23032_23098 = state_22965__$1;
(statearr_23032_23098[(2)] = inst_22955);

(statearr_23032_23098[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
;
return ((function (switch__18225__auto__,c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function() {
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto__ = null;
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto____0 = (function (){
var statearr_23036 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23036[(0)] = taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto__);

(statearr_23036[(1)] = (1));

return statearr_23036;
});
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto____1 = (function (state_22965){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_22965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e23037){if((e23037 instanceof Object)){
var ex__18229__auto__ = e23037;
var statearr_23038_23099 = state_22965;
(statearr_23038_23099[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22965);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23037;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23100 = state_22965;
state_22965 = G__23100;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto__ = function(state_22965){
switch(arguments.length){
case 0:
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto____0.call(this);
case 1:
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto____1.call(this,state_22965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto____0;
taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto____1;
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var state__18339__auto__ = (function (){var statearr_23039 = f__18338__auto__.call(null);
(statearr_23039[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___23040);

return statearr_23039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___23040,map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
);


return ((function (map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function taoensso$sente$_start_chsk_router_BANG__$_stop_BANG_(){
return cljs.core.async.close_BANG_.call(null,ch_ctrl);
});
;})(map__22834,map__22834__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
});
/**
 * Creates a go-loop to call `(event-msg-handler <server-event-msg>)` and
 *   returns a `(fn stop! [])`. Catches & logs errors.
 * 
 *   Advanced users may instead prefer to write their own loop against `ch-recv`.
 */
taoensso.sente.start_server_chsk_router_BANG_ = (function taoensso$sente$start_server_chsk_router_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___23108 = arguments.length;
var i__7277__auto___23109 = (0);
while(true){
if((i__7277__auto___23109 < len__7276__auto___23108)){
args__7283__auto__.push((arguments[i__7277__auto___23109]));

var G__23110 = (i__7277__auto___23109 + (1));
i__7277__auto___23109 = G__23110;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((2) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((2)),(0),null)):null);
return taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7284__auto__);
});

taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__23104){
var vec__23105 = p__23104;
var map__23106 = cljs.core.nth.call(null,vec__23105,(0),null);
var map__23106__$1 = ((((!((map__23106 == null)))?((((map__23106.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23106.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23106):map__23106);
var opts = map__23106__$1;
var trace_evs_QMARK_ = cljs.core.get.call(null,map__23106__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__23106__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
return taoensso.sente._start_chsk_router_BANG_.call(null,new cljs.core.Keyword(null,"server","server",1499190120),ch_recv,event_msg_handler,opts);
});

taoensso.sente.start_server_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_server_chsk_router_BANG_.cljs$lang$applyTo = (function (seq23101){
var G__23102 = cljs.core.first.call(null,seq23101);
var seq23101__$1 = cljs.core.next.call(null,seq23101);
var G__23103 = cljs.core.first.call(null,seq23101__$1);
var seq23101__$2 = cljs.core.next.call(null,seq23101__$1);
return taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23102,G__23103,seq23101__$2);
});
/**
 * Creates a go-loop to call `(event-msg-handler <client-event-msg>)` and
 *   returns a `(fn stop! [])`. Catches & logs errors.
 * 
 *   Advanced users may instead prefer to write their own loop against `ch-recv`.
 */
taoensso.sente.start_client_chsk_router_BANG_ = (function taoensso$sente$start_client_chsk_router_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___23118 = arguments.length;
var i__7277__auto___23119 = (0);
while(true){
if((i__7277__auto___23119 < len__7276__auto___23118)){
args__7283__auto__.push((arguments[i__7277__auto___23119]));

var G__23120 = (i__7277__auto___23119 + (1));
i__7277__auto___23119 = G__23120;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((2) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((2)),(0),null)):null);
return taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7284__auto__);
});

taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__23114){
var vec__23115 = p__23114;
var map__23116 = cljs.core.nth.call(null,vec__23115,(0),null);
var map__23116__$1 = ((((!((map__23116 == null)))?((((map__23116.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23116.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23116):map__23116);
var opts = map__23116__$1;
var trace_evs_QMARK_ = cljs.core.get.call(null,map__23116__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__23116__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
return taoensso.sente._start_chsk_router_BANG_.call(null,cljs.core.not.call(null,new cljs.core.Keyword(null,"server","server",1499190120)),ch_recv,event_msg_handler,opts);
});

taoensso.sente.start_client_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_client_chsk_router_BANG_.cljs$lang$applyTo = (function (seq23111){
var G__23112 = cljs.core.first.call(null,seq23111);
var seq23111__$1 = cljs.core.next.call(null,seq23111);
var G__23113 = cljs.core.first.call(null,seq23111__$1);
var seq23111__$2 = cljs.core.next.call(null,seq23111__$1);
return taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23112,G__23113,seq23111__$2);
});
taoensso.sente.event_msg_QMARK_ = taoensso.sente.client_event_msg_QMARK_;
taoensso.sente.make_channel_socket_BANG_ = taoensso.sente.make_channel_socket_client_BANG_;
taoensso.sente.start_chsk_router_BANG_ = taoensso.sente.start_client_chsk_router_BANG_;
/**
 * DEPRECATED: Please use `start-chsk-router!` instead.
 */
taoensso.sente.start_chsk_router_loop_BANG_ = (function taoensso$sente$start_chsk_router_loop_BANG_(event_handler,ch_recv){
return taoensso.sente.start_client_chsk_router_BANG_.call(null,ch_recv,(function (ev_msg){
return event_handler.call(null,new cljs.core.Keyword(null,"event","event",301435442).cljs$core$IFn$_invoke$arity$1(ev_msg),new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861).cljs$core$IFn$_invoke$arity$1(ev_msg));
}));
});
/**
 * DEPRECATED. Please use `timbre/set-level!` instead.
 */
taoensso.sente.set_logging_level_BANG_ = (function taoensso$sente$set_logging_level_BANG_(level){
return taoensso.timbre.set_level_BANG_.call(null,level);
});
/**
 * DEPRECATED: Please use `ajax-lite` instead.
 */
taoensso.sente.ajax_call = taoensso.encore.ajax_lite;
/**
 * DEPRECATED
 */
taoensso.sente.default_chsk_url_fn = (function taoensso$sente$default_chsk_url_fn(path,p__23121,websocket_QMARK_){
var map__23124 = p__23121;
var map__23124__$1 = ((((!((map__23124 == null)))?((((map__23124.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23124.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23124):map__23124);
var location = map__23124__$1;
var adjusted_protocol = cljs.core.get.call(null,map__23124__$1,new cljs.core.Keyword(null,"adjusted-protocol","adjusted-protocol",37431492));
var host = cljs.core.get.call(null,map__23124__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var pathname = cljs.core.get.call(null,map__23124__$1,new cljs.core.Keyword(null,"pathname","pathname",-1420497528));
return [cljs.core.str(adjusted_protocol),cljs.core.str("//"),cljs.core.str(host),cljs.core.str((function (){var or__6207__auto__ = path;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return pathname;
}
})())].join('');
});

//# sourceMappingURL=sente.js.map?rel=1466954744990